(*************************************************************)
(* UDlgOpClusHAC.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*************************************************************)

unit UDlgOpClusHAC;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  lmdstdcA;

type
  TDlgOpPrmClusHAC = class(TDlgBaseOperatorParameter)
    rgBestClus: TRadioGroup;
    lmdSpinClusters: TLMDSpinEdit;
    rgDistNormalize: TRadioGroup;
    procedure rgBestClusClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;    
  end;

var
  DlgOpPrmClusHAC: TDlgOpPrmClusHAC;

implementation

uses UCompClusteringHAC;

{$R *.dfm}

{ TDlgOpPrmClusHAC }

procedure TDlgOpPrmClusHAC.ApplyModifications;
var prm: TOpPrmHAC;
begin
 prm:= OpPrm as TOpPrmHAC;
 prm.ModeBestSelection:= self.rgBestClus.ItemIndex;
 prm.NbClusters:= self.lmdSpinClusters.Value;
 prm.Normalization:= self.rgDistNormalize.ItemIndex;
end;

procedure TDlgOpPrmClusHAC.SetParameters;
var prm: TOpPrmHAC;
begin
 prm:= OpPrm as TOpPrmHAC;
 self.rgBestClus.ItemIndex:= prm.ModeBestSelection;
 self.lmdSpinClusters.Value:= prm.NbClusters;
 self.rgDistNormalize.ItemIndex:= prm.Normalization;
end;

procedure TDlgOpPrmClusHAC.rgBestClusClick(Sender: TObject);
begin
 if (self.rgBestClus.ItemIndex = 1)
  then self.lmdSpinClusters.Enabled:= TRUE
  else self.lmdSpinClusters.Enabled:= FALSE;
end;

end.
