(**********************************************************************)
(* UDlgOpPrmClusteringSOM.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**********************************************************************)

unit UDlgOpPrmClusteringSOM;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit,
  LMDMaskEdit;

type
  TDlgOpPrmClusKohonenSOM = class(TDlgBaseOperatorParameter)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    spinRowCount: TLMDSpinEdit;
    spinColCount: TLMDSpinEdit;
    rgDistNormalize: TRadioGroup;
    edLRate: TLMDMaskEdit;
    Label3: TLabel;
    rgSeedRnd: TRadioGroup;
  private
  public
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  DlgOpPrmClusKohonenSOM: TDlgOpPrmClusKohonenSOM;

implementation

uses UCompClusteringSOM, UCalcRndGenerator;

{$R *.dfm}

{ TDlgOpPrmClusKohonenSOM }

procedure TDlgOpPrmClusKohonenSOM.ApplyModifications;
var prm: TOpPrmSOM;
begin
 prm:= OpPrm as TOpPrmSOM;
 prm.RowCount:= spinRowCount.Value;
 prm.ColCount:= spinColCount.Value;
 prm.Normalization:= rgDistNormalize.ItemIndex;
 prm.LearningRate:= StrToFloat(edLRate.Text);
 prm.ModeRndGenerator:= TStartSeed(rgSeedRnd.ItemIndex); 
end;

procedure TDlgOpPrmClusKohonenSOM.SetParameters;
var prm: TOpPrmSOM;
begin
 prm:= OpPrm as TOpPrmSOM;
 spinRowCount.Value:= prm.RowCount;
 spinColCount.Value:= prm.ColCount;
 rgDistNormalize.ItemIndex:= prm.Normalization;
 edLRate.Text:= FormatFloat('0.00',prm.LearningRate);
 rgSeedRnd.ItemIndex:= ord(prm.ModeRndGenerator); 
end;

end.
