(**********************************************************************)
(* UDlgOpPrmClusteringLVQ.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**********************************************************************)

unit UDlgOpPrmClusteringLVQ;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit,
  LMDMaskEdit;

type
  TDlgOpPrmClusteringLVQ = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    spinClustersPerClass: TLMDSpinEdit;
    edLRate: TLMDMaskEdit;
    Label2: TLabel;
    spinIterations: TLMDSpinEdit;
    Label3: TLabel;
    rgNormalization: TRadioGroup;
    rgSeedRnd: TRadioGroup;
  private
    { Dclarations prives }
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmClusteringLVQ: TDlgOpPrmClusteringLVQ;

implementation

uses UCompClusteringLVQ, UCalcRndGenerator;

{$R *.dfm}

{ TDlgOpPrmClusteringLVQ }

procedure TDlgOpPrmClusteringLVQ.ApplyModifications;
var prm: TOpPrmLVQ;
begin
 prm:= OpPrm as TOpPrmLVQ;
 prm.NbClustersPerClass:= self.spinClustersPerClass.Value;
 prm.LearningRate:= StrToFloat(self.edLRate.Text);
 prm.NbIterations:= self.spinIterations.Value;
 prm.Normalization:= self.rgNormalization.ItemIndex;
 prm.ModeRndGenerator:= TStartSeed(rgSeedRnd.ItemIndex);  
end;

procedure TDlgOpPrmClusteringLVQ.SetParameters;
var prm: TOpPrmLVQ;
begin
 prm:= OpPrm as TOpPrmLVQ;
 self.spinClustersPerClass.Value:= prm.NbClustersPerClass;
 self.edLRate.Text:= Format('%.4f',[prm.LearningRate]);
 self.spinIterations.Value:= prm.NbIterations;
 self.rgNormalization.ItemIndex:= prm.Normalization;
 rgSeedRnd.ItemIndex:= ord(prm.ModeRndGenerator);  
end;

end.
