//////////////////////////////////////////////////////////
// Unit Computation - Clustering - Neighborhood Graph  //
// Fabrice Muhlenbach - cr en fvrier 2005            //
//////////////////////////////////////////////////////////

unit UCompClusteringNG;

{ inspir du modle LVQ }

interface

USES
        UCompDefinition, UCompClusteringDefinition, UOperatorDefinition,
        UCompManageDataSet, classes, UDataSetDefinition, UDataSetImplementation ,
        UDatasetExamples, Forms,
        //R.R. -- new -- 04/03/05
        Contnrs, UCalcStatDes,
        //R.R. -- new -- 11/05/2005 -- fonctions de sauvegarde et de paramtrage
        IniFiles ;

TYPE
        // Une liste d'lments comprenant des objets avec une valeur moyenne et un nom
        PointeurSurListe = ^LaListe;
        // Un objet de la liste avec la moyenne et le nom
        LaListe = record
             moyenne: double;
             nom: string;
         end;

        // Une liste reprsentant un tableau (de rels) en deux dimensions.
        // Tout d'abord les lignes...
        PointeurSurTableauDeReels = ^LaLigne;
        // et un objet de type ligne
        LaLigne = record
            Colonne : TList;
         end;
        // ...et les colonnes
        PointeurSurColonne = ^LaColonne;
        // avec un objet de type colonne contenant un rel.
        LaColonne = record
           d : double;
         end;

        // Une liste reprsentant un tableau (de boolens) en deux dimensions.
        // Tout d'abord les lignes...
        PointeurSurTableauDeConnexions = ^LigneConnexion;
        LigneConnexion = record
            ColConnexion : TList;
          end;
        // ...et les colonnes
        PointeurSurColConnexion = ^ColonneConnexion;
        ColonneConnexion = record
           connexion : boolean;
          end;

        // Une liste d'amas. L, ce n'est pas un tableau, le nombre de points
        // est variable pour chaque amas
        PointeurSurListeAmas = ^StructAmas;
        // Dans un amas, on a besoin de la liste des points de l'amas
        // en question, mais aussi de l'tiquette et des infos sur les artes
        StructAmas = record
           ListeAmas : TList;
           Etiquette : string;
           MoyLongArete : double;
           EcTypLongArete : double;
           nb_exemples : integer;
          end;
        // Dans un amas, on a besoin de la liste des points prsents
        PointeurSurNumExemple = ^StructPointAmas;
        StructPointAmas = record
           NumExemple : integer;
          end;

        // Une liste permettant de savoir si les points sont dj utiliss
        // (c'est--dire dj prsents dans un amas)
        PointsUtilises = ^Presence;
        // Un objet de la liste avec la moyenne et le nom
        Presence = record
             est_present: boolean;
         end;

        //R.R. -- new -- 04/03/05 -- dclaration forward pour accs aux donnes de l'oprateur
        TOpClusNG = class;

        //R.R. -- new -- 04/03/05 -- un amas avec des infos supplmentaires
        TRRAmas = class(TObject)
                  private
                  //l'amas avec les identificateurs F.M.
                  FAmas: PointeurSurListeAmas;
                  //code interne attribu  l'amas -- c'est le code de l'tiquette associe
                  FCodeEtiquetteAmas: TTypeDiscrete;
                  //liste des individus au format TListeIndividus
                  FExamples: TExamples;
                  //stat sur les descripteurs
                  FStats: TLstCalcStatDesContinuous;
                  //oprateur
                  FOperator: TOpClusNG; 
                  //rcuprer l'tiquette de l'amas
                  procedure   recupLabel(target: TAttribute);
                  //rcuprer dans mon format la liste des individus
                  procedure   recupExamples(source: TExamples);
                  //calculer les centres de gravit entre-autres
                  procedure   computeCharacteristics();
                  public
                  constructor create(prmAmas: PointeurSurListeAmas; operator: TOpClusNG);
                  destructor  destroy(); override;
                  //rcuprer la stat nj
                  function    getStat(j: integer): TCalcStatDesContinuous;
                  //!\ calculer la distance par rapport au centre de gravit de l'amas -- distance euclidienne simple, non pondre
                  function    getDistance(example: integer): double;
                  //properties...
                  property    CodeEtiquette: TTypeDiscrete read FCodeEtiquetteAmas write FCodeEtiquetteAmas;
                  end;

        //R.R. -- new -- 04/03/05 -- liste des amas filtrs
        TRRLstAmas = class(TObject)
                     private
                     FLstAmas: TObjectList;
                     FCoveredExamples: integer;
                     public
                     constructor create();
                     destructor  destroy(); override;
                     //ajouter un amas dans la liste
                     procedure add(amas: TRRAmas);
                     //!\trouver le code de l'tiquette de l'amas le plus proche
                     function getLabelNearestAmas(example: integer): TTypeDiscrete;
                     //!\donner le numro de cluster -- autre type de cration de la projection
                     function getNumeroAmas(example: integer): TTypeDiscrete;
                     //nombre d'amas dans la liste
                     function nbAmas(): integer;
                     //renvoyer le i-me amas
                     function getAmas(i: integer): TRRAmas;
                     end;   


        {gnrateur de composant}
        TGenClusNG = class(TMLGenComp)
                      protected
                      procedure   GenCompInitializations(); override;
                      public
                      function    GetClassMLComponent: TClassMLComponent; override;
                      end;


        {composant NG}
        TMLCompClusNG = class(TMLCompClustering)
                         protected
                         function    getClassOperator: TClassOperator; override;
                         function    getGenericAttName(): string; override;
                         end;

        {oprateur NG}
        TOpClusNG = class(TOpLocalData)
                     private
                     targetClass : TAttribute;
                     inputAttributes : TLstAttributes;
                     individus : TExamples;
                     sommeX : double;
                     ListeValeurs : TList;
                     TableauDistance : TList;
                     GVR : TList;
                     GrapheAmas : TList;
                     LesAmas : TList;
                     ListePointsUtilises : TList;

                     //R.R. -- new -- 04/03/05 -- amas filtrs avec les paramtres
                     FilteredAmas: TRRLstAmas;
                     //R.R. -- new -- 11/05/2005 -- identifiant de la modalit "positive" de l'attribute classe
                     FIdPositiveClass: TTypeDiscrete;


                        

                     protected
                     //R.R. -- new -- 04/03/05 -- filtrer les amas, ne conserver que les intrssants -- renvoie le nombre d'amas conservs
                     function   FilterAmasWithParameters(): integer;
                     //R.R. -- new -- 04/03/05 -- affecter une valeur  la projection  partir des amas associs -- TRUE si pas d'erreur
                     function   SetProjectionFromFilteredAmas(): boolean;
                     //F.M...
                     function    distance(i : integer ; j : integer) : double;
                     function    PointsConnectes(i : integer ; j : integer) : boolean;
                     function    CreationAmas(UnAmas : PointeurSurListeAmas) : PointeurSurListeAmas;
                     function    CompleteAmas(UnAmas : PointeurSurListeAmas; i : integer) : PointeurSurListeAmas;
                     function    CoreExecute(): boolean; override;
                     function    getClassParameter: TClassOperatorParameter; override;
                     function    CheckAttributes(): boolean; override;
                     public
                     function    getHTMLResultsSummary(): string; override;
                     //R.R. -- new -- 04/03/05-- dtruire les listes internes
                     destructor Destroy(); override;
                     end;


        {paramtre oprateur LVQ}
        TOpPrmNG = class(TOpPrmClustering)
                   private
                   //R.R. -- new -- 04/03/2005 -- fixer une taille minimale des amas  conserver
                   FMinAmasSize: integer;
                   //R.R. -- new -- 11/05/2005 - slection de la modalit "positive" de la variable  prdire
                   FPositiveClass: string;
                   //
                   protected
                   procedure   SetDefaultParameters(); override;
                   function    CreateDlgParameters(): TForm; override;
                   public
                   procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                   procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                   function    getHTMLParameters(): string; override;
                   //properties
                   property    MinAmasSize: integer read FMinAmasSize write FMinAmasSize;
                   property    PositiveClass: string read FPositiveClass write FPositiveClass;
                   end;




implementation

USES
        Sysutils, UConstConfiguration, UDlgOpPrmClusteringRNG, ULogFile,
        UStringAddBuffered;

CONST
        //nombre max. de colonnes  afficher pour le descriptif des amas
        MAX_COLUMN_TABLE_RESULT = 21;

{ TGenClusLVQ }

procedure TGenClusNG.GenCompInitializations;
begin
 FMLComp:= mlcClustering;
end;

function TGenClusNG.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompClusNG;
end;

function TMLCompClusNG.getClassOperator() : TClassOperator;
begin
 result := TOpClusNG;
end;

function TMLCompClusNG.getGenericAttName(): string;
begin
 result:= 'NG';
end;

function TOpClusNG.getClassParameter : TClassOperatorParameter;
begin
 result := TOpPrmNG;
end;

function TOpClusNG.CheckAttributes(): boolean;
var ok : boolean;
begin
 ok:= false;
 //rcuprer les inputs
 if (self.WorkData.LstAtts[asInput].Count>0) and self.WorkData.LstAtts[asInput].isAllCategory(caContinue)
  then
   begin
    ok:= true;
    self.inputAttributes:= self.WorkData.LstAtts[asInput];
   end;
  //rcuprer le target
  if ok and (self.WorkData.LstAtts[asTarget].Count=1) and self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete)
   then
    begin
     self.targetClass:= self.WorkData.LstAtts[asTarget].Attribute[0];
    end
   else ok:= false;
   //rcuprer les exemples
   if ok and (self.WorkData.Examples.Size>0)
    then
     begin
      self.individus:= self.WorkData.Examples;
     end
    else ok:= false;
 //
 result:= ok;
end;

function    TOpClusNG.CoreExecute(): boolean ;
var i,j,k: integer;
    curX: TAttribute;
    Enregistrement : PointeurSurListe;
    UneLigne : PointeurSurTableauDeReels ;
    UneColonne : PointeurSurColonne ;
    UneLigneConnexionGVR : PointeurSurTableauDeConnexions;
    UneColonneConnexionGVR : PointeurSurColConnexion;
    UneLigneConnexionGA : PointeurSurTableauDeConnexions;
    UneColonneConnexionGA : PointeurSurColConnexion;
    UnAmas : PointeurSurListeAmas;
    UnExemple, ExempleJ, ExempleK : PointeurSurNumExemple;
    DistanceCalculee : double;
    connexion : boolean ;
    distance_i_j, distance_i_k, distance_j_k : double;
    UnePresence : PointsUtilises ;
    LaSomme, SommeCarree, LaMoyenne, NbAretes, LEcartType : double;

    instI, instJ: integer;
begin
 TraceLog.WriteToLogFile('[NG] >> dbut des calculs');
 TRY

 //>> R.R. -- new -- 11/05/2005 -- rcupration de l'ID de la classe positive
 FIdPositiveClass:= self.targetClass.LstValues.isValueAvailable((self.PrmOp as TOpPrmNG).PositiveClass);
 //tester si c'est OK, sinon on plante exprs pour sortir de la fonction
 if (FIdPositiveClass = 0)
  then Raise Exception.Create('id of positive class value not available');
 //<<
  
 //

 ListeValeurs := TList.Create ;

 // Calcul des distances (distance euclidienne)
 //
 // pour tous les individus
 TableauDistance := TList.Create ;
 for i := 1 to (self.individus.Size) do
   begin
      instI:= self.individus.Number[i];
      // cration d'une ligne du tableau de distance
      new(UneLigne);
      UneLigne.Colonne := TList.Create;
      for j := 1 to (self.individus.Size) do
         begin
           instJ:= self.individus.Number[j]; 
           // cration d'une colonne du tableau de distance
           new(UneColonne);
           DistanceCalculee := 0;
           if (i <> j)
             then
               begin
                 for  k := 0 to pred(self.inputAttributes.Count) do
                   begin
                     curX := self.inputAttributes.Attribute[k];
                     DistanceCalculee := DistanceCalculee + sqr( curX.cValue[instI] - curX.cValue[instJ] );
                   end;
                 DistanceCalculee := sqrt(DistanceCalculee);
               end;
             // la distance est calcule
           UneColonne.d := DistanceCalculee ;
           UneLigne.Colonne.Add(UneColonne);
         end;
        TableauDistance.Add(UneLigne);
   end;
  // Les distances sont maintenant calcules
  TraceLog.WriteToLogFile('[NG] -- OK, calcul des distances');


  // Cration du graphe de voisinage et du graphe des amas
 GVR := TList.Create ;
 GrapheAmas := TList.Create ;
 for i := 1 to self.individus.Size do
   begin
      // cration d'une ligne des tableaux de graphes
      new(UneLigneConnexionGVR);
      new(UneLigneConnexionGA);
      UneLigneConnexionGVR.ColConnexion := TList.Create;
      UneLigneConnexionGA.ColConnexion := TList.Create;
      for j := 1 to self.individus.Size do
         begin
           // cration d'une colonne des tableaux de graphes
           new(UneColonneConnexionGVR);
           new(UneColonneConnexionGA);
           connexion := true;  // par dfaut, un point est connect  lui-mme (no matter)
           if (i <> j)
             then
               begin
                 distance_i_j := distance(i,j) ;
                 k := 1;
                 while (k <= self.individus.Size) and connexion do
                   begin
                      distance_i_k := distance(i,k);
                      distance_j_k := distance(j,k);
                      // Principe du graphes des voisins relatifs :
                      // il y a connexion si k ne se trouve pas dans
                      // la lunule forme par i et j.
                      // En clair (de lunule, oh, oh !), si la distance
                      // entre i et k et entre j et k n'est pas plus
                      // petite que celle entre i et j
                      connexion := connexion and
                          not  (  (distance_i_j > distance_i_k)
                              and (distance_i_j > distance_j_k) ) ;
                      k := k + 1;
                   end;
               end;
             // on sait maintenant si les points i et j sont connects
             UneColonneConnexionGVR.connexion := connexion ;
             // attention, pour le graphe des amas, des points sont
             // connects si, en plus, ils sont de la mme tiquette...
             connexion := connexion and
             (self.targetClass.sValue[self.individus.Number[i]] =
               self.targetClass.sValue[self.individus.Number[j]]) ;
             UneColonneConnexionGA.connexion := connexion;
             UneLigneConnexionGVR.ColConnexion.Add(UneColonneConnexionGVR);
             UneLigneConnexionGA.ColConnexion.Add(UneColonneConnexionGA);
         end;
        GVR.Add(UneLigneConnexionGVR);
        GrapheAmas.Add(UneLigneConnexionGA);
   end;

  TraceLog.WriteToLogFile('[NG] -- OK, graphe des voisins relatifs');

  // Ca y est, nous avons le graphe des voisins relatifs et celui des amas
  // On peut maintenant crer la liste des amas
  ////////////////////////////////////////////////////////
  // Adaptation de la construction des graphes...
  // Tout d'abord, la liste des points dj utiliss doit tre initialise  faux
  ListePointsUtilises := TList.Create ;
  for i := 1 to self.individus.Size do
    begin
       new(UnePresence);
       UnePresence.est_present := false;
       ListePointsUtilises.Add(UnePresence) ;
    end;

 LesAmas := TList.Create ;
 UnAmas := CreationAmas(UnAmas); // Construction du premier amas  vide
 UnAmas := CompleteAmas(UnAmas, 1) ; // On complte ce premier amas avec le 1er point
 LesAmas.Add(UnAmas) ;
 for i := 2 to self.individus.Size do
   begin
     UnePresence := ListePointsUtilises.Items[ i - 1];
     // Si un point n'est pas encore utilis dans l'ensemble des amas
     if Not (UnePresence.est_present) then
       begin
         UnAmas := CreationAmas(UnAmas); // Construction du premier amas  vide
         UnAmas := CompleteAmas(UnAmas, i) ;
         LesAmas.Add(UnAmas) ;
       end;
   end;

 TraceLog.WriteToLogFile('[NG] -- OK, calcul des amas');  

// Il faut complter les informations sur les amas :
// calcul des longueurs moyennes, carts-types et tiquettes
 for i := 0 to pred(LesAmas.Count) do
   begin
     UnAmas := LesAmas.Items[i];
     UnExemple := UnAmas.ListeAmas.Items[0];
     UnAmas.Etiquette := self.targetClass.sValue[self.individus.Number[UnExemple.NumExemple]];
     if (UnAmas.nb_exemples > 1) then
       begin
         LaSomme := 0;
         NbAretes := 0;
         for j := 0 to pred(UnAmas.ListeAmas.Count) - 1 do
           begin
             ExempleJ := UnAmas.ListeAmas.Items[j];
             for k := j + 1 to pred(UnAmas.ListeAmas.Count) do
               begin
                 ExempleK := UnAmas.ListeAmas.Items[k];
                 if PointsConnectes(ExempleJ.NumExemple, ExempleK.NumExemple) then
                   begin
                     NbAretes := NbAretes + 1;
                     LaSomme := LaSomme + distance(ExempleJ.NumExemple,ExempleK.NumExemple);
                     SommeCarree := LaSomme + sqr(distance(ExempleJ.NumExemple,ExempleK.NumExemple));
                   end;
               end;
           end;
         //
         // R.R. -- 11/05/2005 -- danger division par zro ou racine carre de valeur ngative
         // erreur dans cette portion lors du traitement des fichiers protines
         LaMoyenne:= 0.0;
         LEcartType:= 1.0;
         if (NbAretes > 0)
          then
           begin
            LaMoyenne := LaSomme / NbAretes;
            LEcartType := 1/NbAretes * (SommeCarree - sqr(LaMoyenne));
            //en cas de soucis de troncatures ou d'effets de bords... c'tait ici l'erreur !!!
            LEcartType := sqrt(abs(LEcartType));
           end
          else TraceLog.WriteToLogFile(format('[NG] avertissement, nbAretes = 0 pour amas n %d >> moyenne := 0, sigma := 1.0',[i]));
         //
         UnAmas.MoyLongArete := LaMoyenne;
         UnAmas.EcTypLongArete := LEcartType;
       end;
   end;

 TraceLog.WriteToLogFile('[NG] -- OK, calcul des complments infos sur les amas');

 //R.R. -- new -- 04/03/05 -- filtrer les amas puis effectuer les projections
 self.FilterAmasWithParameters();
 TraceLog.WriteToLogFile('[NG] -- OK, filtrage des amas');

 //renvoyer faux si aucune projection n'a t possible ? --  voir --
 self.SetProjectionFromFilteredAmas();
 TraceLog.WriteToLogFile('[NG] -- OK, projection  partir des amas filtrs');

 ////////////////////////////////////////////////////////
 // Ce qui suit, c'est juste pour le fun, a ne sert  rien...
 //somme de toutes les valeurs de X
 //pour chaque variable j
 for j:= 0 to pred(self.inputAttributes.Count) do
  begin
   curX:= self.inputAttributes.Attribute[j];

   sommeX := 0;
   new(Enregistrement);
   //pour chaque observation, on fait la somme pour le calcul de la moyenne
   for i:= 1 to self.individus.Size do
    sommeX:= sommeX + curX.cValue[self.individus.Number[i]];
   Enregistrement.moyenne := sommeX / self.individus.Size; // 'oil...
   Enregistrement.nom := 'Variable <b>X<sub>' + IntToStr(j + 1) + '</sub></b> (<i>'
   + self.inputAttributes.Attribute[j].Name + '</i>)';
   ListeValeurs.Add(Enregistrement);
  end;
 // Voil, c'est la fin du truc fun qui ne sert  rien...
 /////////////////////////////////////////////////////////

 result := true;
 TraceLog.WriteToLogFile('[NG] << fin des calculs');
 EXCEPT
 on E: Exception do
  begin
   TraceLog.WriteToLogFile('[NG] !!! ERREUR !!! :: ' + E.Message);
   result := false;
  end;
 END;
end;


// Cration d'un nouvel amas, vide de points
function    TOpClusNG.CreationAmas(UnAmas : PointeurSurListeAmas) : PointeurSurListeAmas;
var   UnExemple : PointeurSurNumExemple;

begin;
   new(UnAmas);
   UnAmas.MoyLongArete := 0;
   UnAmas.EcTypLongArete := 0;
   UnAmas.nb_exemples := 0;
   UnAmas.ListeAmas := TList.Create ;
   result := UnAmas;
end;

// Fonction rcursive qui complte l'amas en cours en lui ajoutant le point i et ses copains...
function    TOpClusNG.CompleteAmas(UnAmas : PointeurSurListeAmas ; i : integer) : PointeurSurListeAmas;
var   UnExemple : PointeurSurNumExemple;
      UnePresence : PointsUtilises;
      j : integer;

begin;
   UnePresence := ListePointsUtilises.Items[i - 1];
   UnePresence.est_present := true;
   UnAmas.nb_exemples := UnAmas.nb_exemples + 1;
   new(UnExemple);
   UnExemple.NumExemple := i;
   UnAmas.ListeAmas.Add(UnExemple);
   for j := 1 to self.individus.Size do
     begin
        if (i <> j) then
           begin
            UnePresence := ListePointsUtilises.Items[j - 1];
            if Not (UnePresence.est_present) then
              begin
                if PointsConnectes(i,j) then
                  UnAmas := CompleteAmas(UnAmas, j);
              end;
           end;
     end;
   result := UnAmas;
end;




function    TOpClusNG.distance(i : integer; j : integer): double;
var  k : integer;
     DistanceCalculee : double;
     UneLigne : PointeurSurTableauDeReels ;
     UneColonne : PointeurSurColonne ;

begin;
   DistanceCalculee := 0 ;
   if (i <> j) then
     begin
       if (i > j) then
          begin
             // on change les indices de i et j //
             k := i;
             i := j;
             j := k;
          end;
        UneLigne := TableauDistance.Items[i-1] ;
        UneColonne := UneLigne.Colonne.Items[j-1] ;
        DistanceCalculee := UneColonne.d ;
      end;
   result := DistanceCalculee;
end;

function    TOpClusNG.PointsConnectes(i : integer; j : integer): boolean;
var  k : integer;
     arete_presente : boolean;
     UneLigneConnexionGA : PointeurSurTableauDeConnexions;
     UneColonneConnexionGA : PointeurSurColConnexion;
begin;
   arete_presente := true ;
   if (i <> j) then
     begin
       if (i > j) then
          begin
             // on change les indices de i et j //
             k := i;
             i := j;
             j := k;
          end;
        UneLigneConnexionGA := GrapheAmas.Items[i-1] ;
        UneColonneConnexionGA := UneLigneConnexionGA.ColConnexion.Items[j-1] ;
        arete_presente := UneColonneConnexionGA.connexion ;
      end;
   result := arete_presente;
end;


function    TOpClusNG.getHTMLResultsSummary(): string;
var //s: string;
    i, j, k: integer;
    Enregistrement : PointeurSurListe;
    UneLigne : PointeurSurTableauDeReels ;
    UneColonne : PointeurSurColonne ;
    UneLigneConnexionGVR : PointeurSurTableauDeConnexions;
    UneColonneConnexionGVR : PointeurSurColConnexion;
    UneLigneConnexionGA : PointeurSurTableauDeConnexions;
    UneColonneConnexionGA : PointeurSurColConnexion;
    nb_a_GVR, nb_a_GA : integer;
    DistanceCalculee : double ;
    UnAmas : PointeurSurListeAmas ;
    UnExemple : PointeurSurNumExemple;
    UnePresence : PointsUtilises ;

    //R.R.
    aAmas: TRRAmas;
    curStat: TCalcStatDesContinuous;
    buf: TBufString;
begin

  buf:= TBufString.Create();
  buf.BeginUpdate();

  TraceLog.WriteToLogFile('[NG] >> dbut affichage des rsultats');

  //s := '';
  nb_a_GVR := 0;
  nb_a_GA := 0;

  // On compte le nombre d'artes dans les deux graphes,
  // le graphe des voisins relatifs et le graphe non connexe qui en est issu
  // aprs coupure pour isoler les amas
  for i := 1 to self.individus.Size - 1 do
   begin
      UneLigneConnexionGVR  := GVR.Items[i - 1];
      UneLigneConnexionGA := GrapheAmas.Items[i - 1];
      for j := i to self.individus.Size do
         begin
           UneColonneConnexionGVR := UneLigneConnexionGVR.ColConnexion[j - 1];
           UneColonneConnexionGA := UneLigneConnexionGA.ColConnexion[j - 1];
           if UneColonneConnexionGVR.connexion then nb_a_GVR := nb_a_GVR + 1 ;
           if UneColonneConnexionGA.connexion then nb_a_GA := nb_a_GA + 1;
          end;
   end;

   buf.AddStr('Number of edges in the Neighborhood Graph: ' + IntToStr(nb_a_GVR) + '<br>');
   buf.AddStr('Number of edges after the cut: ' + IntToStr(nb_a_GA) + '<br><hr>');

{
 s:= 'Etiquettes possibles de la variable Y&nbsp;: <br>';
 for k:= 1 to self.targetClass.nbValues do
   s:= s+IntToStr(k)+' : '+  self.targetClass.LstValues.getDescription(k)+'<br>';
 s := s + '<hr>';
 for j :=  0 to pred(ListeValeurs.Count) do
    begin
      Enregistrement := ListeValeurs.Items[j];
      s := s + Enregistrement.nom + '&nbsp;: '
         + 'Moyenne de <b>' + floattostrf(Enregistrement.moyenne, ffFixed, 5, 3)	+ '</b><br>' ;
    end;

 s := s+ '<hr>';
 s := s + 'Nombre d''individus : ' + IntToStr(self.individus.Size) + '<hr>' ;
}

   buf.AddStr('<H3>Computed clusters</H3>');
   buf.AddStr('Number of clusters: ' + IntToStr(LesAmas.Count) + '<br><ul>') ;
   for i := 0 to pred(LesAmas.Count) do
     begin
       UnAmas := LesAmas.Items[i];
       buf.AddStr( '<li>cluster ' + IntToStr(i+1) + ' with ' + IntToStr(UnAmas.nb_exemples ) +
        ' example(s) (<i><b>' + UnAmas.Etiquette + '</i></b>); edge size: mean = ' +
        floattostrf(UnAmas.MoyLongArete, ffFixed, 5, 3) +
        ', standard deviation = ' +
        floattostrf(UnAmas.EcTypLongArete , ffFixed, 5, 3) +
        '</li>');
     end;
   buf.AddStr('</ul><br><hr>');

   //R.R. -- new -- affichage des amas filtrs
   buf.AddStr('<H3>Filtered clusters</H3>');

   if (self.FilteredAmas.nbAmas()=0)
    then buf.AddStr('<P>No filtered clusters</P>')
    else
     begin
      buf.AddStr(format('<P>Number of clusters : <b>%d</b><br>',[self.FilteredAmas.nbAmas()]));
      buf.AddStr(format('Covered examples   : <b>%d</b> on %d<br>',[self.FilteredAmas.FCoveredExamples,self.individus.Size]));

      // new -- R.R. -- 11/05/2005 -- se donner une limite pour la description des clusters

      buf.AddStr('<P>'+HTML_HEADER_TABLE_RESULT);
      buf.AddStr(HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=3>Culsters</TH>');
      if (self.inputAttributes.Count < MAX_COLUMN_TABLE_RESULT)
       then buf.AddStr(format('<TH colspan=%d>Attributes description [min ; max] : average</TH></TR>',[self.inputAttributes.Count]));
      buf.AddStr('</TR>');

      buf.AddStr(HTML_TABLE_COLOR_HEADER_BLUE+'<TH>N</TH><TH>Class-value</TH><TH>size</TH>');
      if (self.inputAttributes.Count < MAX_COLUMN_TABLE_RESULT)
       then
        begin
          for j:= 0 to pred(self.inputAttributes.Count) do
           buf.AddStr(format('<TH>%s</TH>',[self.inputAttributes.Attribute[j].Name]));
        end;
      buf.AddStr('</TR>');
      
      for i:= 0 to pred(self.FilteredAmas.nbAmas()) do
       begin
        aAmas:= FilteredAmas.getAmas(i);
        if assigned (aAmas)
         then
          begin
           //premires caractristiques
           buf.AddStr(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>%d</TD><TD align="left">%s</TD><TD align="right">%d</TD>',[succ(i),aAmas.FAmas.Etiquette,aAmas.FAmas.nb_exemples]));
           
           //valeurs des statistiques pour chaque variable
           if (self.inputAttributes.Count < MAX_COLUMN_TABLE_RESULT)
            then
             begin
               for j:= 0 to pred(self.inputAttributes.Count) do
                begin
                 curStat:= aAmas.getStat(j);
                 buf.AddStr(format('<TD>[%.3f ; %.3f] : %.3f</TD>',[curStat.Min,curStat.Max,curStat.Average]));
                end;
             end;
             
           //finir la ligne
           buf.AddStr('</TR>');
          end;
       end;
      buf.AddStr('</TABLE>');
     end;
   //

  TraceLog.WriteToLogFile('[NG] << fin affichage des rsultats');


  TraceLog.WriteToLogFile('[NG] >> dbut nettoyage');

   // On nettoie tout !!!
   // Nettoyage de la liste ListeValeurs
   for i := 0 to pred(ListeValeurs.Count) do
     begin
       Enregistrement := ListeValeurs.Items[i];
       Dispose(Enregistrement);
     end;
   ListeValeurs.free;

   // Nettoyage du tableau des distances
   if (TableauDistance <> nil) then
     begin
       for i := 0 to pred(TableauDistance.Count) do
         begin
           UneLigne := TableauDistance.Items[i];
           for j := 0 to pred(UneLigne.Colonne.Count) do
             begin
               UneColonne := UneLigne.Colonne.Items[j];
               Dispose(UneColonne);
             end;
           Dispose(UneLigne);
         end;
       TableauDistance.Free ;
     end;

   // Nettoyage des graphes
   // D'abord le graphe des voisins relatifs...
   if (GVR <> nil) then
     begin
       for i := 0 to pred(GVR.Count) do
         begin
           UneLigneConnexionGVR := GVR.Items [i];
           for j := 0 to pred(UneLigneConnexionGVR.ColConnexion.Count) do
             begin
               UneColonneConnexionGVR := UneLigneConnexionGVR.ColConnexion.Items[j];
               Dispose(UneColonneConnexionGVR);
             end;
           Dispose(UneLigneConnexionGVR);
         end;
       GVR.Free ;
     end;

   // ...puis les amas...
   if (GrapheAmas <> nil) then
     begin
       for i := 0 to pred(GrapheAmas.Count) do
         begin
           UneLigneConnexionGA := GrapheAmas.Items [i];
           for j := 0 to pred(UneLigneConnexionGA.ColConnexion.Count) do
             begin
               UneColonneConnexionGA := UneLigneConnexionGA.ColConnexion.Items[j];
               Dispose(UneColonneConnexionGA);
             end;
           Dispose(UneLigneConnexionGA);
         end;
       GrapheAmas.Free ;
     end;

   // Suppression de l'ensemble des amas
   if (LesAmas <> nil) then
     begin
       for i := 0 to pred(LesAmas.Count) do
         begin
           UnAmas := LesAmas.Items [i];
           for j := 0 to pred(UnAmas.ListeAmas.Count) do
             begin
               UnExemple := UnAmas.ListeAmas.Items[j];
               Dispose(UnExemple);
             end;
           Dispose(UnAmas);
         end;
       LesAmas.Free ;
     end;

   // Suppression de la liste des points utiliss
   if (ListePointsUtilises <> nil) then
     begin
       for i := 0 to pred(ListePointsUtilises.Count) do
         begin
           UnePresence := ListePointsUtilises.Items[i] ;
           Dispose(UnePresence);
         end;
       ListePointsUtilises.Free ;
     end;

  TraceLog.WriteToLogFile('[NG] << fin nettoyage');

  buf.EndUpdate();
  result:= buf.BufS;
  buf.Free();
end;

procedure   TOpPrmNG.SetDefaultParameters();
begin
 //new -- R.R. -- 04/03/05 -- fixer une taille limite des amas  conserver
 FMinAmasSize:= 5;
 //11/05/2005
 FPositiveClass:= '';
end;

function    TOpPrmNG.CreateDlgParameters(): TForm;
begin
 result:= TdlgOpPrmClusteringNG.CreateFromOpPrm(self);
end;


destructor TOpClusNG.Destroy;
begin
 if assigned(FilteredAmas) then FreeAndNil(FilteredAmas);
 inherited;
end;

function TOpClusNG.FilterAmasWithParameters: integer;
var prmMinSize: integer;
    i: integer;
    UnAmas : PointeurSurListeAmas ;
begin
 // taille ref amas
 prmMinSize:= (self.PrmOp as TOpPrmNG).MinAmasSize;
 //prparer la liste des amas filtrs
 if assigned(FilteredAmas) then FreeAndNil(FilteredAmas);
 FilteredAmas:= TRRLstAmas.create();
 //lister les amas et vrifier leur taille
 for i := 0 to pred(LesAmas.Count) do
  begin
   UnAmas := LesAmas.Items[i];
   if (UnAmas.nb_exemples>=prmMinSize)
    then FilteredAmas.add(TRRAmas.create(UnAmas,self));
  end;
 //puis renvoyer le nombre d'amas collects
 result:= FilteredAmas.nbAmas();
end;

function TOpClusNG.SetProjectionFromFilteredAmas: boolean;
var i: integer;
    attProj: TAttribute;
begin
 TRY
 //rcuprer la projection
 attProj:= (self.MLOwner as TMLCompClusNG).AttCluster;
 //mj le descriptif des valeurs
 //attProj.LstValues.assign(self.targetClass.LstValues);
 //variante ??? -- crer des clusters avec les numros associs
 attProj.LstValues.clear();
 for i:= 1 to self.FilteredAmas.nbAmas do
  attProj.LstValues.getValue('clus_'+inttostr(i));
 //affectation...
 if (self.FilteredAmas.nbAmas>0)
  then
   begin
    //on remplit toute la colonne -- mme les non-slectionns
    for i:= 1 to self.targetClass.Size do
     // -- ??? variante ??? -- attProj.dValue[i]:= self.FilteredAmas.getLabelNearestAmas(i);
     attProj.dValue[i]:= self.FilteredAmas.getNumeroAmas(i); 
   end
  else
   begin
    for i:= 1 to self.targetClass.Size do
     attProj.dValue[i]:= 1;//temporaire -- totalement arbitraire pour l'instant --  voir -- #ToDo1
   end;
 result:= true;
 EXCEPT
 result:= false;
 END;
end;

{ TRRAmas }

procedure TRRAmas.computeCharacteristics;
begin
 FStats:= TLstCalcStatDesContinuous.Create(FOperator.inputAttributes,FExamples);
end;

constructor TRRAmas.create(prmAmas: PointeurSurListeAmas; operator: TOpClusNG);
begin
 inherited Create();
 FAmas:= prmAmas;
 FOperator:= operator;
 //rcuprer l'tiquette
 self.recupLabel(Foperator.targetClass);
 //rcuprer les individus
 self.recupExamples(FOperator.individus);
 //calculer les centres de gravit et autres stats
 self.computeCharacteristics();
end;

destructor TRRAmas.destroy;
begin
 if assigned(FExamples) then FExamples.Free();
 if assigned(FStats) then FStats.Free();
 inherited;
end;

function TRRAmas.getDistance(example: integer): double;
var somme: double;
    j: integer;
    curStat: TCalcStatDesContinuous;
begin
 somme:= 0.0;
 for j:= 0 to pred(FStats.Count) do
  begin
   curStat:= FStats.Stat(j) as TCalcStatDesContinuous;
   //distance euclidienne non-pondre au centre de gravit
   somme:= somme+SQR(curStat.Average-curStat.Attribute.cValue[example]);
  end;
 result:= somme;
end;

function TRRAmas.getStat(j: integer): TCalcStatDesContinuous;
begin
 if (j>=0) and (j<FStats.Count)
  then result:= FStats.Stat(j) as TCalcStatDesContinuous
  else result:= NIL;
end;

procedure TRRAmas.recupExamples(source: TExamples);
var i: integer;
    UnExemple: PointeurSurNumExemple;
begin
 FExamples:= TExamples.Create(FAmas.nb_exemples);
 FExamples.BeginAdd();
 for i:= 0 to pred(FAmas.nb_exemples) do
  begin
   UnExemple:= FAmas.ListeAmas.Items[i];
   //car F.M. utilise les numros locaux -- donc d-rfrencer pour avoir le numro dans la population
   FExamples.AddExample(source.Number[UnExemple.NumExemple]);
  end;
 FExamples.EndAdd();
end;

procedure TRRAmas.recupLabel(target: TAttribute);
begin
 FCodeEtiquetteAmas:= target.LstValues.isValueAvailable(FAmas.Etiquette);
end;

{ TRRLstAmas }

procedure TRRLstAmas.add(amas: TRRAmas);
begin
 FLstAmas.Add(amas);
 FCoveredExamples:= FCoveredExamples+amas.FAmas.nb_exemples;
end;

constructor TRRLstAmas.create();
begin
 inherited Create();
 FCoveredExamples:= 0;
 FLstAmas:= TObjectList.Create(TRUE);
end;

destructor TRRLstAmas.destroy;
begin
 if assigned(FLstAmas) then FLstAmas.Free();
 inherited;
end;

function TRRLstAmas.getAmas(i: integer): TRRAmas;
begin
 if (i>=0) and (i<self.nbAmas())
  then result:= FLstAmas.Items[i] as TRRAmas
  else result:= nil;
end;

function TRRLstAmas.getLabelNearestAmas(example: integer): TTypeDiscrete;
var i: integer;
    dist,minDist: double;
    optAmas: TRRAmas;
begin
 optAmas:= nil;
 minDist:= +1.0e308;
 for i:= 0 to pred(self.nbAmas()) do
  begin
   dist:= self.getAmas(i).getDistance(example);
   if (dist<minDist)
    then
     begin
      minDist:= dist;
      optAmas:= self.getAmas(i);
     end;
  end;
 //alors, alors ??
 if assigned(optAmas)
  then result:= optAmas.CodeEtiquette
  //il y a un srieux pbm si on est  ce stade...
  else result:= 0;
end;

function TRRLstAmas.getNumeroAmas(example: integer): TTypeDiscrete;
var i,iMin: integer;
    dist,minDist: double;
begin
 iMin:= 0;
 minDist:= +1.0e308;
 for i:= 0 to pred(self.nbAmas()) do
  begin
   dist:= self.getAmas(i).getDistance(example);
   if (dist<minDist)
    then
     begin
      minDist:= dist;
      iMin:= succ(i);
     end;
  end;
 //alors, alors ?? -- souci s'il y a plus de 255 amas !!!
 result:= iMin;
end;

function TRRLstAmas.nbAmas: integer;
begin
 result:= FLstAmas.Count;
end;

function TOpPrmNG.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan="2">Parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Min size of amas</TD><TD align="right">%d</TD></TR>',[FMinAmasSize]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Class value</TD><TD align="right">%s</TD></TR>',[FPositiveClass]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmNG.LoadFromINI(prmSection: string; prmINI: TMemIniFile);
begin
 FMinAmasSize:= prmINI.ReadInteger(prmSection,'min_amas_size',FMinAmasSize);
 FPositiveClass:= prmINI.ReadString(prmSection,'positive_value',FPositiveClass);
end;

procedure TOpPrmNG.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'min_amas_size',FMinAmasSize);
 prmINI.WriteString(prmSection,'positive_value',FPositiveClass);
end;

initialization
 registerclass(TGenClusNG);
end.
