(**************************************************************************)
(* UDlgOpPrmSDCrossTabulation.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**************************************************************************)

unit UDlgOpPrmSDCrossTabulation;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit,
  LMDMaskEdit;

type
  TDlgOpPrmSDCrossTab = class(TDlgBaseOperatorParameter)
    chkSort: TCheckBox;
    rgSort: TRadioGroup;
    rgInputList: TRadioGroup;
    GroupBox1: TGroupBox;
    edCThresold: TLMDMaskEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure chkSortClick(Sender: TObject);
  private

  public
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  DlgOpPrmSDCrossTab: TDlgOpPrmSDCrossTab;

implementation

uses UCompSDCrossTabutation;

{$R *.dfm}

{ TDlgOpPrmSDCrossTab }

procedure TDlgOpPrmSDCrossTab.ApplyModifications;
begin
 (OpPrm as TOpPrmSDCrossTab).SortResult:= chkSort.Checked;
 (OpPrm as TOpPrmSDCrossTab).SortCriteria:= rgSort.ItemIndex;
 (OpPrm as TOpPrmSDCrossTab).InputList:= rgInputList.ItemIndex;
 (OpPrm as TOpPrmSDCrossTab).ContribThresold:= StrToFloat(edCThresold.Text);
end;

procedure TDlgOpPrmSDCrossTab.SetParameters;
begin
 chkSort.Checked:= (OpPrm as TOpPrmSDCrossTab).SortResult;
 rgSort.ItemIndex:= (OpPrm as TOpPrmSDCrossTab).SortCriteria;
 rgInputList.ItemIndex:= (OpPrm as TOpPrmSDCrossTab).InputList;
 edCThresold.Text:= FormatFloat('0.00',(OpPrm as TOpPrmSDCrossTab).ContribThresold);
end;

procedure TDlgOpPrmSDCrossTab.chkSortClick(Sender: TObject);
begin
 if chkSort.Checked
  then rgSort.Enabled:= TRUE
  else rgSort.Enabled:= FALSE;
end;

end.
