(***********************************************************************)
(* UCompSDKRelatedFriedman.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Anova de Friedman pour K chantillons apparis)
@author(Ricco)
@created(04/08/2005)

Friedman Two way ANOVA -- Siegel, p.174
}
unit UCompSDKRelatedFriedman;

interface

USES
    UCompDefinition,
    UOperatorDefinition,
    UCompSDKRelatedDefinition,
    UCalcStatDesKRelatedSamples,
    UDatasetDefinition;

TYPE
    //gnrateur
    TMLGenSDKRelatedFriedman = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

    //composant
    TMLCompSDKRelatedFriedman = class(TMLCompSDKRelated)
                                protected
                                function    getClassOperator: TClassOperator; override;
                                end;

    //oprateur
    TOpSDKRelatedFriedman = class(TOpSDKRelated)
                            protected
                            function    getCalcInstance(lstAtts: TLstAttributes): TCalcSDKRelated; override;
                            function    getClassParameter: TClassOperatorParameter; override;
                            end;

    //paramtrage
    TOpPrmSDKRelatedFriedman = class(TOpPrmSDKRelated)
                               end;     


implementation

USES
    Classes;

{ TMLGenSDKRelatedFriedman }

procedure TMLGenSDKRelatedFriedman.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenSDKRelatedFriedman.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDKRelatedFriedman; 
end;

{ TMLCompSDKRelatedFriedman }

function TMLCompSDKRelatedFriedman.getClassOperator: TClassOperator;
begin
 result:= TOpSDKRelatedFriedman; 
end;

{ TOpSDKRelatedFriedman }

function TOpSDKRelatedFriedman.getCalcInstance(lstAtts: TLstAttributes): TCalcSDKRelated;
begin
 result:= TCalcSDKRelatedFriedman.create(lstAtts);  
end;

function TOpSDKRelatedFriedman.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDKRelatedFriedman; 
end;

initialization
 RegisterClass(TMLGenSDKRelatedFriedman);
end.
