(***********************************************************************)
(* UCompSDKRelatedWKendall.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Coefficient de concordance de Kendall)
@author(Ricco)
@created(05/08/2005)

Coefficient de concordance W de Kendall -- Siegel, p.262
}
unit UCompSDKRelatedWKendall;

interface

USES
    UCompDefinition,
    UOperatorDefinition,
    UCompSDKRelatedDefinition,
    UCalcStatDesKRelatedSamples,
    UDatasetDefinition;

TYPE
    //gnrateur
    TMLGenSDKRelatedWKendall = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

    //composant
    TMLCompSDKRelatedWKendall = class(TMLCompSDKRelated)
                                protected
                                function    getClassOperator: TClassOperator; override;
                                end;

    //oprateur
    TOpSDKRelatedWKendall = class(TOpSDKRelated)
                            protected
                            function    getCalcInstance(lstAtts: TLstAttributes): TCalcSDKRelated; override;
                            function    getClassParameter: TClassOperatorParameter; override;
                            end;

    //paramtrage
    TOpPrmSDKRelatedWKendall = class(TOpPrmSDKRelated)
                               end;     


implementation

USES
    Classes;

{ TMLGenSDKRelatedWKendall }

procedure TMLGenSDKRelatedWKendall.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenSDKRelatedWKendall.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDKRelatedWKendall; 
end;

{ TMLCompSDKRelatedWKendall }

function TMLCompSDKRelatedWKendall.getClassOperator: TClassOperator;
begin
 result:= TOpSDKRelatedWKendall; 
end;

{ TOpSDKRelatedWKendall }

function TOpSDKRelatedWKendall.getCalcInstance(lstAtts: TLstAttributes): TCalcSDKRelated;
begin
 result:= TCalcSDKRelatedWKendall.create(lstAtts);  
end;

function TOpSDKRelatedWKendall.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDKRelatedWKendall; 
end;

initialization
 RegisterClass(TMLGenSDKRelatedWKendall);
end.
