(******************************************************************)
(* UCompSDMannWhitney.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Comparaison de populations, mais avec une approche non paramtrique, celle de Mann-Whitney)
@author(Ricco)
@created(13/07/2005)

Finalement, c'est un cas particulier du Kruskal & Wallis ! L'implmentation est facilite.
On en profite galement pour fournir la stat de White.

}

unit UCompSDMannWhitney;

interface

USES
   UCompDefinition, UOperatorDefinition,
   UCompSDCondDescDefinition,UCalcStatDesConditionnalDesc;

TYPE
   //gnrateur
   TMLGenCompSDMWhitney = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

   //composant
   TMLCompSDMWhitney = class(TMLCompSDCondDescDefinition)
                       protected
                       function    getClassOperator: TClassOperator; override;
                       end;

   //oprateur
   TOpSDMWhitney = class(TOpSDCondDescBinary)
                   protected
                   function    getClassStat(): TClassCalcSDCondDesc; override;
                   function    getClassLstStat(): TClassLstCalcStatDesCond; override;
                   function    getClassParameter: TClassOperatorParameter; override;
                   end;

   //paramtrage
   TOpSDPrmMWhitney = class(TOpPrmSDCondDescDefinition)
                      end;


implementation

USES
   Classes;

{ TMLGenCompSDMWhitney }

procedure TMLGenCompSDMWhitney.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDMWhitney.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDMWhitney;
end;

{ TMLCompSDMWhitney }

function TMLCompSDMWhitney.getClassOperator: TClassOperator;
begin
 result:= TOpSDMWhitney;
end;

{ TOpSDMWhitney }

function TOpSDMWhitney.getClassLstStat: TClassLstCalcStatDesCond;
begin
 result:= TLstCalcStatDesCondMWhitney;
end;

function TOpSDMWhitney.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpSDPrmMWhitney;
end;

function TOpSDMWhitney.getClassStat: TClassCalcSDCondDesc;
begin
 result:= TCalcSDNonParamCondDescBinary; 
end;

initialization
 RegisterClass(TMLGenCompSDMWhitney);
end.
