(****************************************************************************)
(* UDlgOpPrmSDLinearCorrelation.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************************)

unit UDlgOpPrmSDLinearCorrelation;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls;

type
  TDlgOpPrmLinearCorrelation = class(TDlgBaseOperatorParameter)
    chkSort: TCheckBox;
    rgSort: TRadioGroup;
    rgInputList: TRadioGroup;
    procedure chkSortClick(Sender: TObject);
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmLinearCorrelation: TDlgOpPrmLinearCorrelation;

implementation

uses UCompSDLinearCorrelation;

{$R *.dfm}

{ TDlgOpPrmLinearCorrelation }

procedure TDlgOpPrmLinearCorrelation.ApplyModifications;
begin
 (OpPrm as TOpPrmSDCorrelation).SortResult:= chkSort.Checked;
 (OpPrm as TOpPrmSDCorrelation).SortCriteria:= rgSort.ItemIndex;
 (OpPrm as TOpPrmSDCorrelation).InputList:= rgInputList.ItemIndex;
end;

procedure TDlgOpPrmLinearCorrelation.SetParameters;
begin
 chkSort.Checked:= (OpPrm as TOpPrmSDCorrelation).SortResult;
 rgSort.ItemIndex:= (OpPrm as TOpPrmSDCorrelation).SortCriteria;
 rgInputList.ItemIndex:= (OpPrm as TOpPrmSDCorrelation).InputList;
end;

procedure TDlgOpPrmLinearCorrelation.chkSortClick(Sender: TObject);
begin
 if chkSort.Checked
  then rgSort.Enabled:= TRUE
  else rgSort.Enabled:= FALSE;
end;

end.
