(**************************************************************************)
(* UCompSDSpearmanCorrelation.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(**************************************************************************)

{
@abstract(Composant corrlations croises -- Corrlation de Kendall (tau))
@author(Ricco)
@created(15/07/2005)

Fond sur les "agreements" et "disagreements"

Rf: Siegel pp. 245

}

unit UCompSDKendallCorrelation;

interface

USES
   UCompDefinition,
   UOperatorDefinition,
   UCompSDLinearCorrelation,
   UCalcStatDesCorrelation;

TYPE
   //gnrateur
   TMLGenCompSDKendallCorr = class(TMLGenComp)
                              protected
                              procedure   GenCompInitializations(); override;
                              public
                              function    GetClassMLComponent: TClassMLComponent; override;
                              end;
                              
   //composant
   TMLCompSDKendallCorr = class(TMLCompSDCorrelation)
                           protected
                           function    getClassOperator: TClassOperator; override;
                           end;

   //oprateur
   TOpSDKendallCorr = class(TOpSDCorrelation)
                       protected
                       procedure   InitializeListStat(); override;
                       function    getClassParameter: TClassOperatorParameter; override;
                       function    getClassCorrelation(): TClassCalcSDCorrelation; override;
                       end;

   //paramtrage
   TOpPrmSDKendallCorr = class(TOpPrmSDCorrelation)
                          end; 


implementation

USES
   Classes;

{ TMLGenCompSDKendallCorr }

procedure TMLGenCompSDKendallCorr.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDKendallCorr.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDKendallCorr; 
end;

{ TMLCompSDKendallCorr }

function TMLCompSDKendallCorr.getClassOperator: TClassOperator;
begin
 result:= TOpSDKendallCorr;
end;

{ TOpSDKendallCorr }

function TOpSDKendallCorr.getClassCorrelation: TClassCalcSDCorrelation;
begin
 result:= TCalcSDKendallCorr;
end;

function TOpSDKendallCorr.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDKendallCorr;
end;

procedure TOpSDKendallCorr.InitializeListStat;
begin
 FLstStat:= TLstCalcSDKendallCorr.Create(nil,nil);
end;

initialization
 RegisterClass(TMLGenCompSDKendallCorr);
end.
