(**************************************************************************)
(* UCompSDSpearmanCorrelation.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(**************************************************************************)

{
@abstract(Composant corrlations croises -- Corrlation de rangs de Spearman)
@author(Ricco)
@created(15/07/2005)

Mme fonctionnement que la corrlation de Pearson mais en utilisant les rangs
On utilise les rangs moyens en cas d'ex-aequo et on corrige en consquence la stat.
Rf: Siegel pp. 235

}
unit UCompSDSpearmanCorrelation;

interface

USES
   UCompDefinition,
   UOperatorDefinition,
   UCompSDLinearCorrelation,
   UCalcStatDesCorrelation;

TYPE
   //gnrateur
   TMLGenCompSDSpearmanCorr = class(TMLGenComp)
                              protected
                              procedure   GenCompInitializations(); override;
                              public
                              function    GetClassMLComponent: TClassMLComponent; override;
                              end;
                              
   //composant
   TMLCompSDSpearmanCorr = class(TMLCompSDCorrelation)
                           protected
                           function    getClassOperator: TClassOperator; override;
                           end;

   //oprateur
   TOpSDSpearmanCorr = class(TOpSDCorrelation)
                       protected
                       procedure   InitializeListStat(); override;
                       function    getClassParameter: TClassOperatorParameter; override;
                       function    getClassCorrelation(): TClassCalcSDCorrelation; override;
                       end;

   //paramtrage
   TOpPrmSDSpearmanCorr = class(TOpPrmSDCorrelation)
                          end; 


implementation

USES
   Classes;

{ TMLGenCompSDSpearmanCorr }

procedure TMLGenCompSDSpearmanCorr.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDSpearmanCorr.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDSpearmanCorr;
end;

{ TMLCompSDSpearmanCorr }

function TMLCompSDSpearmanCorr.getClassOperator: TClassOperator;
begin
 result:= TOpSDSpearmanCorr;
end;

{ TOpSDSpearmanCorr }

function TOpSDSpearmanCorr.getClassCorrelation: TClassCalcSDCorrelation;
begin
 result:= TCalcSDSpearmanCorr;
end;

function TOpSDSpearmanCorr.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDSpearmanCorr;
end;

procedure TOpSDSpearmanCorr.InitializeListStat;
begin
 FLstStat:= TLstCalcSDSpearmanCorr.Create(nil,nil);
end;

initialization
 RegisterClass(TMLGenCompSDSpearmanCorr);
end.
