(***************************************************************************)
(* UCompSDPairedTestDefinition.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***************************************************************************)

{
@abstract(composant de base pour les comparaisons de populations sur chantillons apparis)
@author(Ricco)
@created(17/07/2005)

Permet de remonter  un niveau plus gnrique le contrle des attributs et l'appel
des classes de calcul

}

unit UCompSDPairedTestDefinition;

interface

USES
   UCompSDDefinition,
   UCalcStatDesPairedTest;

TYPE
   //classe de composant gnrique
   TMLCompSDPairedTestDefintion = class(TMLCompSD)
                                  protected
                                  function    GetLogResultDescription(): string; override;
                                  end;

   //classe de calcul gnrique
   TOpSDPairedTestDefinition = class(TOpSD)
                               protected
                               //rcuprer la classe de calcul individuelle -- surcharge obligatoire
                               function getClassStat(): TClassCalcSDPairedTest; virtual; abstract;
                               //rcuprer la classe de liste de rsultats -- surcharge obligatoire
                               function getClassLstStat(): TClassLstCalcSDPairedTest; virtual; abstract;
                               //construire la liste initiale vide -- ne pas surcharger par la suite
                               procedure   InitializeListStat(); override;
                               //construire les stats et ajouter dans la liste -- ne pas surcharger
                               procedure   RebuildStatDes(); override;
                               //tester la conformit des attributs avec les calculs -- surcharger uniquement dans le cas binaire (comparaison de 2 populations)
                               function    CheckAttributes(): boolean; override;
                               end;

   //classe de paramtrage gnrique -- uniquement pour le tri en ralit
   TOpPrmSDPairedTestDefinition = class(TOpPrmSD)
                                  end;
                                 

implementation

USES
   Sysutils,
   UDatasetDefinition,
   UDatasetImplementation;

{ TMLCompSDPairedTestDefintion }

function TMLCompSDPairedTestDefintion.GetLogResultDescription: string;
begin
 result:= Format('[PAIRED TEST] %d continuous attributes vs. %d discrete one, %d examples',[(Operator as TOpSDPairedTestDefinition).WorkData.LstAtts[asTarget].Count,
                (Operator as TOpSDPairedTestDefinition).WorkData.LstAtts[asInput].Count,(Operator as TOpSDPairedTestDefinition).WorkData.Examples.Size]);
end;

{ TOpSDPairedTestDefinition }

function TOpSDPairedTestDefinition.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= (self.WorkData.LstAtts[asTarget].Count>0) and (self.WorkData.LstAtts[asTarget].isAllCategory(caContinue));
 ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caContinue));
 //and then...
 result:= ok;
end;

procedure TOpSDPairedTestDefinition.InitializeListStat;
begin
 FLstStat:= getClassLstStat.Create(nil,nil);
end;

procedure TOpSDPairedTestDefinition.RebuildStatDes;
var attOne, attTwo: TAttribute;
    i,j: integer;
    stat: TCalcSDPairedTest;
begin
 self.LstStat.FreeAll();
 //pour chaque variable INPUT
 for j:= 0 to pred(workdata.LstAtts[asInput].Count) do
  begin
   attTwo:= workdata.LstAtts[asInput].Attribute[j];
   //le type est ok ?
   if attTwo.isCategory(caContinue)
    then
     begin
      //les variables TARGET
      for i:= 0 to pred(WorkData.LstAtts[asTarget].Count) do
       begin
        attOne:= WorkData.LstAtts[asTarget].Attribute[i];
        //petit test quand mme
        if attOne.isCategory(caContinue)
         then
          begin
           stat:= getClassStat().Create(attOne,attTwo,nil);
           self.LstStat.AddStat(stat);
          end;
       end;
     end;
  end;
end;

end.
