(************************************************************************************)
(* UCompSDPairedTestWilcoxonSignedRanks.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(************************************************************************************)

{
@abstract(Test de Wilcoxon sur chantillons apparis -- Wilconxon Signed Ranks Test)
@author(Ricco)
@created(17/07/2005)

Siegel -- pp. 87

}

unit UCompSDPairedTestWilcoxonSignedRanks;

INTERFACE

USES
   UCompDefinition, UOperatorDefinition,
   UCompSDPairedTestDefinition,UCalcStatDesPairedTest;

TYPE
   //gnrateur
   TMLGenCompSDWilcoxonSignedRanks = class(TMLGenComp)
   protected
   procedure   GenCompInitializations(); override;
   public
   function    GetClassMLComponent: TClassMLComponent; override;
   end;

   //composant
   TMLCompSDWilcoxonSignedRanks = class(TMLCompSDPairedTestDefintion)
   protected
   function    getClassOperator: TClassOperator; override;
   end;

   //oprateur
   TOpSDWilcoxonSignedRanks = class(TOpSDPairedTestDefinition)
   protected
   function    getClassStat(): TClassCalcSDPairedTest; override;
   function    getClassLstStat(): TClassLstCalcSDPairedTest; override;
   function    getClassParameter: TClassOperatorParameter; override;
   end;

   //paramtrage
   TOpSDPrmWilcoxonSignedRanks = class(TOpPrmSDPairedTestDefinition)
   end;

implementation

USES
   Classes;

{ TMLGenCompSDWilcoxonSignedRanks }

procedure TMLGenCompSDWilcoxonSignedRanks.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDWilcoxonSignedRanks.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDWilcoxonSignedRanks;
end;

{ TMLCompSDWilcoxonSignedRanks }

function TMLCompSDWilcoxonSignedRanks.getClassOperator: TClassOperator;
begin
 result:= TOpSDWilcoxonSignedRanks;
end;

{ TOpSDWilcoxonSignedRanks }

function TOpSDWilcoxonSignedRanks.getClassLstStat: TClassLstCalcSDPairedTest;
begin
 result:= TLstCalcSDPairedWilcoxonSignedRank;
end;

function TOpSDWilcoxonSignedRanks.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpSDPrmWilcoxonSignedRanks;
end;

function TOpSDWilcoxonSignedRanks.getClassStat: TClassCalcSDPairedTest;
begin
 result:= TCalcSDPairedWilcoxonSignedRank;
end;

initialization
 RegisterClass(TMLGenCompSDWilcoxonSignedRanks);
end.
