(*****************************************************************)
(* UCompSDDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(composant de base pour les statistiques descriptives)
@author(Ricco)
@created(12/01/2004)
}
unit UCompSDDefinition;

interface

USES
        Classes,
        IniFiles,
        Forms,
        UCompManageDataset,
        UCalcStatDes,
        UOperatorDefinition,
        UDatasetImplementation;

TYPE
        {class gnrique composant SD, no implementation here}
        TMLCompSD = class(TMLCompLocalData)
                    end;

        {classe gnrique oprateur SD - maintient une liste de rsultats}
        TOpSD = class(TOpLocalData)
                protected
                {liste de rsultats des stat des.}
                FLstStat: TLstCalcStatDes;
                {initialiser la liste de stat des}
                procedure   InitializeListStat(); virtual; abstract;
                {vider la liste de rsultats}
                procedure   ReInitialize(); override;
                {reconstruire la liste de stat des. - surcharge obligatoire}
                procedure   RebuildStatDes(); virtual; abstract;
                {lancer le calcul}
                function    CoreExecute(): boolean; override;
                {trier les rsultats}
                procedure   SortResults();
                public
                constructor Create(AOwner: TObject); override;
                {envoyer le rapport au format standard, i.e. tableaux de rsultats}
                function    getHTMLResultsSummary(): string; override;
                {pointeur sur la liste de rsultats}
                property    LstStat: TLstCalcStatDes read FLstStat;
                end;

        {classe gnrique paramtre d'oprateur SD - il y a toujours un tri  proposer}
        TOpPrmSD = class(TOperatorParameter)
                   private
                   {trier les rsultats ?}
                   FSortResult: boolean;
                   {critre de tri}
                   FSortCriteria: integer;
                   protected
                   function    CreateDlgParameters(): TForm; override;
                   procedure   SetDefaultParameters(); override;
                   public
                   {inherited obligatoire chez les hritiers}
                   procedure   LoadFromStream(prmStream: TStream); override;
                   {inherited obligatoire chez les hritiers}
                   procedure   SaveToStream(prmStream: TStream); override;
                   {inherited obligatoire chez les hritiers}
                   procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                   {inherited obligatoire chez les hritiers}
                   procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                   {tri des rsultats}
                   property    SortResult: boolean read FSortResult write FSortResult;
                   {critre de tri}
                   property    SortCriteria: Integer read FSortCriteria write FSortCriteria;
                   end;

implementation

{ TOpSD }

function TOpSD.CoreExecute: boolean;
begin
 result:= true;
 try
 self.RebuildStatDes();
 self.LstStat.RefreshStat(WorkData.Examples);
 //puis demander le tri des rultats le cas chant
 if (PrmOp as TOpPrmSD).SortResult
  then SortResults();
 except
 result:= false;
 end;
end;

constructor TOpSD.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 Self.InitializeListStat();
end;

function TOpSD.getHTMLResultsSummary: string;
begin
 result:= self.FLstStat.getHTMLResults();
end;

procedure TOpSD.ReInitialize;
begin
 inherited ReInitialize();
 //la liste de stat est vide
 FLstStat.FreeAll;
 //si modification des paramtres, rcupration des nouvelles variables
 //self.RebuildStatDes();
end;

procedure TOpSD.SortResults;
begin
 FLstStat.CompareMode:= (prmOp as TOpPrmSD).SortCriteria;
 FLstStat.SortStats();
end;

{ TOpPrmSD }

function TOpPrmSD.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

procedure TOpPrmSD.LoadFromINI(prmSection: string; prmINI: TMemIniFile);
begin
 FSortResult:= prmINI.ReadBool(prmSection,'sort_result',FSortResult);
 FSortCriteria:= prmINI.ReadInteger(prmSection,'sort_criteria',FSortCriteria);
end;

procedure TOpPrmSD.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FSortResult,sizeof(FSortResult));
 prmStream.ReadBuffer(FSortCriteria,sizeof(FSortCriteria));
end;

procedure TOpPrmSD.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteBool(prmSection,'sort_result',FSortResult);
 prmINI.WriteInteger(prmSection,'sort_criteria',FSortCriteria);
end;

procedure TOpPrmSD.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FSortResult,sizeof(FSortResult));
 prmStream.WriteBuffer(FSortCriteria,sizeof(FSortCriteria));
end;

procedure TOpPrmSD.SetDefaultParameters();
begin
 FSortResult:= FALSE;//pas de tri
 FSortCriteria:= 0;//le nom des attributs au cas o
end;

end.
