(******************************************************************************)
(* UCompSDUnivariateContinuousAtt.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************************)

{
@abstract(Composant statistique descriptive pour des variables continues - Traitement univari)
@author(Ricco)
@created(12/01/2004)
}
unit UCompSDUnivariateContinuousAtt;

interface

USES
        Forms, Classes,
        UCompDefinition,
        UCompManageDataset,
        UCompSDDefinition,
        UOperatorDefinition;

TYPE
        {Gnrateur de univariate stat cont desc}
        TMLGenCompSDUnivCont = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {le composant}
        TMLCompSDUnivCont = class(TMLCompSD)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            function    GetLogResultDescription(): string; override;                                
                            end;

        {l'oprateur associ}
        TOpSDUnivCont     = class(TOpSD)
                            protected
                            procedure   InitializeListStat(); override;
                            function    getClassParameter: TClassOperatorParameter; override;
                            procedure   RebuildStatDes(); override;
                            function    CheckAttributes(): boolean; override;
                            public
                            end;

        {le paramtrage}
        TOpPrmSDUnivCont = class(TOpPrmSD)
                           protected
                           function    CreateDlgParameters(): TForm; override;
                           public
                           destructor  Destroy; override;
                           {crire les paramtres}
                           function    getHTMLParameters(): string; override;
                           end;

implementation

USES
        Sysutils,
        UDatasetDefinition,
        UDatasetImplementation, UDlgOpPrmUnivStatDesCont,
        UConstConfiguration, UStringsResources, UCalcStatDes;

{ TMLGenCompSDUnivCont }

procedure TMLGenCompSDUnivCont.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
 //FMLNumIcon:= 3;
 //FMLCompName:= str_comp_name_sd_cont_univ_stat;
 //FMLBitmapFileName:= 'MLUnivStatCont.bmp';
end;

function TMLGenCompSDUnivCont.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDUnivCont;
end;

{ TMLCompSDUnivCont }

function TMLCompSDUnivCont.getClassOperator: TClassOperator;
begin
 result:= TOpSDUnivCont;
end;

function TMLCompSDUnivCont.GetLogResultDescription: string;
begin
 result:= Format('stats on %d examples for %d attributes',
          [(self.Operator as TOpLocalData).WorkData.Examples.Size,(self.Operator as TOpLocalData).WorkData.LstAtts[asInput].Count]);
end;

{ TOpSDUnivCont }

function TOpSDUnivCont.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caContinue));
end;

function TOpSDUnivCont.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDUnivCont;
end;

procedure TOpSDUnivCont.InitializeListStat;
begin
 FLstStat:= TLstCalcStatDesContinuous.Create(nil,nil); 
end;

procedure TOpSDUnivCont.RebuildStatDes;
var i: integer;
    att: TAttribute;
    stat: TCalcStatDesContinuous;    
begin
 //si modification des paramtres, rcupration des nouvelles variables
 for i:= 0 to pred(workdata.LstAtts[asInput].Count) do
  begin
   att:= workdata.LstAtts[asInput].Attribute[i];
   if att.isCategory(caContinue)
    then
     begin
      stat:= TCalcStatDesContinuous.Create(att,NIL);//nil, pas de calculs
      self.LstStat.AddStat(stat);
     end;
  end;
end;

{ TOpPrmSDUnivCont }

function TOpPrmSDUnivCont.CreateDlgParameters: TForm;
begin
 //faire apparatre la bote de dialogue
 result:= TDlgOpPrmUnivStatDesCont.CreateFromOpPrm(self);
end;

destructor TOpPrmSDUnivCont.Destroy;
begin
 inherited Destroy;
end;

function TOpPrmSDUnivCont.getHTMLParameters: string;
var sHtml: string;
begin
 sHTML:= format('<P><B>Attributes : </B>%d<BR>',[(Operator as TOpSDUnivCont).LstStat.Count]);
 sHTML:= sHTML+format('<B>Examples : </B>%d<BR>',[(Operator as TOpSDUnivCont).Workdata.Examples.Size]);
 result:= sHTML;
end;

initialization
 RegisterClass(TMLGenCompSDUnivCont);
end.
