(****************************************************************************)
(* UCompSDUnivariateDiscreteAtt.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************************)

{
@abstract(Composant statistique descriptive pour des variables discrtes - Traitement univari)
@author(Ricco)
@created(12/01/2004)
ceci est une transposition directe du composant stat des pour var. continues @link(UCompSDUnivariateContinuousAtt)
hypothse, la liste des attributs  dcrire est dans TARGET
}
unit UCompSDUnivariateDiscreteAtt;

interface

USES
        Forms, Classes,
        UCompDefinition,
        UCompManageDataset,
        UCompSDDefinition,
        UOperatorDefinition,
        UCalcStatDes;

TYPE
        {Gnrateur de univariate stat Discrete desc}
        TMLGenCompSDUnivDisc = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {le composant}
        TMLCompSDUnivDisc = class(TMLCompSD)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            function    GetLogResultDescription(): string; override;
                            end;

        {l'oprateur associ}
        TOpSDUnivDisc     = class(TOpSD)
                            protected
                            procedure   InitializeListStat(); override;
                            function    getClassParameter: TClassOperatorParameter; override;
                            procedure   RebuildStatDes(); override;
                            function    CheckAttributes(): boolean; override;
                            public
                            //function    getHTMLResultsSummary(): string; override;
                            end;

        {le paramtrage}
        TOpPrmSDUnivDisc = class(TOpPrmSD)
                           private
                           protected
                           function    CreateDlgParameters(): TForm; override;
                           public
                           destructor  Destroy; override;
                           function    getHTMLParameters(): string; override;
                           end;


implementation

uses
        Sysutils,
        UDlgOpPrmUnivStatDesDisc,
        UDatasetDefinition,
        UDatasetImplementation, UStringAddBuffered, UConstConfiguration,
  UStringsResources;

{ TMLGenCompSDUnivDisc }

procedure TMLGenCompSDUnivDisc.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;
 //FMLNumIcon:= 4;
 //FMLCompName:= str_comp_name_sd_disc_univ_stat;
 //FMLBitmapFileName:= 'MLUnivStatDisc.bmp';
end;

function TMLGenCompSDUnivDisc.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDUnivDisc;
end;

{ TMLCompSDUnivDisc }

function TMLCompSDUnivDisc.getClassOperator: TClassOperator;
begin
 result:= TOpSDUnivDisc;
end;

function TMLCompSDUnivDisc.GetLogResultDescription: string;
begin
 result:= Format('stats on %d examples for %d attributes',
          [(self.Operator as TOpLocalData).WorkData.Examples.Size,(self.Operator as TOpSDUnivDisc).LstStat.Count]);
end;

{ TOpSDUnivDisc }

function TOpSDUnivDisc.CheckAttributes: boolean;
begin
 result:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete));
end;

function TOpSDUnivDisc.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDUnivDisc;
end;

(*
function TOpSDUnivDisc.getHTMLResultsSummary: string;
var s: string;
    bs: TBufString;//la taille des rsultats peut tre importante
    i,j: integer;
    stat: TCalcStatDesDiscrete;
begin
 bs:= TBufString.Create();
 bs.BeginUpdate();

 s:= '<P>'+HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Attribute</TH><TH>Gini</TH><TH>Distribution</TH></TR>';
 bs.AddStr(s);

 for i:= 0 to pred(LstStat.Count) do
  begin
   stat:= TCalcStatDesDiscrete(LstStat.Stat(i));

   s:= format(HTML_TABLE_COLOR_DATA_GRAY+
              '<TD>%s</TD>'+
              '<TD>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD><TD>',[stat.Attribute.Name,stat.Gini]);

   s:= s+HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_BLUE+
       '<th width=150>Values</th><th width=50>Count</th><th width=80>Percent</th></tr>';
   //pour chaque modalit de la variable
   for j:= 1 to stat.TabFreq.Size do
    s:= s+Format(HTML_TABLE_COLOR_DATA_BLUE+'<td>%s</td><td align=right>%d</td><td align=right>%.2f %s</td></tr>',[stat.Attribute.LstValues.getDescription(j),stat.TabFreq.Value[j],100.0*stat.TabFreq.Frequence[j],'%']);

   s:= s+'</table></TD></TR>';

   bs.AddStr(s);
  end;

 s:= '</table>';
 bs.AddStr(s);

 //finaliser
 bs.EndUpdate();

 result:= bs.BufS;
 bs.Free;//don't forget !!!
end;
*)

procedure TOpSDUnivDisc.InitializeListStat;
begin
 FLstStat:= TLstCalcStatDesDiscrete.Create(nil,nil);
end;

procedure TOpSDUnivDisc.RebuildStatDes;
var i: integer;
    att: TAttribute;
    stat: TCalcStatDesDiscrete;    
begin
 //si modification des paramtres, rcupration des nouvelles variables
 for i:= 0 to pred(workdata.LstAtts[asInput].Count) do
  begin
   att:= workdata.LstAtts[asInput].Attribute[i];
   if att.isCategory(caDiscrete)
    then
     begin
      stat:= TCalcStatDesDiscrete.Create(att,NIL);//nil, pas de calculs
      self.LstStat.AddStat(stat);
     end;
  end;
end;

{ TOpPrmSDUnivDisc }

function TOpPrmSDUnivDisc.CreateDlgParameters: TForm;
begin
 //faire apparatre la bote de dialogue
 result:= TDlgOpPrmUnivStatDesDisc.CreateFromOpPrm(self);
end;

destructor TOpPrmSDUnivDisc.Destroy;
begin
 inherited Destroy;
end;

function TOpPrmSDUnivDisc.getHTMLParameters: string;
var sHtml: string;
begin
 sHTML:= format('<P><B>Attributes : </B>%d<BR>',[(Operator as TOpSDUnivDisc).LstStat.Count]);
 sHTML:= sHTML+format('<B>Examples : </B>%d<BR>',[(Operator as TOpSDUnivDisc).Workdata.Examples.Size]);
 result:= sHTML;
end;

initialization
 RegisterClass(TMLGenCompSDUnivDisc);
end.
