(*********************************************************************)
(* UFrmOpUnivStatDesCont.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

unit UFrmOpUnivStatDesCont;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, ComCtrls, UCalcStatDes, ExtCtrls, OleCtrls,
  SHDocVw, Menus, ActnList;

type
  TFrmOpUnivStatDesCont = class(TFrmBaseOperator)
    lvStat: TListView;
  private
  FLstStat: TLstCalcStatDes;
  public
  procedure   PrepareView(); override;
  end;

var
  FrmOpUnivStatDesCont: TFrmOpUnivStatDesCont;

implementation

USES
        UCompSDUnivariateContinuousAtt, UConstConfiguration;

{$R *.dfm}

{ TFrmOpUnivStatDesCont }

procedure TFrmOpUnivStatDesCont.PrepareView;
var     i: integer;
        stat: TCalcStatDesContinuous;
        item: TListItem;
begin
 FLstStat:= (Operator as TOpSDUnivCont).LstStat;
 //le titre
 Caption:= 'Desc. stat - Continuous attributes'+Format(' (%d attributes, %d examples)',[FLstStat.Count,(Operator as TOpSDUnivCont).WorkData.Examples.Size]);
 //remplir la liste
 for i:= 0 to pred(FLstStat.Count) do
  begin
   stat:= TCalcStatDesContinuous(FLstStat.Stat(i));
   item:= lvStat.Items.Add();
   item.Caption:= stat.Attribute.Name;
   //pour chaque statistique
   item.SubItems.Add(Format(VIEW_ATTRIBUTE_ACCURACY_CONTINUE,[stat.Min]));
   item.SubItems.Add(Format(VIEW_ATTRIBUTE_ACCURACY_CONTINUE,[stat.Max]));
   item.SubItems.Add(Format(VIEW_ATTRIBUTE_ACCURACY_CONTINUE,[stat.Average]));
   item.SubItems.Add(Format(VIEW_ATTRIBUTE_ACCURACY_CONTINUE,[stat.StdDev]));
   item.SubItems.Add(Format(VIEW_ATTRIBUTE_ACCURACY_CONTINUE,[stat.CoefVar]));
  end;
end;

end.
