(*********************************************************************)
(* UFrmOpUnivStatDesDisc.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

unit UFrmOpUnivStatDesDisc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, ComCtrls, UCalcStatDes, ExtCtrls, OleCtrls,
  SHDocVw, Menus, ActnList;

type
  TFrmOpUnivStatDesDisc = class(TFrmBaseOperator)
    lvStat: TListView;
  private
  FLstStat: TLstCalcStatDes;
  public
    procedure   PrepareView(); override;
  end;

var
  FrmOpUnivStatDesDisc: TFrmOpUnivStatDesDisc;

implementation

uses UCompSDUnivariateDiscreteAtt, UDatasetDefinition, UConstConfiguration;

{$R *.dfm}

{ TFrmOpUnivStatDesDisc }

procedure TFrmOpUnivStatDesDisc.PrepareView;
var i,j: integer;
    stat: TCalcStatDesDiscrete;
    item: TListItem;
    s: string;
begin
 FLstStat:= (Operator as TOpSDUnivDisc).LstStat;
 //titre
 Caption:= 'Desc. stat - Discrete attributes'+Format(' (%d attributes, %d examples)',[FLstStat.Count,(Operator as TOpSDUnivDisc).WorkData.Examples.Size]);
 //Liste des stats
 for i:= 0 to pred(FLstStat.Count) do
  begin
   stat:= TCalcStatDesDiscrete(FLstStat.Stat(i));
   item:= lvStat.Items.Add();
   item.Caption:= stat.Attribute.Name;
   //indice de gini
   item.SubItems.Add(Format(STR_FORMAT_VIEW_STAT_ACCURACY,[stat.Gini]));
   //distribution de frquence
   s:= '[';
   for j:= 1 to stat.TabFreq.Size do
    s:= s+Format('%s:%d;',[stat.Attribute.LstValues.getDescription(j),stat.TabFreq.Value[j]]);
   s:= copy(s,1,pred(length(s)))+']';
   item.SubItems.Add(s);
  end;
end;

end.
