(********************************************************************)
(* UCompSDVarTestFisher.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Comparaison de 2 variances -- Test de Fisher)
@author(Ricco)
@created(22/07/2005)

Comparaison de 2 variances (chantillons indpendants et normaux)

}

unit UCompSDVarTestFisher;

interface

USES
   UCompDefinition, UOperatorDefinition,
   UCompSDCondDescDefinition,
   UCalcStatDesConditionnalDesc,
   UCalcStatDesVarianceHomogeneity;

TYPE
   //gnrateur
   TMLGenCompSDVarTestFisher = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

   //composant
   TMLCompSDVarTestFisher = class(TMLCompSDCondDescDefinition)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            end;

   //oprateur
   TOpSDVarTestFisher = class(TOpSDCondDescBinary)
                        protected
                        function    getClassStat(): TClassCalcSDCondDesc; override;
                        function    getClassLstStat(): TClassLstCalcStatDesCond; override;
                        function    getClassParameter: TClassOperatorParameter; override;
                        end;

   //paramtrage
   TOpSDPrmVarTestFisher = class(TOpPrmSDCondDescDefinition)
                           end;


implementation

USES
   Classes;


{ TMLGenCompSDVarTestFisher }

procedure TMLGenCompSDVarTestFisher.GenCompInitializations;
begin
 FMLComp:= mlcDescriptiveStat;

end;

function TMLGenCompSDVarTestFisher.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDVarTestFisher; 
end;

{ TMLCompSDVarTestFisher }

function TMLCompSDVarTestFisher.getClassOperator: TClassOperator;
begin
 result:= TOpSDVarTestFisher; 
end;

{ TOpSDVarTestFisher }

function TOpSDVarTestFisher.getClassLstStat: TClassLstCalcStatDesCond;
begin
 result:= TLstCalcSDVarianceHomogeneityTest;
end;

function TOpSDVarTestFisher.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpSDPrmVarTestFisher; 
end;

function TOpSDVarTestFisher.getClassStat: TClassCalcSDCondDesc;
begin
 result:= TCalcSDVHFisher;
end;

initialization
 RegisterClass(TMLGenCompSDVarTestFisher);
end.
