(************************************************************)
(* UDlgOpPrmMCA.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************)

unit UDlgOpPrmMCA;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA, LMDCustomControl, LMDCustomPanel,
  LMDCustomBevelPanel, LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit,
  LMDMaskEdit;

type
  TDlgOpPrmMCA = class(TDlgBaseOperatorParameter)
    rgAxis: TRadioGroup;
    spinAxis: TLMDSpinEdit;
    Label1: TLabel;
    edThresold: TLMDMaskEdit;
    procedure rgAxisClick(Sender: TObject);
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override; 
  end;

var
  DlgOpPrmMCA: TDlgOpPrmMCA;

implementation

uses UCompFactAnalysisMCA;

{$R *.dfm}

procedure TDlgOpPrmMCA.ApplyModifications;
var prm: TOpPrmFactMCA;
begin
 prm:= OpPrm as TOpPrmFactMCA;
 prm.ThresoldValue:= StrToFloat(edThresold.Text);
 if (rgAxis.ItemIndex=0)
  then prm.NbAxis:= -1
  else prm.NbAxis:= spinAxis.Value;
end;

procedure TDlgOpPrmMCA.rgAxisClick(Sender: TObject);
begin
 if (rgAxis.ItemIndex=0)
  then spinAxis.Enabled:= FALSE
  else spinAxis.Enabled:= TRUE;
end;

procedure TDlgOpPrmMCA.SetParameters;
var prm: TOpPrmFactMCA;
begin
 prm:= OpPrm as TOpPrmFactMCA;
 if (prm.NbAxis<0)
  then rgAxis.ItemIndex:= 0
  else
   begin
    rgAxis.ItemIndex:= 1;
    spinAxis.Value:= prm.NbAxis;
   end;
 edThresold.Text:= formatfloat('0.00',prm.ThresoldValue);
end;

end.
