(***************************************************************)
(* UCompFactNIPALS.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***************************************************************)

{
@abstract(NIPALS)
@author(Ricco)
@created(24/03/2005)

Une autre manire d'effectuer les ACP, sans avoir  procder  une diagonalisation complte. Le principal
intrt ici est que l'on peut grer la dure de calcul en limitant ds le dpart le nombre de facteurs
que l'on veut produire. Autre avantage, il n'est pas ncessaire de produire X'X.

C'est une approche  privilgier lorsque le nombre de descripteurs est lev !

La principale rfrence utilise est "La rgression PLS", Tenenhaus, pp. 61-73.
Cette version ne gre pas les donnes manquantes !
}

unit UCompFactNIPALS;

interface

USES
  Classes, Forms,
  IniFiles,
  UCompDefinition,
  UCompFADefinition,
  UOperatorDefinition,
  UCompManageDataset,
  UCalcFactNIPALS;

TYPE
    {gnrateur de composant}
    TMLGenCompFactNIPALS = class(TMLGenComp)
                           protected
                           procedure   GenCompInitializations(); override;
                           public
                           function    GetClassMLComponent: TClassMLComponent; override;
                           end;

    {composant NIPALS}
    TMLCompFactNIPALS = class(TMLCompFactAnalysis)
                        protected
                        function    getClassOperator: TClassOperator; override;
                        end;

    {oprateur NIPALS}
    TOpFactNIPALS = class(TOpLocalData)
                    private
                    //objet de calcul
                    FCalc: TCalcNIPALS;
                    //nombre vritbale d'axes  produire
                    FTrueNbAxis: integer;
                    protected
                    function    CheckAttributes(): boolean; override;
                    function    CoreExecute(): boolean; override;
                    function    getClassParameter: TClassOperatorParameter; override;
                    procedure   setProjection();
                    public
                    destructor  destroy(); override;
                    function    getHTMLResultsSummary(): string; override;
                    end;

    {paramtrage de l'oprateur NIPALS}
    TOpPrmFactNIPALS = class(TOpPrmFactAnalysis)
                       private
                       {nombre d'axes  crer -> 5 par dfaut}
                       FNbAxisCreated: integer;
                       {utiliser la standardisation ou pas -- i.e. diviser les donnes par l'cart-type}
                       FStandardize: boolean;
                       protected
                       function    CreateDlgParameters(): TForm; override;
                       procedure   SetDefaultParameters(); override;
                       public
                       function    getHTMLParameters(): string; override;
                       procedure   LoadFromStream(prmStream: TStream); override;
                       procedure   SaveToStream(prmStream: TStream); override;
                       procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                       procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                       property    NbAxisCreated: integer read FNbAxisCreated write FNbAxisCreated;
                       property    Standardize: boolean read FStandardize write FStandardize;
                       end;

implementation

uses
       Sysutils,
       UDatasetExamples, UDatasetImplementation, UDatasetDefinition,
  ULogFile, UDlgOpPrmFactNIPALS, UConstConfiguration;

{ TMLGenCompFactNIPALS }

procedure TMLGenCompFactNIPALS.GenCompInitializations;
begin
 FMLComp:= mlcFactorialAnalysis;
end;

function TMLGenCompFactNIPALS.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompFactNIPALS;
end;

{ TMLCompFactNIPALS }

function TMLCompFactNIPALS.getClassOperator: TClassOperator;
begin
 result:= TOpFactNIPALS; 
end;

{ TOpPrmFactNIPALS }

function TOpPrmFactNIPALS.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmFactNIPALS.CreateFromOpPrm(self);
end;

function TOpPrmFactNIPALS.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_BLUE+'<TH colspan=2>NIPALS parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Number of axis</TD><TD align=right>%d</TD></TR>',[FNbAxisCreated]);
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Standardize</TD><TD align=right>%d</TD></TR>',[ord(FStandardize)]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmFactNIPALS.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FNbAxisCreated:= prmINI.ReadInteger(prmSection,'nb_axis',FNbAxisCreated);
 FStandardize:= prmINI.ReadBool(prmSection,'standardize',FStandardize);
end;

procedure TOpPrmFactNIPALS.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FNbAxisCreated,sizeof(FNbAxisCreated));
 prmStream.ReadBuffer(FStandardize,sizeof(FStandardize));
end;

procedure TOpPrmFactNIPALS.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'nb_axis',FNbAxisCreated);
 prmINI.WriteBool(prmSection,'standardize',FStandardize);
end;

procedure TOpPrmFactNIPALS.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FNbAxisCreated,sizeof(FNbAxisCreated));
 prmStream.WriteBuffer(FStandardize,sizeof(FStandardize));
end;

procedure TOpPrmFactNIPALS.SetDefaultParameters;
begin
 FNbAxisCreated:= 5;
 FStandardize:= TRUE;
end;

{ TOpFactNIPALS }

function TOpFactNIPALS.CheckAttributes: boolean;
begin
 //tous continus ou quasi-continus
 result:= (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caQuasiContinue));
end;

function TOpFactNIPALS.CoreExecute: boolean;
begin
 //vider
 if assigned(FCalc)
  then FCalc.Free();
 //run
 TRY
  //vrifier quand mme le nombre d'axes  produire rellement (ne doit pas tre suprieure  la dimension) !
  if ((self.PrmOp as TOpPrmFactNIPALS).NbAxisCreated>self.WorkData.LstAtts[asInput].Count)
   then FTrueNbAxis:= self.WorkData.LstAtts[asInput].Count
   else FTrueNbAxis:= (self.PrmOp as TOpPrmFactNIPALS).NbAxisCreated;
  //zoo..
  FCalc:= TCalcNIPALS.create(self.WorkData.LstAtts[asInput],self.WorkData.Examples,(self.PrmOp as TOpPrmFactNIPALS).Standardize,FTrueNbAxis);
  FCalc.runAnalysis(self.WorkData.Examples);
  //puis lancer la projection sur les nouveaux axes
  self.setProjection();
  //and then...
  result:= TRUE;
 EXCEPT
  result:= FALSE;
 END;
end;

destructor TOpFactNIPALS.destroy;
begin
 if assigned(FCalc)
  then FCalc.Free();
 //
 inherited destroy();
end;

function TOpFactNIPALS.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFactNIPALS; 
end;

function TOpFactNIPALS.getHTMLResultsSummary: string;
begin
 result:= FCalc.getHTMLResults();
end;

procedure TOpFactNIPALS.setProjection;
var k: integer;
    newAtt: TAttribute;
begin
 //TraceLog.WriteToLogFile(format('[NIPALS] create %d atts for projection',[FTrueNbAxis]));
 //vider la liste des variables dj produites
 GenAtts.Clear();
 //reconstruire la liste des variables  produire
 for k:= 1 to FTrueNbAxis do
  begin
   newAtt:= TAttContinue.Create(Format('NIPALS_%d_Axis_%d',[(MLOwner as TMLCompFactNIPALS).Number,k]),WorkData.LstAtts[asAll].Size);
   GenAtts.Add(newAtt);
  end;
 //puis demander leur remplissage par projection dans le nouvel espace
 //TraceLog.WriteToLogFile('[NIPALS] >>> begin projection');
 FCalc.setProjection(GenAtts);
 //TraceLog.WriteToLogFile(format('[NIPALS] projection completed on %d axis',[FTrueNbAxis]));
end;

initialization
 RegisterClass(TMLGenCompFactNIPALS);
end.
