(**************************************************************)
(* UCompFCFormula.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**************************************************************)

{
@abstract(Composant formule - Utilise la classe freeware TParserFormula)
@author(Ricco)
@created(12/01/2004)
Ca devrait marcher, la variable est cre et reste en mmoire, l'avantage est la scurit.
Il reste galement  bien scanner les saisies de l'utilisateur.
}
unit UCompFCFormula;

interface

USES
        Forms, Contnrs, Classes,
        IniFiles,
        UCompDefinition,
        UCompFCDefinition,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation,
        UCalcParser10;

TYPE
        {gnrateur de composant}
        TGenFCFormula = class(TMLGenComp)
                        protected
                        procedure   GenCompInitializations(); override;
                        public
                        function    GetClassMLComponent: TClassMLComponent; override;
                        end;

        {le composant}
        TMLFCFormula = class(TMLCompFC)
                       private
                       {la variable produite}
                       FFormulaAtt: TAttContinue;
                       protected
                       function    getClassOperator: TClassOperator; override;
                       function    GetLogResultDescription(): string; override;
                       {gnrer la variable qui matrialisera la formule}
                       procedure   InitializeDataset(); override;
                       public
                       property    FormulaAtt: TAttContinue read FFormulaAtt;
                       end;

        {l'oprateur de calcul}
        TOpFCFormula = class(TOperatorFC)
                       private
                       {l'interprteur de formule}
                       FParser: TParserFormula;
                       {le couple attribut-pointeur de valeurs dans la formule}
                       FLstPP: TObjectList;
                       {la nouvelle variable}
                       FNewAtt: TAttContinue;
                       protected
                       function    getClassParameter: TClassOperatorParameter; override;
                       {lancer le rafrachissement des valeurs de la variable}
                       function    CoreExecute(): boolean; override;
                       public
                       {initialiser le parser}
                       constructor Create(AOwner: TObject); override;
                       {supprimer le parser}
                       destructor  Destroy; override;
                       {valider la formule}
                       function    ValidateFormula(prmNewFormula: string): boolean;
                       {envoyer le rsultat des calculs}
                       function    getHTMLResultsSummary(): string; override;
                       {interprteur de formule}
                       property Parser: TParserFormula read FParser;
                       {liste des variables utilises}
                       property LstPP: TObjectList read FLstPP;
                       end;

        {paramtrage de l'oprateur}
        TOpFCFormulaPrm = class(TOperatorPrmFC)
                          private
                          {la formule sous forme de chane de caractres}
                          FFormula: string;
                          {mj de la formule}
                          procedure   SetFormula(prmStr: string);
                          protected
                          procedure   SetDefaultParameters(); override;
                          function    CreateDlgParameters(): TForm; override;
                          public
                          function    getHTMLParameters(): string; override;
                          procedure   LoadFromStream(prmStream: TStream); override;
                          procedure   SaveToStream(prmStream: TStream); override;
                          procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                          procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                          property    Formula: string read FFormula write SetFormula;
                          end;

        {le couple [pointeur dans la formule - attribut concern] - c'est un type de calcul pur}
        TAttPointerParser = class(TObject)
                            private
                            {pointeur de valeur dans le parser}
                            FPValue: PParserFloat;
                            {l'attribut concern}
                            FAtt: TAttribute;
                            public
                            constructor Create(parser: TParserFormula; att: TAttribute);
                            property    Att: TAttribute read FAtt;
                            property    PValue: PParserFloat read FPValue;
                            end;

implementation

USES
        SysUtils,
        UDlgOpPrmFormulaContinuous, UConstConfiguration, UStringsResources;

resourcestring
        ID_HTML_FORMULA = 'Formula';

{Comparaison de longueur de chanes de caractres}
function ComparaisonLongueur(List: TStringList; Index1, Index2: Integer): Integer;
Var L1, L2: Integer;
Begin
 L1:= Length(List[Index1]);
 L2:= Length(List[Index2]);
 If (L1>L2)
  Then RESULT:= -1
  Else
   Begin
    If (L1=L2) Then RESULT:= 0
               Else RESULT:= 1;
   End;
End;
{*************************************************}

{ TGenFCFormula }

procedure TGenFCFormula.GenCompInitializations;
begin
 FMLComp:= mlcFeatureConstruction;
end;

function TGenFCFormula.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLFCFormula;
end;

{ TMLFCFormula }

function TMLFCFormula.getClassOperator: TClassOperator;
begin
 result:= TOpFCFormula; 
end;

function TMLFCFormula.GetLogResultDescription: string;
begin
 result:= (Operator as TOpFCFormula).Parser.Expression;
end;

procedure TMLFCFormula.InitializeDataset;
begin
 inherited InitializeDataset();
 //gnrer l'ensemble local de donnes
 FFormulaAtt:= TAttContinue.Create('Formula_'+IntToStr(self.Number),LocalDataset.Size);
 LocalDataset.Add(FFormulaAtt);
end;

{ TOpFCFormula }

function TOpFCFormula.CoreExecute: boolean;
var i,j: integer;
    pp: TAttPointerParser;
begin
 //pour chaque exemple
 for i:= 1 to FNewAtt.Size do
  begin
   //mj des pointeurs de parser
   for j:= 0 to pred(FLstPP.Count) do
    begin
     pp:= FLstPP.Items[j] as TAttPointerParser;
     pp.PValue^:= pp.Att.cValue[i];
    end;
   TRY
   FNewAtt.cValue[i]:= FParser.Value;
   EXCEPT
   FNewAtt.cValue[i]:= 0.0;//soyons gentils
   END;
  end;
 result:= true;
end;

constructor TOpFCFormula.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 FNewAtt:= (AOwner as TMLFCFormula).FormulaAtt;

 FParser:= TParserFormula.Create(NIL);
 FLstPP:= TObjectList.Create(TRUE);
end;

destructor TOpFCFormula.Destroy;
begin
 FLstPP.Free;
 FParser.Free;
 inherited;
end;

function TOpFCFormula.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpFCFormulaPrm; 
end;

function TOpFCFormula.getHTMLResultsSummary: string;
var s: string;
    i: integer;
    pp: TAttPointerParser;
begin
 s:= '<P>'+HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Used attributes</TH>';
 for i:= 0 to pred(FLstPP.Count) do
  begin
   pp:= FLstPP.Items[i] as TAttPointerParser;
   s:= s+Format(HTML_TABLE_COLOR_DATA_GRAY+'<td>%s</td>',[pp.Att.Name]);
  end;
 s:= s+'</table>';
 result:= s;
end;

function TOpFCFormula.ValidateFormula(prmNewFormula: string): boolean;
var oldFormula,tmpFormula: string;
    lstvar: TLstAttributes;
    lststr: TStringList;
    i,p: integer;
    att: TAttribute;
    ok: boolean;
begin
 ok:= TRUE;
 oldFormula:= Parser.Expression;
 tmpFormula:= prmNewFormula;
 TRY
 //vrifier la nouvelle formule
 lstvar:= WorkData.LstAtts[asAll];
 //construire une liste trie (sur la longueur des noms) des attributs
 lststr:= TStringList.Create();
 for i:= 0 to pred(lstvar.Count) do
  begin
   att:= lstvar.Attribute[i];
   if att.isCategory(caContinue)
    then lststr.AddObject(att.Name,att);
  end;
 lststr.CustomSort(ComparaisonLongueur);
 //rechercher ces noms d'attributs dans la formule
 FLstPP.Clear;
 for i:= 0 to pred(lststr.Count) do
  begin
   att:= lststr.Objects[i] as TAttribute;
   p:= pos(att.Name,tmpFormula);
   if (p>0)
    then
     begin
      delete(tmpFormula,p,length(att.Name));
      FLstPP.Add(TAttPointerParser.Create(FParser,att))
     end;
  end;
 lststr.Free;
 //ok branchement...
 FParser.Expression:= prmNewFormula;
 EXCEPT
 FParser.Expression:= oldFormula;
 ok:= FALSE;
 END;
 result:= ok;
end;

{ TOpFCFormulaPrm }

function TOpFCFormulaPrm.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmFormulaContinuous.CreateFromOpPrm(self);
end;

function TOpFCFormulaPrm.getHTMLParameters: string;
begin
 result:= Format('<B>%s</B> : %s',[ID_HTML_FORMULA,FFormula]);
end;

procedure TOpFCFormulaPrm.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
var s: string;
begin
 s:= prmINI.ReadString(prmSection,'formula',self.FFormula);
 self.SetFormula(s);
end;

procedure TOpFCFormulaPrm.LoadFromStream(prmStream: TStream);
var s: string;
    l: integer;
begin
 prmStream.ReadBuffer(l,sizeof(l));
 if (l>0)
  then
   begin
    setlength(s,l);
    prmStream.ReadBuffer(s[1],l);
    self.SetFormula(s);
   end;
end;

procedure TOpFCFormulaPrm.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteString(prmSection,'formula',self.FFormula);
end;

procedure TOpFCFormulaPrm.SaveToStream(prmStream: TStream);
var s: string;
    l: integer;
begin
 s:= self.FFormula;
 l:= length(s);
 prmStream.WriteBuffer(l,sizeof(l));
 if (l>0)
  then prmStream.WriteBuffer(s[1],l);
end;

procedure TOpFCFormulaPrm.SetDefaultParameters;
begin
 FFormula:= '';
end;

procedure TOpFCFormulaPrm.SetFormula(prmStr: string);
begin
 if (Operator as TOpFCFormula).ValidateFormula(prmStr)
  then FFormula:= prmStr;
end;

{ TAttPointerParser }

constructor TAttPointerParser.Create(parser: TParserFormula; att: TAttribute);
begin
 inherited Create();
 FAtt:= att;
 FPValue:= parser.SetVariable(att.Name,0);
end;

initialization
 RegisterClass(TGenFCFormula);
end.
