(*****************************************************************)
(* UCompFCDiscEqFreq.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Composant : discrtisation avec intervalles de frquences gales)
@author(Ricco)
@created(27/03/2004)

Ncessite pas le tri des donnes, mais c'est tout (quasiment)...
}
unit UCompFCDiscEqFreq;

interface

USES
        Forms, Classes, IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompFCDiscDefinition;

TYPE
        {gnrateur de composant}
        TGenFCDiscEqFreq = class(TGenFCDiscBase)
                            public
                            function    GetClassMLComponent: TClassMLComponent; override;
                            end;

        {composant}
        TMLFCDiscEqFreq  = class(TMLFCDiscBase)
                            protected
                            function    getGenericAttName(): string; override;
                            function    getClassOperator: TClassOperator; override;    
                            end;

        {oprateur}
        TOpFCDiscEqFreq  = class(TOpFCDiscBase)
                            protected
                            function    getClassParameter: TClassOperatorParameter; override;
                            procedure   BuildCutPoints(); override;    
                            end;

        {paramtre de l'oprateur}
        TOpPrmFCDiscEqFreq = class(TOpPrmFCDiscBase)
                              private
                              {nombre d'intervalles}
                              FNbIntv: integer;
                              protected
                              procedure   SetDefaultParameters(); override;
                              function    CreateDlgParameters(): TForm; override;
                              public
                              function    getHTMLParameters(): string; override;
                              procedure   LoadFromStream(prmStream: TStream); override;
                              procedure   SaveToStream(prmStream: TStream); override;
                              procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                              procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                              property    NbIntv: integer read FNbIntv write FNBIntv;
                              end;


implementation

uses
        SysUtils, UDatasetDefinition, UConstConfiguration,
        UDatasetExamples, UDlgOpPrmDiscEqFreq;

{ TGenFCDiscEqFreq }

function TGenFCDiscEqFreq.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLFCDiscEqFreq;
end;

{ TMLFCDiscEqFreq }

function TMLFCDiscEqFreq.getClassOperator: TClassOperator;
begin
 result:= TOpFCDiscEqFreq;
end;

function TMLFCDiscEqFreq.getGenericAttName: string;
begin
 result:= 'eqF'
end;

{ TOpFCDiscEqFreq }

procedure TOpFCDiscEqFreq.BuildCutPoints;
var nb_intv,gap,idCut: integer;
    cAtt: TAttCutPoints;
    sortList: TExamples;
    j,k: integer;
    predCut,cut: TTypeContinue;
begin
 //nombre d'intervalles demands
 nb_intv:= (PrmOp as TOpPrmFCDiscEqFreq).NbIntv;
 //cart entre individus demands
 gap:= workdata.Examples.Size div nb_intv;
 //liste des individus
 sortList:= TExamples.Create(workdata.Examples.Size);
 TRY
 //construire les bornes pour chaque variable
 for j:= 0 to pred(SetAttCutPoints.getNbAttCutPoints) do
  begin
   //attribut de travail
   cAtt:= SetAttCutPoints.getAttCutPoints(j);
   //les individus tris
   sortList.Copy(workdata.Examples);
   sortList.QuickSortBy(cAtt.AttToDisc);
   //la plus petite valeur
   predCut:= cAtt.AttToDisc.cValue[sortList.Number[1]];
   //construire les bornes
   for k:= 1 to pred(nb_intv) do
    begin
     idCut:= sortList.Number[k*gap];
     cut:= cAtt.AttToDisc.cValue[idCut];
     if (cut>predCut)
      then
       begin
        cAtt.addCutPoint(cut);
        predCut:= cut;
       end;
    end;
  end;
 FINALLY
 sortList.Free;
 END;
end;

function TOpFCDiscEqFreq.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFCDiscEqFreq; 
end;

{ TOpPrmFCDiscEqFreq }

function TOpPrmFCDiscEqFreq.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmDiscEqFreq.CreateFromOpPrm(self);
end;

function TOpPrmFCDiscEqFreq.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_BLUE+'<th colspan="2">Equal frequency binning parameters</th></tr>';
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<td>Intervals</td><td align="right">%d</td></tr>',[self.FNbIntv]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmFCDiscEqFreq.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FNbIntv:= prmINI.ReadInteger(prmSection,'intervals',FNbIntv);
end;

procedure TOpPrmFCDiscEqFreq.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FNbIntv,sizeof(FNbIntv));
end;

procedure TOpPrmFCDiscEqFreq.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'intervals',FNbIntv);
end;

procedure TOpPrmFCDiscEqFreq.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FNbIntv,sizeof(FNbIntv));
end;

procedure TOpPrmFCDiscEqFreq.SetDefaultParameters;
begin
 FNbIntv:= 5;
end;

initialization
 RegisterClass(TGenFCDiscEqFreq);
end.
