(******************************************************************)
(* UCompFCDiscEqWidth.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Composant : discrtisation avec intervalles de largeur gales)
@author(Ricco)
@created(19/03/2004)

Ne ncessite pas le tri des donnes >> very, very, fast, fast....
}

unit UCompFCDiscEqWidth;

interface

USES
        Forms, Classes, IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompFCDiscDefinition;

TYPE
        {gnrateur de composant}
        TGenFCDiscEqWidth = class(TGenFCDiscBase)
                            public
                            function    GetClassMLComponent: TClassMLComponent; override;
                            end;

        {composant}
        TMLFCDiscEqWidth  = class(TMLFCDiscBase)
                            protected
                            function    getGenericAttName(): string; override;
                            function    getClassOperator: TClassOperator; override;    
                            end;

        {oprateur}
        TOpFCDiscEqWidth  = class(TOpFCDiscBase)
                            protected
                            function    getClassParameter: TClassOperatorParameter; override;
                            procedure   BuildCutPoints(); override;    
                            end;

        {paramtre de l'oprateur}
        TOpPrmFCDiscEqWidth = class(TOpPrmFCDiscBase)
                              private
                              {nombre d'intervalles}
                              FNbIntv: integer;
                              protected
                              procedure   SetDefaultParameters(); override;
                              function    CreateDlgParameters(): TForm; override;
                              public
                              function    getHTMLParameters(): string; override;
                              procedure   LoadFromStream(prmStream: TStream); override;
                              procedure   SaveToStream(prmStream: TStream); override;
                              procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                              procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                              property    NbIntv: integer read FNbIntv write FNbIntv;
                              end;
        

implementation

uses
        SysUtils, UDatasetDefinition, UConstConfiguration,
  UDlgOpPrmDiscEqWidth;

{ TGenFCDiscEqWidth }

function TGenFCDiscEqWidth.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLFCDiscEqWidth; 
end;

{ TMLFCDiscEqWidth }

function TMLFCDiscEqWidth.getClassOperator: TClassOperator;
begin
 result:= TOpFCDiscEqWidth; 
end;

function TMLFCDiscEqWidth.getGenericAttName: string;
begin
 result:= 'eqW';
end;

{ TOpFCDiscEqWidth }

procedure TOpFCDiscEqWidth.BuildCutPoints;
var i,j,k: integer;
    cAtt: TAttCutPoints;
    xmin,xmax,value,cut: TTypeContinue;
    nb_intv,intv: TTypeContinue;
begin
 nb_intv:= 1.0*(self.PrmOp as TOpPrmFCDiscEqWidth).NbIntv;
 //construire les bornes pour chaque variable
 for j:= 0 to pred(SetAttCutPoints.getNbAttCutPoints) do
  begin
   cAtt:= SetAttCutPoints.getAttCutPoints(j);
   xmin:= +1.0e308;
   xmax:= -1.0e308;
   for i:= 1 to workdata.Examples.Size do
    begin
     value:= cAtt.AttToDisc.cValue[workdata.Examples.Number[i]];
     if (value<xmin) then xmin:= value;
     if (value>xmax) then xmax:= value;
    end;
   //traiter ?
   if (xmax>xmin) and (nb_intv>0)
    then
     begin
      intv:= (xmax-xmin)/nb_intv;
      for k:= 1 to pred((self.PrmOp as TOpPrmFCDiscEqWidth).NbIntv) do
       begin
        cut:= xmin+1.0*k*intv;
        cAtt.addCutPoint(cut);
       end;
     end;
  end;
end;

function TOpFCDiscEqWidth.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFCDiscEqWidth;
end;

{ TOpPrmFCDiscEqWidth }

function TOpPrmFCDiscEqWidth.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmDiscEqWidth.CreateFromOpPrm(self);
end;

function TOpPrmFCDiscEqWidth.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_BLUE+'<th colspan="2">Equal width binning parameters</th></tr>';
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<td>Intervals</td><td align="right">%d</td></tr>',[self.FNbIntv]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmFCDiscEqWidth.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FNbIntv:= prmINI.ReadInteger(prmSection,'intervals',FNbIntv);
end;

procedure TOpPrmFCDiscEqWidth.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FNbIntv,sizeof(FNbIntv));
end;

procedure TOpPrmFCDiscEqWidth.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'intervals',FNbIntv);
end;

procedure TOpPrmFCDiscEqWidth.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FNbIntv,sizeof(FNbIntv));
end;

procedure TOpPrmFCDiscEqWidth.SetDefaultParameters;
begin
 FNbIntv:= 5;
end;

initialization
 RegisterClass(TGenFCDiscEqWidth);
end.
