unit UDlgOpPrmDiscBinBinning;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls;

type
  TdlgOpPrmDiscBinBinning = class(TDlgBaseOperatorParameter)
    rgCutPointType: TRadioGroup;
    Label1: TLabel;
    edThreshold: TEdit;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  dlgOpPrmDiscBinBinning: TdlgOpPrmDiscBinBinning;

implementation

uses UCompFCDiscBinaryBinning;

{$R *.dfm}

{ TdlgOpPrmDiscBinBinning }

procedure TdlgOpPrmDiscBinBinning.ApplyModifications;
var prm: TOpPrmFCDiscBinning;
begin
 prm:= OpPrm as TOpPrmFCDiscBinning;
 prm.TypeCutPoint:= TEnumTypeCutPoint(self.rgCutPointType.ItemIndex);
 TRY
 prm.Threshold:= StrToFloat(self.edThreshold.Text);
 EXCEPT
 prm.Threshold:= 0.5;
 END;
end;

procedure TdlgOpPrmDiscBinBinning.SetParameters;
var prm: TOpPrmFCDiscBinning;
begin
 prm:= OpPrm as TOpPrmFCDiscBinning;
 self.rgCutPointType.ItemIndex:= ord(prm.TypeCutPoint);
 self.edThreshold.Text:= FloatToStr(prm.Threshold);
end;

end.
