(************************************************************)
(* UCompFCTrend.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************)

{
@abstract(Composant trend, se contente de gnrer 1,2,3,...,n pour l'instant)
@author(Ricco)
@created(27/07/2004)

On pourrait imaginer des tendances plus "complexes", du style gomtrique et autres...  voir...
}

unit UCompFCTrend;

interface

USES
        Forms, Classes, IniFiles,
        UCompDefinition,
        UCompFCDefinition,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation;


TYPE
        {gnrateur de composant}
        TGenFCTrend = class(TMLGenComp)
                      protected
                      procedure   GenCompInitializations(); override;
                      public
                      function    GetClassMLComponent: TClassMLComponent; override;
                      end;

        {le composant}
        TMLFCTrend = class(TMLCompFC)
                     private
                     {la variable produite}
                     FTrendAtt: TAttContinue;
                     protected
                     function    getClassOperator: TClassOperator; override;
                     function    GetLogResultDescription(): string; override;
                     {gnrer la variable qui matrialisera la formule}
                     procedure   InitializeDataset(); override;
                     public
                     property    TrendAtt: TAttContinue read FTrendAtt;
                     end;

        {oprateur}
        TOpFCTrend = class(TOperatorFC)
                     protected
                     function    getClassParameter: TClassOperatorParameter; override;
                     function    CoreExecute(): boolean; override;
                     public
                     function    getHTMLResultsSummary(): string; override;   
                     end;

        {paramtre de l'oprateur}
        TOpFCTrendPrm = class(TOperatorPrmFC)
                        private
                        FFirstValue: integer;
                        protected
                        procedure   SetDefaultParameters(); override;
                        function    CreateDlgParameters(): TForm; override;
                        public
                        function    getHTMLParameters(): string; override;
                        procedure   LoadFromStream(prmStream: TStream); override;
                        procedure   SaveToStream(prmStream: TStream); override;
                        procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                        procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                        property    FirstValue: integer read FFirstValue write FFirstValue;
                        end;



implementation

USES
        Sysutils, UDlgOpPrmFCTrend;

{ TGenFCTrend }

procedure TGenFCTrend.GenCompInitializations;
begin
 FMLComp:= mlcFeatureConstruction;
end;

function TGenFCTrend.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLFCTrend;
end;

{ TOpFCTrendPrm }

function TOpFCTrendPrm.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmFCTrend.CreateFromOpPrm(self);
end;

function TOpFCTrendPrm.getHTMLParameters: string;
begin
 result:= format('<B>First value </B> = %d',[FFirstValue]);
end;

procedure TOpFCTrendPrm.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FFirstValue:= prmINI.ReadInteger(prmSection,'first_value',FFirstValue);
end;

procedure TOpFCTrendPrm.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FFirstValue,sizeof(FFirstValue));
end;

procedure TOpFCTrendPrm.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'first_value',FFirstValue);
end;

procedure TOpFCTrendPrm.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FFirstValue,sizeof(FFirstValue));
end;

procedure TOpFCTrendPrm.SetDefaultParameters;
begin
 FFirstValue:= 0;
end;

{ TMLFCTrend }

function TMLFCTrend.getClassOperator: TClassOperator;
begin
 result:= TOpFCTrend;
end;

function TMLFCTrend.GetLogResultDescription: string;
begin
 result:= 'TREND generated';
end;

procedure TMLFCTrend.InitializeDataset;
begin
 inherited InitializeDataset();
 //gnrer l'ensemble local de donnes
 FTrendAtt:= TAttContinue.Create('Trend_'+IntToStr(self.Number),LocalDataset.Size);
 LocalDataset.Add(FTrendAtt);
end;

{ TOpFCTrend }

function TOpFCTrend.CoreExecute: boolean;
var i: integer;
    att: TAttribute;
    ref: integer;
begin
 try
  //identifier la valeur de dpart
  if (PrmOp as TOpFCTrendPrm).FirstValue = 0
   then ref:= 1
   else ref:= 0;
  att:= (MLOwner as TMLFCTrend).TrendAtt;
  //very very simple
  for i:= 1 to att.Size do att.cValue[i]:= (i-ref);
  //ok man...
  result:= TRUE;
 except
  result:= FALSE;
 end;
end;

function TOpFCTrend.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpFCTrendPrm;
end;

function TOpFCTrend.getHTMLResultsSummary: string;
begin
 result:= format('<B>%s</B> generated',[(MLOwner as TMLFCTrend).TrendAtt.Name]); 
end;

initialization
 RegisterClass(TGenFCTrend);
end.
