(***********************************************************)
(* UCompFSMifs.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***********************************************************)

{

@abstract(Mthode MIFS (Battiti, 1994))
@author(Ricco)
@created(14/05/2004)

Mthode trs simple mais trs rapide et plus intressante dj que l'univari.
En filigrane l'ide de corrlation partielle bien que ce ne soit pas explicite dans l'article.

1 paramtre : l'importance  accorder aux corrlations croises (beta, default=1.0)

}

unit UCompFSMifs;

interface

uses
        Forms, Classes, IniFiles,
        UCompDefinition,
        UCompFSDefinition,
        UCompFSInputSelection,
        UOperatorDefinition,
        UCalcStatDesCrossTab,
        UDatasetDefinition,
        UDatasetExamples,
        UCalcFSCorrelation,
        UCalcCrossTab;

TYPE
        {gnrateur}
        TMLGenFSMifs = class(TMLGenFS)
                       public
                       function    GetClassMLComponent: TClassMLComponent; override;
                       end;

        {composant}
        TMLCompFSMifs = class(TMLCompFSInputSelection)
                        protected
                        function    getClassOperator: TClassOperator; override;
                        end;

        {computation rellement}
        TSelMifs = class(TSelCorr)
                   public
                   function    accept_new_attribute(prm: TOperatorParameter): boolean; override;
                   function    correlation_formula(prmTab: TCrossTab): double; override;     
                   end;

        {oprateur}
        TOpFSMifs = class(TOpFSSelCorr)
                    protected
                    function    getClassParameter: TClassOperatorParameter; override;
                    function    getClassSelection(): TClassSelCorr; override;
                    public
                    function    getHTMLResultsSummary(): string; override;
                    end;

        {paramtrage}
        TOpPrmFSMifs = class(TOpPrmFSInputSelection)
                       private
                       FBeta: double;
                       protected
                       procedure   SetDefaultParameters(); override;
                       function    CreateDlgParameters(): TForm; override;
                       public
                       procedure   LoadFromStream(prmStream: TStream); override;
                       procedure   SaveToStream(prmStream: TStream); override;
                       procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                       procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                       function    getHTMLParameters(): string; override;
                       property    Beta: double read FBeta write FBeta;
                       end;

implementation

uses
        SysUtils,
        UConstConfiguration,
        UDatasetImplementation,
        UDlgOpPrmFSMifs, ULogFile;

{ TMLGenFSMifs }

function TMLGenFSMifs.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompFSMifs;
end;

{ TOpPrmFSMifs }

function TOpPrmFSMifs.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmFSMifs.CreateFromOpPrm(self);
end;

function TOpPrmFSMifs.getHTMLParameters: string;
var s: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan="2">MIFS parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY;
 s:= s+'<TD>Beta</TD>'+format('<TD align="right">%.2f</TD>',[FBeta])+'</TR>';
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmFSMifs.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FBeta:= prmINI.ReadFloat(prmSection,'beta',FBeta);
end;

procedure TOpPrmFSMifs.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FBeta,sizeof(FBeta));
end;

procedure TOpPrmFSMifs.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteFloat(prmSection,'beta',FBeta);
end;

procedure TOpPrmFSMifs.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FBeta,sizeof(FBeta));
end;

procedure TOpPrmFSMifs.SetDefaultParameters;
begin
 FBeta:= 1.5;
end;

{ TMLCompFSMifs }

function TMLCompFSMifs.getClassOperator: TClassOperator;
begin
 result:= TOpFSMifs; 
end;

{ TOpFSMifs }

function TOpFSMifs.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFSMifs;
end;

function TOpFSMifs.getClassSelection(): TClassSelCorr;
begin
 result:= TSelMifs;
end;

function TOpFSMifs.getHTMLResultsSummary: string;
var s: string;
    j: integer;
    att: TAttribute;
begin
 s:= inherited getHTMLResultsSummary();
 //ajouter le dtail des calculs
 s:= s+'<H3>Calculations details</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY;
 s:= s+'<TH>Selected attribute</TH><TH>I (Y,X/S)</TH>';
 s:= s+'</TR>';
 for j:= 0 to pred(self.SelCorr.FNbCurSel) do
  begin
   att:= self.WorkData.LstAtts[asInput].Attribute[self.SelCorr.FCurSel[j]];
   s:= s+HTML_TABLE_COLOR_DATA_GRAY+
         format('<TD>%s</TD><TD align="right">%.6f</TD>',[att.Name,self.SelCorr.FCurInfo[j]]);
   s:= s+'</TR>';
  end;
 s:= s+'</TR>';
 s:= s+'</table>';
 result:= s;
end;

{ TSelMifs }

function TSelMifs.accept_new_attribute(prm: TOperatorParameter): boolean;
var i,j: integer;
    iMax: integer;
    sum,sumMax,beta: double;
begin
 result:= FALSE;
 beta:= (prm as TOpPrmFSMifs).Beta;
 //si la slection est dj complte, pas de calculs
 if (FNbCurSel < FXCorrelation.dim)
  then
   begin
    iMax:= -1;
    sumMax:= -1.0e308;
    //parmi tous les X, voir les elligibles
    for i:= 0 to pred(FXCorrelation.dim) do
     begin
      //on peut le tester ?
      if FXToEnter[i]
       then
        begin
         //sommer l'info mutuelle des X
         sum:= 0.0;
         //si l'ensemble est vide au dpart, on n'entre pas dans la boucle
         for j:= 0 to pred(FNbCurSel) do
          sum:= sum+FXCorrelation.getCorr(i,j);
         //vitons les divisions par zros intempestifs
         if (FNbCurSel>0)
          then sum:= sum/(1.0*FNbCurSel);
         //la formule qui tue (cf. article PKDD'2000 -- pp.229)
         sum:= FYCorrelation.getCorr(i)-beta*sum;
         //on amliore ?
         if (sum>sumMax)
          then
           begin
            sumMax:= sum;
            iMax:= i;
           end
        end;
     end;
    //alors, alors ? est-il suprieur  zro ?
    if (sumMax>EPSILON_VALUE)
     then
      begin
       //retirer des elligibles
       FXToEnter[iMax]:= FALSE;
       //ajouter dans la slection
       FCurInfo[FNbCurSel]:= sumMax;
       FCurSel[FNbCurSel]:= iMax;
       inc(FNbCurSel);
       TraceLog.WriteToLogFile(format('[MIFS] --> add att n%d, with %.4f (total = %d)',[iMax,sumMax,FNbCurSel]));
       //yes...
       result:= TRUE;
      end;
   end;
end;

function TSelMifs.correlation_formula(prmTab: TCrossTab): double;
begin
 result:= prmTab.MutualInformation();
end;

initialization
 RegisterClass(TMLGenFSMifs);
end.

