(*****************************************************************)
(* UDlgOpFSDefStatus.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

unit UDlgOpFSDefStatus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, Buttons, LMDCustomImageListBox, LMDImageListBox,
  LMDCustomComponent, lmdcont;

type
  TDlgOpPrmFSDefStatus = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    pgCtrlListbox: TPageControl;
    btnClear: TButton;
    tabTarget: TTabSheet;
    tabInput: TTabSheet;
    tabIllus: TTabSheet;
    lstTarget: TListBox;
    lstInput: TListBox;
    lstIllus: TListBox;
    btnAddSelected: TSpeedButton;
    lstAll: TLMDImageListBox;
    lmdImgList: TLMDImageList;
    btnSelectContinuous: TSpeedButton;
    btnSelectDiscrete: TSpeedButton;
    btnSortAttributesByName: TSpeedButton;
    procedure pgCtrlListboxChange(Sender: TObject);
    procedure btnAddSelectedClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure btnSelectContinuousClick(Sender: TObject);
    procedure btnSelectDiscreteClick(Sender: TObject);
    procedure btnSortAttributesByNameClick(Sender: TObject);
  private
    curLstbox: TListBox;
  public
    procedure   SetParameters(); override;
    procedure   ApplyModifications(); override;
  end;

var
  DlgOpPrmFSDefStatus: TDlgOpPrmFSDefStatus;

implementation

uses UCompFSDefineStatus, UDatasetImplementation, UDatasetDefinition,
     UFrmMainForm;

{$R *.dfm}

procedure TDlgOpPrmFSDefStatus.ApplyModifications;
var operator: TOpFSDefStatus;
    status: TEnumAttStatus;
begin
 operator:= OpPrm.Operator as TOpFSDefStatus;
 //vider les listes
 for status:= asTarget to asIllus do
  operator.StrListStatus[status].Clear;
 //remplir les listes idoines
 operator.StrListStatus[asInput].AddStrings(lstInput.Items);
 operator.StrListStatus[asTarget].AddStrings(lstTarget.Items);
 operator.StrListStatus[asIllus].AddStrings(lstIllus.Items);
end;

procedure TDlgOpPrmFSDefStatus.pgCtrlListboxChange(Sender: TObject);
begin
 //rcuprer la liste courante
 case pgCtrlListBox.ActivePageIndex of
 0: curLstbox:= lstTarget;
 1: curLstbox:= lstInput;
 2: curLstbox:= lstIllus;
 end;
end;

procedure TDlgOpPrmFSDefStatus.SetParameters;
var operator: TOpFSDefStatus;
    att: TAttribute;
    i: integer;
begin
 operator:= OpPrm.Operator as TOpFSDefStatus;
 //la liste des attributs
 for i:= 0 to pred(operator.WorkData.LstAtts[asAll].Count) do
  begin
   att:= operator.WorkData.LstAtts[asAll].Attribute[i];
   if att.isCategory(caContinue)
    then lstAll.items.AddObject(att.Name+'|'+'0',att)
    else lstAll.items.AddObject(att.Name+'|'+'1',att)
  end;
 //remplir les listes idoines
 lstInput.Items.AddStrings(operator.StrListStatus[asInput]);
 lstTarget.Items.AddStrings(operator.StrListStatus[asTarget]);
 lstIllus.Items.AddStrings(operator.StrListStatus[asIllus]);
 //activer
 self.pgCtrlListbox.ActivePage:= tabInput;
 curLstbox:= lstInput;
end;

procedure TDlgOpPrmFSDefStatus.btnAddSelectedClick(Sender: TObject);
var i: integer;
    att: TAttribute;
begin
 for i:= 0 to pred(lstAll.Items.Count) do
  begin
   if lstAll.Selected[i]
    then
     begin
      att:= lstAll.Items.Objects[i] as TAttribute;
      curLstBox.Items.AddObject(att.Name,att);
     end;
  end;
end;

procedure TDlgOpPrmFSDefStatus.btnClearClick(Sender: TObject);
begin
 CurLstBox.Items.Clear;
end;

procedure TDlgOpPrmFSDefStatus.btnSelectContinuousClick(Sender: TObject);
var i: integer;
    att: TAttribute;
begin
 for i:= 0 to pred(lstAll.Items.Count) do
  begin
   att:=lstAll.Items.Objects[i] as TAttribute;
   if att.isCategory(caContinue)
    then lstAll.Selected[i]:= TRUE
    else lstAll.Selected[i]:= FALSE;
  end;
end;

procedure TDlgOpPrmFSDefStatus.btnSelectDiscreteClick(Sender: TObject);
var i: integer;
    att: TAttribute;
begin
 for i:= 0 to pred(lstAll.Items.Count) do
  begin
   att:=lstAll.Items.Objects[i] as TAttribute;
   if att.isCategory(caDiscrete)
    then lstAll.Selected[i]:= TRUE
    else lstAll.Selected[i]:= FALSE;
  end;
end;

procedure TDlgOpPrmFSDefStatus.btnSortAttributesByNameClick(Sender: TObject);
var lstTemp: TStringList;
begin
 //liste temporaire pour le tri
 lstTemp:= TStringList.Create();
 lstTemp.Assign(lstAll.Items);
 lstTemp.Sort();
 //remettre dans la listbox les bonnes variables
 lstAll.Items.BeginUpdate();//pour viter les refresh intempestifs...
 lstAll.Items.Assign(lstTemp);
 lstAll.Items.EndUpdate();
 //virer la liste temporaire...
 lstTemp.Free();
end;

end.
