(*****************************************************************)
(* UFrmOpFSDefStatus.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Fentre d'affichage des rsultats de la dfinition du statut des attributs)
@author(Ricco)
}
unit UFrmOpFSDefStatus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Grids, ComCtrls, OleCtrls, SHDocVw, ExtCtrls;

type
  TFrmOpFSDefStatus = class(TFrmBaseOperator)
    lvStatus: TListView;
    lvAtts: TListView;
  private
  protected
  procedure InsertComponents(); override;
  public
  procedure   PrepareView(); override;
  end;

var
  FrmOpFSDefStatus: TFrmOpFSDefStatus;

implementation

uses UCompFSDefineStatus, UDatasetImplementation, UCompManageDataset,
  UConstConfiguration, UDatasetDefinition;

{$R *.dfm}

{ TFrmOpFSDefStatus }

procedure TFrmOpFSDefStatus.InsertComponents;
begin
 lvAtts.Color:= OP_WINDOW_BACK_COLOR;
 lvAtts.Font.Color:= OP_INFO_FONT_COLOR;

 lvStatus.Color:= OP_WINDOW_BACK_COLOR;
 lvStatus.Font.Color:= OP_ATTRIBUTE_FONT_COLOR;
end;

procedure TFrmOpFSDefStatus.PrepareView;
var outdata: TMLDataset;
    item: TListItem;
    i: integer;
    att: TAttribute;
begin
 outData:= (Operator as TOpFSDefStatus).OutputData;
 //le dnombrement
 item:= lvAtts.Items.Add();
 item.Caption:= 'All';
 item.SubItems.Add(Format('%3d',[outData.LstAtts[asAll].Count]));
 item:= lvAtts.Items.Add();
 item.Caption:= 'Target';
 item.SubItems.Add(Format('%3d',[outData.LstAtts[asTarget].Count]));
 item:= lvAtts.Items.Add();
 item.Caption:= 'Input';
 item.SubItems.Add(Format('%3d',[outData.LstAtts[asInput].Count]));
 item:= lvAtts.Items.Add();
 item.Caption:= 'Illustrative';
 item.SubItems.Add(Format('%3d',[outData.LstAtts[asIllus].Count]));
 //la liste
 for i:= 0 to pred(outdata.LstAtts[asAll].Count) do
  begin
   att:= outdata.LstAtts[asAll].Attribute[i];
   
   item:= lvStatus.Items.Add();
   item.Caption:= att.Name;
   
   if assigned(outdata.LstAtts[asTarget].GetFromName(att.name))
    then item.SubItems.Add('yes')
    else item.SubItems.Add('-');
   if assigned(outdata.LstAtts[asInput].GetFromName(att.name))
    then item.SubItems.Add('yes')
    else item.SubItems.Add('-');
   if assigned(outdata.LstAtts[asIllus].GetFromName(att.name))
    then item.SubItems.Add('yes')
    else item.SubItems.Add('-');
    
  end;


end;

end.
