(*****************************************************************)
(* UCompFSDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Composant de base pour la feature construction)
@author(Ricco)
@created(12/01/2004)
Le rle de cette famille de composant est de manipuler plus ou moins dynamiquement les
listes target/input/illustrative. La liste totale elle est inchange, aucune variable n'est ajoute
ou supprime dans l'ensemble de donnes.
Pour l'instant, la classe de base ne sert que de relai dans la hirarchie.
}
unit UCompFSDefinition;

interface

USES
        UCompDefinition,
        UCompManageDataset;

TYPE

        {gnrateur std}
        TMLGenFS = class(TMLGenComp)
                   protected
                   procedure   GenCompInitializations(); override;
                   end;

        {composant feature selection}
        TMLCompFS = class(TMLCompLocalData)
                    protected
                    {pas de post-manipulation de la liste des attributs ici}
                    procedure  RefreshOutput(); override;
                    end;

        {oprateur}
        TOperatorFS = class(TOpLocalData)
                      end;


implementation

uses UDatasetImplementation;

{ TMLCompFS }

procedure TMLCompFS.RefreshOutput;
begin
 //rcuprer l'entre tout btement, et ajouter les variables locales
 if assigned(self.Predecessor) and self.Predecessor.InheritsFrom(TMLCompLocalData)
  then
   begin
    //on copie uniquement les observations
    FOutputMLData.Examples.Copy((self.Predecessor as TMLCompLocalData).OutputData.Examples);
    //pas d'attributs crs localement
    //self.AddLocalAttributes();
   end;
end;

{ TMLGenFS }

procedure TMLGenFS.GenCompInitializations;
begin
 FMLComp:= mlcFeatureSelection;
end;

end.
