unit UDlgOpPrmFSUnivFisher;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel, LMDBaseEdit,
  LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit, lmdstdcA;

type
  TDlgOpPrmFSUnivFisher = class(TDlgBaseOperatorParameter)
    rgActivePrm: TRadioGroup;
    edPValue: TLMDMaskEdit;
    spinXBest: TLMDSpinEdit;
    procedure rgActivePrmClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;    
  end;

var
  DlgOpPrmFSUnivFisher: TDlgOpPrmFSUnivFisher;

implementation

uses UCompFSUnivFisher;

{$R *.dfm}

{ TDlgOpPrmFSUnivFisher }

procedure TDlgOpPrmFSUnivFisher.ApplyModifications;
var prm: TOpPrmFSUnivFisher;
begin
 prm:= self.OpPrm as TOpPrmFSUnivFisher;
 prm.ActivePrm:= self.rgActivePrm.ItemIndex;
 prm.PValue:= StrToFloat(self.edPValue.Text);
 prm.XBest:= self.spinXBest.Value;
end;

procedure TDlgOpPrmFSUnivFisher.SetParameters;
var prm: TOpPrmFSUnivFisher;
begin
 prm:= self.OpPrm as TOpPrmFSUnivFisher;
 self.rgActivePrm.ItemIndex:= prm.ActivePrm;
 self.edPValue.Text:= floattostr(prm.PValue);
 self.spinXBest.Value:= prm.XBest;
end;

procedure TDlgOpPrmFSUnivFisher.rgActivePrmClick(Sender: TObject);
begin
 self.edPValue.Enabled:= FALSE;
 self.spinXBest.Enabled:= FALSE;
 case self.rgActivePrm.ItemIndex of
  0: self.edPValue.Enabled:= TRUE;
  1: self.spinXBest.Enabled:= TRUE;
 end;
end;

end.
