(***************************************************************)
(* UCompFSUnivRuns.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************)

{

@abstract(Slectionner les input avec un test des rangs -- Test de Mood)
@author(Ricco)
@created(24/11/2004)
}

unit UCompFSUnivRuns;

interface

USES
        Forms, Classes, IniFiles,
        UCompDefinition,
        UCompFSDefinition,
        UCompFSInputSelection,
        UOperatorDefinition,
        UCalcStatDesConditionnalDesc,
        UCalcStatDesCondDescRuns,
        UCompFSUnivFisher;

TYPE
        {gnrateur}
        TMLGenFSUnivRuns = class(TMLGenFS)
                           public     
                           function    GetClassMLComponent: TClassMLComponent; override;
                           end;

        {composant}
        MLCompFSUnivRuns = class(TMLCompFSInputSelection)
                           protected
                           function    getClassOperator: TClassOperator; override;
                           end;

        {oprateur}
        TOpFSUnivRuns = class(TOpFSInputSelSpvInputContinuous)
                        private
                        FLstRuns: TLstCalcStatDesCondRuns;
                        {Filtrage selon la p-value}
                        procedure   filterWithPValue();
                        {filtrage selon les X-best}
                        procedure   filterWithXBest();
                        {filtrage selon le gap}
                        procedure   filterWithGap();
                        protected
                        function    getClassParameter: TClassOperatorParameter; override;
                        public
                        constructor Create(AOwner: TObject); override;
                        destructor  Destroy(); override;
                        function    getHTMLResultsSummary(): string; override;
                        function    CoreExecute(): boolean; override;
                        end;

        {paramtre d'oprateur -- les mmes que la FISHER...}
        TOpPrmFSUnivRuns = class(TOpPrmFSUnivFisher)
                           end;

implementation

USES
        Sysutils,
        UStringAddBuffered,
        UDatasetDefinition, UDatasetImplementation, UConstConfiguration;

{ TMLGenFSUnivRuns }

function TMLGenFSUnivRuns.GetClassMLComponent: TClassMLComponent;
begin
 result:= MLCompFSUnivRuns;
end;

{ MLCompFSUnivRuns }

function MLCompFSUnivRuns.getClassOperator: TClassOperator;
begin
 result:= TOpFSUnivRuns;
end;

{ TOpFSUnivRuns }

function TOpFSUnivRuns.CoreExecute: boolean;
var attTarget, attInput: TAttribute;
    j: integer;    
begin
 result:= TRUE;
 TRY
  //vider en dtruisant les objets
  FLstRuns.FreeAll();
  //relancer tous les calculs
  attTarget:= self.WorkData.LstAtts[asTarget].Attribute[0];
  for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
   begin
    attInput:= self.WorkData.LstAtts[asInput].Attribute[j];
    FLstRuns.AddStat(TCalcSDRunsCondDesc.Create(attInput,attTarget,self.WorkData.Examples));
   end;
  //trier sur la valeur de la stat
  FLstRuns.SortStats();
  //Filtrage...
  case (self.PrmOp as TOpPrmFSUnivRuns).ActivePrm of
   1: self.filterWithXBest();
   2: self.filterWithGap();
   //par dfaut, on utilise la p-value
   else self.filterWithPValue();
  end;
 EXCEPT
 result:= FALSE;
 END;
end;

constructor TOpFSUnivRuns.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 FLstRuns:= TLstCalcStatDesCondRuns.Create(NIL,NIL);
end;

destructor TOpFSUnivRuns.Destroy;
begin
 if assigned(FLstRuns) then FreeAndNil(FLstRuns);
 inherited;
end;

procedure TOpFSUnivRuns.filterWithGap;
var j,jMax: integer;
    delta,maxDelta: double;
begin
 jMax:= -1;
 maxDelta:= -1.0e308;
 for j:= 0 to self.FLstRuns.Count-2 do
  begin
   delta:= (self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc).StatRuns - (self.FLstRuns.Stat(succ(j)) as TCalcSDRunsCondDesc).StatRuns;
   if (delta>maxDelta)
    then
     begin
      maxDelta:= delta;
      jMax:= j;
     end;
  end;
 //puis subdiviser en deux parties
 //les slectionns
 for j:= 0 to jMax do
  self.OutputData.LstAtts[asInput].Add((self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc).Attribute);
 //les exclus
 for j:= succ(jMax) to pred(self.FLstRuns.Count) do
  self.RemovedFromInput.AddObject((self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc).Attribute.Name,(self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc).Attribute);
end;

procedure TOpFSUnivRuns.filterWithPValue;
var j: integer;
    stat: TCalcSDRunsCondDesc;
    thresold: double;
begin
 thresold:= (self.PrmOp as TOpPrmFSUnivRuns).PValue;
 for j:= 0 to pred(self.FLstRuns.Count) do
  begin
   stat:= self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc;
   if (stat.ProbaStatRuns<=thresold)
    then self.OutputData.LstAtts[asInput].Add(stat.Attribute)
    else self.RemovedFromInput.AddObject(stat.Attribute.Name,stat.Attribute);
  end;
end;


procedure TOpFSUnivRuns.filterWithXBest;
var nb,j: integer;
begin
 nb:= (self.PrmOp as TOpPrmFSUnivRuns).XBest;
 //vitons les surprises inutiles
 if (nb>self.FLstRuns.Count)
  then nb:= self.FLstRuns.Count;
 //puis prendre d'un ct les meilleurs
 for j:= 0 to pred(nb) do
  self.OutputData.LstAtts[asInput].Add((self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc).Attribute);
 //et de l'autre les exclus de la socit...
 for j:= nb to pred(self.FLstRuns.Count) do
  self.RemovedFromInput.AddObject((self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc).Attribute.Name,(self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc).Attribute);
end;

function TOpFSUnivRuns.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmFSUnivRuns; 
end;

function TOpFSUnivRuns.getHTMLResultsSummary: string;
var s: string;
    stat: TCalcSDRunsCondDesc;
    j: integer;
    buf: TBufString;
begin
 buf:= TBufString.Create();
 buf.BeginUpdate();
 s:= inherited getHTMLResultsSummary();
 buf.AddStr(s);
 //ajouter le dtail des calculs
 s:= '<H3>Calculations details</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY;
 //
 s:= s+'<TH>N</TH><TH>Attribute</TH><TH>Runs</TH><TH>Stat</TH><TH>p-value</TH>';
 s:= s+'</TR>';
 buf.AddStr(s);
 for j:= 0 to pred(self.FLstRuns.Count) do
  begin
   stat:= self.FLstRuns.Stat(j) as TCalcSDRunsCondDesc;
   s:= HTML_TABLE_COLOR_DATA_GRAY+
       format('<TD>%d</TD><TD>%s</TD><TD align="right">%d</TD><TD align="right">%.4f</TD><TD align="right">%.6f</TD></TR>',
              [succ(j),stat.Attribute.Name,stat.NbRuns,stat.StatRuns,stat.ProbaStatRuns]);
   buf.AddStr(s);
  end;
 s:= '</table>';
 buf.AddStr(s);
 buf.EndUpdate();
 result:= buf.BufS;
 buf.Free();
end;

initialization
 RegisterClass(TMLGenFSUnivRuns);
end.
