(*********************************************************************)
(* UCompISAttributeValue.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Slectionner un sous-ensemble d'individus  partir d'une rgle simplifie)
@author(Ricco)
@created(16/12/2004)

Trs simplement, on utilise un repre "Attribut = valeur" pour slectionner les individus actifs.
Cela permet, entre autres, de procder  des projections sur un autre fichier,
n'ayant pas particip  l'apprentissage.
}
unit UCompISAttributeValue;

interface

USES
        Classes, IniFiles, Forms,
        UCompDefinition, UOperatorDefinition,
        UCompISDefinition,
        UCompManageDataset;

TYPE
        {gnrateur}
        TMLGenCompISAttValue = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {composant}
        TMLCompISAttValue = class(TMLCompIS)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            end;

        {oprateur}
        TOpISAttValue = class(TOpLocalData)
                        protected
                        function    getClassParameter: TClassOperatorParameter; override;
                        function    CoreExecute(): boolean; override;
                        public
                        function    getHTMLResultsSummary(): string; override;
                        end;

        {paramtrage}
        TOpPrmISAttValue = class(TOperatorParameter)
                           private
                           {nom de l'attribut de rfrence}
                           FAttName: string;
                           {valeur de l'attribut pour slectionner les individus}
                           FAttValue: string;
                           protected
                           procedure   SetDefaultParameters(); override;
                           function    CreateDlgParameters(): TForm; override;
                           public
                           function    getHTMLParameters(): string; override;
                           //I-O
                           procedure   LoadFromStream(prmStream: TStream); override;
                           procedure   SaveToStream(prmStream: TStream); override;
                           procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                           procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                           //properties
                           property    AttName: string read FAttName write FAttName;
                           property    AttValue: string read FAttValue write FAttValue;
                           end;

implementation

USES
        Sysutils,
        UDatasetDefinition, UDatasetImplementation,
        UDatasetExamples, UDlgOpPrmISAttributeValue, UStringAddBuffered;

{ TMLGenCompISAttValue }

procedure TMLGenCompISAttValue.GenCompInitializations;
begin
 FMLComp:= mlcInstanceSelection;
end;

function TMLGenCompISAttValue.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompISAttValue;
end;

{ TMLCompISAttValue }

function TMLCompISAttValue.getClassOperator: TClassOperator;
begin
 result:= TOpISAttValue;
end;

{ TOpISAttValue }

function TOpISAttValue.CoreExecute: boolean;
var attRef: TAttribute;
    attValue: TTypeDiscrete;
    exSource, exOut: TExamples;
    i,example: integer;
begin
 result:= FALSE;
 //rcuprer l'attribut
 attRef:= self.WorkData.LstAtts[asAll].GetFromName((self.PrmOp as TOpPrmISAttValue).AttName);
 if assigned(attRef)
  then
   begin
    attValue:= attRef.LstValues.isValueAvailable((self.PrmOp as TOpPrmISAttValue).AttValue);
    if (attValue<>0)
     then
      begin
       exSource:= self.WorkData.Examples;
       exOut:= self.OutputData.Examples;
       //filtrer les exemples
       exOut.BeginAdd();
       for i:= 1 to exSource.Size do
        begin
         example:= exSource.Number[i];
         if (attRef.dValue[example] = attValue)
          then exOut.AddExample(example);
        end;
       exOut.EndAdd();
       result:= (exOut.Size > 0);
      end;
   end;
end;

function TOpISAttValue.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmISAttValue;
end;

function TOpISAttValue.getHTMLResultsSummary: string;
begin
 result:= Format('<b>%d</b> selected examples from <b>%d</b>',[self.OutputData.Examples.Size,self.workdata.examples.Size]);
end;

{ TOpPrmISAttValue }

function TOpPrmISAttValue.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmISAttributeValue.CreateFromOpPrm(self);
end;

function TOpPrmISAttValue.getHTMLParameters: string;
begin
 result:= format('Attribute selection : %s<br>',[FAttName])
          +format('Value selection : %s',[FAttValue]);
end;

procedure TOpPrmISAttValue.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FAttName:= prmINI.ReadString(prmSection,'attribute',FAttName);
 FAttValue:= prmINI.ReadString(prmSection,'value',FAttValue);
end;

procedure TOpPrmISAttValue.LoadFromStream(prmStream: TStream);
begin
 loadStringFromStream(FAttName,prmStream);
 loadStringFromStream(FAttValue,prmStream);
end;

procedure TOpPrmISAttValue.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteString(prmSection,'attribute',FAttName);
 prmINI.WriteString(prmSection,'value',FAttValue);
end;

procedure TOpPrmISAttValue.SaveToStream(prmStream: TStream);
begin
 saveStringToStream(FAttName,prmStream);
 saveStringToStream(FAttValue,prmStream);
end;

procedure TOpPrmISAttValue.SetDefaultParameters;
begin
 FAttName:= '';
 FAttValue:= '';
end;

initialization
 RegisterClass(TMLGenCompISAttValue);
end.
