(**********************************************************************)
(* UDlgOpPrmStratSampling.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**********************************************************************)

unit UDlgOpPrmStratSampling;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgOpPrmSampling, StdCtrls, CheckLst, lmdstdcA, ExtCtrls,
  ComCtrls;

type
  TDlgOpPrmStratSampling = class(TDlgOpPrmSampling)
    Label2: TLabel;
    cmbAtt: TComboBox;
    rgStratType: TRadioGroup;
  private
  public
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  DlgOpPrmStratSampling: TDlgOpPrmStratSampling;

implementation

uses UCompISStratifiedSampling, UDatasetImplementation, UDatasetDefinition;

{$R *.dfm}

{ TDlgOpPrmStratSampling }

procedure TDlgOpPrmStratSampling.ApplyModifications;
var  prm: TOpPrmStratSampling;
begin
 prm:= OpPrm as TOpPrmStratSampling;
 //rcuprer les paramtres
 prm.SampleType:= self.rgSampleType.ItemIndex;
 prm.Proportion:= 1.0*self.spinProportion.Value/100.0;
 prm.Size:= self.spinAbsolute.Value;
 prm.StratType:= self.rgStratType.ItemIndex;
 prm.StratAttName:= self.cmbAtt.Text;
end;

procedure TDlgOpPrmStratSampling.SetParameters;
var prm: TOpPrmStratSampling;
    op: TOpStratSampling;
    i: integer;
begin
 prm:= OpPrm as TOpPrmStratSampling;
 //lister les variables candidates
 op:= prm.Operator as TOpStratSampling;
 for i:= 0 to pred(op.WorkData.LstAtts[asAll].Count) do
  if op.WorkData.LstAtts[asAll].Attribute[i].isCategory(caDiscrete)
   then self.cmbAtt.Items.Add(op.WorkData.LstAtts[asAll].Attribute[i].Name);
 //afficher les paramtres
 self.rgSampleType.ItemIndex:= prm.SampleType;
 self.spinProportion.Value:= trunc(100.0*prm.Proportion);
 self.spinAbsolute.Value:= prm.Size;
 self.rgStratType.ItemIndex:= prm.StratType;
 self.cmbAtt.Text:= prm.StratAttName;
end;

end.
