(***************************************************************)
(* UCompISSampling.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************)

{
@abstract(Le composant chantillonnage simple)
@author(Ricco)
@created(12/01/2004)
C'est le premier composant qui ralise effectivement un calcul, il est 
prvoir qu'une partie du code rdig ici sera transfr dans l'anctre commun
MLComponent afin notamment d'implmenter de manire gnrique la propagation des calculs.

Ce composant agit essentiellement sur les individus slectionns, il n'a aucune action sur
}
unit UCompISSampling;

interface

USES
        Forms, Classes,
        IniFiles,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UCompISDefinition;

TYPE
        {Gnrateur de sapmling}
        TMLGenCompSampling = class(TMLGenComp)
                             protected
                             procedure   GenCompInitializations(); override;
                             public
                             function    GetClassMLComponent: TClassMLComponent; override;
                             end;

        {composant sampling}
        TMLCompSampling = class(TMLCompIS)
                          protected
                          function    getClassOperator: TClassOperator; override;
                          function    GetLogResultDescription(): string; override;
                          end;

        {oprateur associ}
        TOpSampling     = class(TOpLocalData)
                          protected
                          function    getClassParameter: TClassOperatorParameter; override;
                          {lancer l'chantillonnage proprement dit}
                          function    CoreExecute(): boolean; override;
                          public
                          function    getHTMLResultsSummary(): string; override;
                          end;

        {paramtrage associ}
        TOpPrmSampling  = class(TOperatorParameter)
                          private
                          {dfinition de la taille de l'chantillonnage :
                          0 -> proportion,
                          1 -> taille absolue}
                          FSampleType: integer;
                          {proportion des individus  chantillonner}
                          FProportion: single;
                          {taille de l'chantillon}
                          FSize: integer;
                          protected
                          procedure   SetDefaultParameters(); override;
                          function    CreateDlgParameters(): TForm; override;
                          public
                          function    getHTMLParameters(): string; override;
                          procedure   LoadFromStream(prmStream: TStream); override;
                          procedure   SaveToStream(prmStream: TStream); override;
                          procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                          procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                          property    Proportion: single read FProportion write FProportion;
                          property    SampleType: integer read FSampleType write FSampleType;
                          property    Size: integer read FSize write FSize;
                          end;

implementation

uses
        SysUtils,
        UFrmBaseOperator, UDlgOpPrmSampling, UDatasetExamples,
        ULogFile, UConstConfiguration, UStringsResources;

resourcestring
        ID_HTML_SAMPLING_PROPORTION = 'Sampling proportion';
        ID_HTML_INPUT_SAMPLE_SIZE = 'Input';
        ID_HTML_OUTPUT_SAMPLE_SIZE = 'Output';

{ TMLGenCompSampling }

procedure TMLGenCompSampling.GenCompInitializations;
begin
 FMLComp:= mlcInstanceSelection;
 //FMLNumIcon:= 2;
 //FMLCompName:= str_comp_name_is_sampling;
 //FMLBitmapFileName:= 'MLSampling.bmp';
end;

function TMLGenCompSampling.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSampling;
end;

{ TMLCompSampling }

function TMLCompSampling.getClassOperator: TClassOperator;
begin
 result:= TOpSampling;
end;

function TMLCompSampling.GetLogResultDescription: string;
begin
 result:= Format('From [%d] examples to a sample of [%d] examples',[(self.Predecessor as TMLCompLocalData).OutputData.Examples.Size,self.OutputData.Examples.Size]);
end;

{ TOpSampling }

function TOpSampling.CoreExecute: boolean;
var exIn,exOut: TExamples;
    outSize: Integer;
begin
 //le deuxime cast est valide, sinon la connexion n'aurait pas pu tre ralise
 exIn:= ((self.MLOwner as TMLComponent).Predecessor as TMLCompLocalData).OutputData.Examples;
 exOut:= (self.MLOwner as TMLCompLocalData).OutputData.Examples;
 //excution relle avec rcupration des paramtres  la vole
 case (self.PrmOp as TOpPrmSampling).SampleType of
  0: outSize:= exIn.Sampling((self.PrmOp as TOpPrmSampling).Proportion,exOut)
  else outSize:= exIn.Sampling((self.PrmOp as TOpPrmSampling).Size,exOut);
 end;
 //ok...
 result:= (outSize>0);
end;

function TOpSampling.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSampling;
end;

function TOpSampling.getHTMLResultsSummary: string;
var s: string;
begin
 s:= '<P>'+HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Sample</TH><TH>Size</TH>';
 s:= s+Format(HTML_TABLE_COLOR_DATA_GRAY+'<td>%s</td><td align=right>%d</td>',[ID_HTML_INPUT_SAMPLE_SIZE,WorkData.Examples.Size]);
 s:= s+Format(HTML_TABLE_COLOR_DATA_GRAY+'<td>%s</td><td align=right>%d</td>',[ID_HTML_OUTPUT_SAMPLE_SIZE,OutputData.Examples.Size]);
 s:= s+'</table>';
 result:= s;
end;

{ TOpPrmSampling }

function TOpPrmSampling.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmSampling.CreateFromOpPrm(self);
end;

function TOpPrmSampling.getHTMLParameters: string;
var s: string;
begin
 s:= format('<P>Sample type : %d<BR>',[FSampleType]);
 if (FSampleType=0)
  then s:= s+format('%s : %4.2f%s<BR>',[ID_HTML_SAMPLING_PROPORTION,100.0*FProportion,'%'])
  else s:= s+format('Sample size : %d<BR>',[FSize]);
 result:= s;
end;

procedure TOpPrmSampling.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FSampleType:= prmINI.ReadInteger(prmSection,'sample_type',FSampleType);
 FProportion:= prmINI.ReadFloat(prmSection,'proportion',FProportion);
 FSize:= prmINI.ReadInteger(prmSection,'size',FSize);
end;

procedure TOpPrmSampling.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FSampleType,sizeof(FSampleType));
 prmStream.ReadBuffer(Fproportion,sizeof(FProportion));
 prmStream.ReadBuffer(FSize,sizeof(FSize));
end;

procedure TOpPrmSampling.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteInteger(prmSection,'sample_type',FSampleType);
 prmINI.WriteFloat(prmSection,'proportion',FProportion);
 prmINI.WriteInteger(prmSection,'size',FSize);
end;

procedure TOpPrmSampling.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FSampleType,sizeof(FSampleType));
 prmStream.WriteBuffer(Fproportion,sizeof(FProportion));
 prmStream.WriteBuffer(FSize,sizeof(FSize));
end;

procedure TOpPrmSampling.SetDefaultParameters;
begin
 FSampleType:= 0;
 FProportion:= 0.50;
 FSize:= 200;
end;

initialization
 RegisterClass(TMLGenCompSampling);
end.
