(********************************************************)
(* MATRIXMM.PAS - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************)

{
@abstract(Manipulation en mmoire de matrice de donnes -- doublon avec la biblio de J. Debord mais valid avec REGRESS)
@author(Ricco)
@created(12/07/2004)
}

UNIT MATRIXMM;

{$B-}

INTERFACE

TYPE TData = double;

Const
     SizeData    = SizeOf(TData);
     SizePointer = SizeOf(Pointer);

TYPE
     {Structure en colonne}
     TColonnesMatrice     = Array[1..2147483647 div SizeData] of TData;
     TPtrColonnesMatrice  = ^TColonnesMatrice;
     
     {Injection des lignes}
     TLignesColonnes      = Array[1..2147483647 div SizeOf(TPtrColonnesMatrice)]
                              Of TPtrColonnesMatrice;
     TPtrLignesColonnes   = ^TLignesColonnes;
     
     {Matrice avec ses indicateurs de taille appropries}
     TStructureMatrice    = Record
                             Lig,Col: Integer;
                             PtrData: TPtrLignesColonnes;
                            End;

     PManipMatMM=Class
                 protected
                  Cree:Byte;
                 public
                  MatMM:TStructureMatrice;
                  Constructor Create(l,c:Integer);
                  Destructor  Destroy; override;
                  Procedure   Place(i,j:Integer;v:TData);virtual;
                  Function    Prendre(i,j:Integer):TData;virtual;
                  property    Valeur[i,j: integer]: TData read Prendre write Place; default;
                 End;

     {code erreur matrices : pas d'erreur, pbm de dimension, matrice non inversible}            
     TEnumErrCodeMatrixOperation = (errMM_NoError,errMM_Dim,errMM_NotInversible);


Function MultiplicationMM(MA,MB:PManipMatMM;Var MC:PManipMatMM):Byte;
Function AdditionMM(MA,MB:PManipMatMM;Var MC:PManipMatMM):Byte;
Function SoustractionMM(MA,MB:PManipMatMM;Var MC:PManipMatMM):Byte;
Function TranspositionMM(MA:PManipMatMM;Var MC:PManipMatMM):Byte;
Function CopieMM(MA:PManipMatMM;Var MC:PManipMatMM):Byte;
Function DeterminantMM(MA:PManipMatMM):TData;
Function InversionMM(MA:PManipMatMM;Var MC:PManipMatMM):TEnumErrCodeMatrixOperation;
Function MoyenneMM(M:PManipMatMM;j:Integer):TData;
Function SCEMM(M:PManipMatMM;j:Integer):TData;
Function VarPopMM(M:PManipMatMM;j:Integer):TData;
Function VarEchMM(M:PManipMatMM;j:Integer):TData;
procedure Affiche(s:string;Var M:PManipMatMM);
Function TranspositionVec(MA:PManipMatMM;Var MC:PManipMatMM):Byte;
Function MultiplScalarMM(v:TData;Var M:PManipMatMM):Byte;
Function OpCovarMM(MA,MB:PManipMatMM;ja,jb:Integer):TData;
Function QSort(Var M:PManipMatMM;Cj:Integer):Byte;

Function DifferenceRho(M:PManipMatMM;Rho:TData;Var DM:PManipMatMM):Byte;

Function EnleveLigne(Var M,MS:PManipMatMM;i:Integer):Byte;
Function CopieLigne(Var M,MS:PManipMatMM;i:Integer):Byte;

Function calcCorrelation(MY,MX: PManipMatMM; j: integer): TData;

IMPLEMENTATION

USES SYSUTILS,CONTROLS,CLASSES;

Constructor PManipMatMM.Create;
var i:Integer;
Begin
 inherited Create;
 {Indicateurs de taille}
 MatMM.Lig:=l;
 MatMM.Col:=c;
 {Rserver la mmoire}
 MatMM.PtrData:= AllocMem(L*SizePointer);
 For i:= 1 To L Do
  MatMM.PtrData^[i]:= AllocMem(C*SizeData);
 Cree:=115;
End;


Destructor PManipMatMM.Destroy;
var i: Integer;
Begin
 If (Cree=115) Then
  Begin
   For i:= 1 To MatMM.Lig Do
    ReAllocMem(MatMM.PtrData^[i],0);
   ReAllocMem(MatMM.PtrData,0);
   Cree:= 110;
  End;
 inherited Destroy;
End;


Procedure PManipMatMM.Place(i,j:Integer;v:TData);
Begin
 MatMM.PtrData^[i]^[j]:= v;
End;

Function PManipMatMM.Prendre(i,j:Integer):TData;
Begin
 Result:= MatMM.PtrData^[i]^[j];
End;


Function AdditionMM(MA,MB:PManipMatMM;Var MC:PManipMatMM):Byte;
var i,j:Integer;
Begin
 If (MA.MatMM.Lig=MB.MatMM.Lig) AND (MA.MatMM.Col=MB.MatMM.Col)
  Then
   Begin
     TRY
     {If Assigned(MC) Then MC.Free;}
     EXCEPT
     END;
     MC:= PManipMatMM.Create(MA.MatMM.Lig,MA.MatMM.Col);
    For i:= 1 To MC.MatMM.Lig Do
     For j:= 1 To MC.MatMM.Col Do
      MC.MatMM.PtrData^[i]^[j]:= MA.MatMM.PtrData^[i]^[j]+MB.MatMM.PtrData^[i]^[j];
   End
  Else
   Raise EInvalidOperation.Create('Paramtres de matrices incompatibles');
 AdditionMM:=0;
End;

{On reprend classiquement les multiplications de matrices}
Function MultiplicationMM(MA,MB:PManipMatMM;Var MC:PManipMatMM):Byte;
var i,j,k:Integer;
    v: TData;
Begin
 If (MB.MatMM.Lig=MA.MatMM.Col)
  Then
   Begin
     TRY
     {If Assigned(MC) Then MC.Free;}
     EXCEPT
     END;
     MC:= PManipMatMM.Create(MA.MatMM.Lig,MB.MatMM.Col);
    For i:=1 to MA.MatMM.Lig Do
     For j:=1 to MB.MatMM.Col Do
      Begin
      v:=0;
      For k:=1 to MB.MatMM.Lig Do
       v:=v+MA.MatMM.PtrData^[i]^[k]*MB.MatMM.PtrData^[k]^[j];
      MC.MatMM.PtrData^[i]^[j]:= v;
      End;
   End
  Else
   Raise EInvalidOperation.Create('Paramtres de matrices incompatibles');
 MultiplicationMM:=0;
End;

(*Procedure Saute(Var P:PTData;n:Integer);
var i:Integer;
Begin
 i:=0;
 While (i<n) AND (P<>NIL) Do
  Begin
   P:=P^.Suiv;
   inc(i);
  End;
End;

{Ancienne procdure de multiplication avec les listes chanes}
Function MultiplicationMM(MA,MB:PManipMatMM;Var MC:PManipMatMM):Byte;
var i,j,k:Integer;
    v:TData;
    PA,PB:PTData;
Begin
 If (MB^.MatMM^.Lig=MA^.MatMM^.Col)
  Then
   Begin
    MC^.Init(MA^.MatMM^.Lig,MB^.MatMM^.Col);
    For i:=1 to MA^.MatMM^.Lig Do
     Begin
      PB:=MB^.MatMM^.ListTData;
      For j:=1 to MB^.MatMM^.Col Do
       Begin
        v:=0;
	PA:=MA^.MatMM^.ListTData;
        Saute(PA,i-1);
        for k:=1 to MA^.MatMM^.Col do
         Begin
          v:=v+PA^.x*PB^.x;
          PB:=PB^.Suiv;
          Saute(PA,MA^.MatMM^.Lig);
         End;
        MC^.Place(i,j,v);
       End;
     End;
   End
  Else
   Writeln('Paramtres incompatibles');
 MultiplicationMM:=0;
End;*)

Function SoustractionMM(MA,MB:PManipMatMM;Var MC:PManipMatMM):Byte;
var i,j:Integer;
Begin
 If (MA.MatMM.Lig=MB.MatMM.Lig) AND (MA.MatMM.Col=MB.MatMM.Col)
  Then
   Begin
     TRY
     {If Assigned(MC) Then MC.Free;}
     EXCEPT
     END;
    MC:= PManipMatMM.Create(MA.MatMM.Lig,MA.MatMM.Col);
    For i:= 1 To MC.MatMM.Lig Do
     For j:= 1 To MC.MatMM.Col Do
      MC.MatMM.PtrData^[i]^[j]:= MA.MatMM.PtrData^[i]^[j]-MB.MatMM.PtrData^[i]^[j];
   End
  Else
   Raise EInvalidOperation.Create('Paramtres de matrices incompatibles');
 SoustractionMM:=0;
End;

{Transposition d'une matrice}
Function TranspositionMM(MA:PManipMatMM;Var MC:PManipMatMM):Byte;
var i,j:Integer;
Begin
  TRY
   {If Assigned(MC) Then MC.Free;}
  EXCEPT
  END;
  MC:= PManipMatMM.Create(MA.MatMM.Col,MA.MatMM.Lig);
 For i:=1 to MA.MatMM.Lig Do
  For j:=1 to MA.MatMM.Col Do
   MC.Place(j,i,MA.Prendre(i,j));
 TranspositionMM:=0;
End;

{Transposition d'un vecteur}
Function TranspositionVec(MA:PManipMatMM;Var MC:PManipMatMM):Byte;
var i,j:Integer;
Begin
 If (MA.MatMM.Col=1) OR (MA.MatMM.Lig=1)
  Then
   Begin
    TRY
    {If Assigned(MC) Then MC.Free;}
    EXCEPT
    END;
    MC:= PManipMatMM.Create(MA.MatMM.Col,MA.MatMM.Lig);
    If (MC.MatMM.Lig=1)
     Then For j:= 1 To MC.MatMM.Col Do MC.Place(1,j,MA.Prendre(j,1))
     Else For i:= 1 To MC.MatMM.Lig Do MC.Place(i,1,MA.Prendre(1,i));
   End
  Else
   Raise EInvalidOperation.Create('Paramtres de matrices incompatibles');
 TranspositionVec:=0;
End;


{********** Procdures et Fonctions prives *****************}

procedure Affiche(s:string;Var M:PManipMatMM);
var i,j:Integer;
    f:textFile;
begin
 assignFile(f,s);
 rewrite(f);
 writeln(f);
 for i:=1 to M.MatMM.Lig do
  begin
   writeln(f);
   for j:=1 to M.MatMM.Col do
    begin
     write(f,M.Prendre(i,j):8:4);
     write(f,#9);
    end;
  End;
 writeln(f);
 closeFile(f);
End;

{Inversion "et" calcul du dterminant sur deux matrices ???  confirmer 20/12/97}
Function commun_inv_det(var MC,MA:PManipMatMM):Boolean;
const epsilon=1E-30;
var i,j,k,n:Integer;
    m:TData;
    possible:Boolean;
begin
possible:=true;
n:=MA.MatMM.Lig;
j:=1;
while (possible) and (j<=n) do
 begin
 i:=j;
 while  (i<=n) and (abs(MA.Prendre(i,j))<epsilon) do
  i:=i+1;
 if i<=n then possible:=true else possible:=false;
 if possible then
    begin
    if i<>j then
      begin
      for k:=1 to n do
       begin
       MA.Place(j,k,MA.Prendre(j,k)+MA.Prendre(i,k));
       MC.Place(j,k,MC.Prendre(j,k)+MC.Prendre(i,k));
       end;
      end;
    for i:=1 to n do
     begin
     if i<>j then
        begin
        m:=MA.Prendre(i,j)/MA.Prendre(j,j);
        for k:=1 to n do
         begin
         MA.Place(i,k,MA.Prendre(i,k)-m*MA.Prendre(j,k));
         MC.Place(i,k,MC.Prendre(i,k)-m*MC.Prendre(j,k));
         end;{de for k }
        end;{de if i<>j}
     end;{de for i }
    end;{de if possible}
 j:=j+1;
 end;{de while possible and j<=n}
 commun_inv_det:=Possible;
end;

{Copie d'une matrice sur une autre}
Function CopieMM(MA:PManipMatMM;var MC:PManipMatMM):Byte;
Var i,j: Integer;
Begin
  TRY
  {If Assigned(MC) Then MC.Free;}
  EXCEPT
  END;
  MC:= PManipMatMM.Create(MA.MatMM.Lig,MA.MatMM.Col);
 (* vrifier
 For i:= 1 To MC.MatMM.Lig Do
  Move(MA.MatMM.PtrData^[i],MC.MatMM.PtrData^[i],MC.MatMM.Col*SizeData);*)
 For i:= 1 To MC.MatMM.Lig Do
  For j:= 1 To MC.MatMM.Col Do
   MC.MatMM.PtrData^[i]^[j]:= MA.MatMM.PtrData^[i]^[j]; 
 CopieMM:=0;
End;


{**************************************************************}

{Calcul du dterminant}
Function DeterminantMM(MA:PManipMatMM):TData;
var i,n:Integer;
    MD,MB:PManipMatMM;
    m:TData;
begin
 DeterminantMM:=0;
 n:=MA.MatMM.Lig;
 if (n=MA.MatMM.Col)
  Then
   Begin
    MD:= PManipMatMM.Create(n,n);
    CopieMM(MA,MB);
    if Not(commun_inv_det(MD,MB))
     Then
      DeterminantMM:=0
     Else
      Begin
       m:=1;
       for i:=1 to n do
        m:=m*MB.Prendre(i,i);
       DeterminantMM:=m;
      End;
     MD.Free; MB.Free;
    End
   Else
    Writeln('Paramtres incompatibles');
end;{fin de function }

Function InversionMM(MA:PManipMatMM;Var MC:PManipMatMM):TEnumErrCodeMatrixOperation;
var i,j,n:Integer;
    MD:PManipMatMM;
Begin
 result:= errMM_NoError;
 n:=MA.MatMM.Lig;
 If (n=MA.MatMM.Col)
  Then
   Begin
    MC:= PManipMatMM.Create(n,n);
    MD:= PManipMatMM.Create(n,n);
    CopieMM(MA,MD);
    for i:=1 to n do
     begin
     for j:=1 to n do
      MC.Place(i,j,0);
     MC.Place(i,i,1);
     end;
    If commun_inv_det(MC,MD)
     Then
      Begin
       for i:=1 to n do
        for j:=1 to n do
         MC.Place(i,j,MC.Prendre(i,j)/MD.Prendre(i,i));
      End
     Else result:= errMM_NotInversible;
    MD.Free;
   End
  Else result:= errMM_Dim;
end;{fin de procedure}

Function MultiplScalarMM(v:TData;Var M:PManipMatMM):Byte;
Var i,j: Integer;
Begin
 For i:= 1 To M.MatMM.Lig Do
  For j:= 1 To M.MatMM.Col Do
   M.MatMM.PtrData^[i]^[j]:= M.MatMM.PtrData^[i]^[j]*v;
 MultiplScalarMM:=0;
End;

Function MoyenneMM(M:PManipMatMM;j:Integer):TData;
var i:Integer;
    moy:TData;
Begin
 if (j>0) and (j<=M.MatMM.Col)
  Then
   Begin
    moy:=0;
    for i:=1 to M.MatMM.Lig do
     moy:=moy+M.MatMM.PtrData^[i]^[j];
    moy:=moy/M.MatMM.Lig;
    MoyenneMM:=moy;
   End
  Else
   MoyenneMM:=-1e38;
End;


Function SCEMM(M:PManipMatMM;j:Integer):TData;
var i:Integer;
    moy,sce:TData;
Begin
 if (j>0) and (j<=M.MatMM.Col)
  Then
   Begin
    moy:=MoyenneMM(M,j);
    sce:=0;
    For i:=1 to M.MatMM.Lig Do
     sce:=sce+(M.MatMM.PtrData^[i]^[j]-moy)*(M.MatMM.PtrData^[i]^[j]-moy);
    SCEMM:=sce;
   End
  Else
   SCEMM:=-1e38;
End;


Function VarPopMM(M:PManipMatMM;j:Integer):TData;
Begin
 VarPopMM:=SCEMM(M,j)/M.MatMM.Lig;
End;

Function VarEchMM(M:PManipMatMM;j:Integer):TData;
Begin
if M.MatMM.Lig>1
 Then
  VarEchMM:=SCEMM(M,j)/(M.MatMM.Lig-1)
 Else
  VarEchMM:=0;
End;

Function OpCovarMM(MA,MB:PManipMatMM;ja,jb:Integer):TData;
Var s,moya,moyb:TData;
    i:Integer;
Begin
 If (MA.MatMM.Lig=MB.MatMM.Lig)
    AND (ja<=MA.MatMM.Col)
    AND (jb<=MB.MatMM.Col)
  Then
   Begin
    moya:=MoyenneMM(MA,ja);
    moyb:=MoyenneMM(MB,jb);
    s:=0;
    For i:=1 to MA.MatMM.Lig Do
     s:=s+(MA.MatMM.PtrData^[i]^[ja]-moya)*(MB.MatMM.PtrData^[i]^[jb]-moyb);
    OpCovarMM:=s/(MA.MatMM.Lig-1);
   End
  Else
   OpCovarMM:=0;
End;

{Trie une des colonnes selon cette colonne}
Function QSort(Var M:PManipMatMM;Cj:Integer):Byte;

Var Lo,Hi:Integer;

PROCEDURE Sort(l,r: INTEGER);
VAR
  i,j: INTEGER;
  x,y:TData;
BEGIN
  i := l; j := r; x := M.Prendre((l+r) DIV 2,Cj);
  REPEAT
    WHILE M.Prendre(i,Cj)<x DO i:=i+1;
    WHILE x<M.Prendre(j,Cj) DO j:=j-1;
    IF i<=j THEN
    BEGIN
      y:=M.Prendre(i,Cj); M.Place(i,Cj,M.Prendre(j,Cj));
      M.Place(j,Cj,y);
      i:=i+1; j:=j-1;
    END;
  UNTIL i>j;
  IF l<j THEN sort(l,j);
  IF i<r THEN sort(i,r);
END;

BEGIN
  TRY
  Lo:=1;
  Hi:=M.MatMM.Lig;
  Sort(Lo,Hi);
  Result:= 0;
  EXCEPT
  Result:= 1;
  END;
END;

Function DifferenceRho(M:PManipMatMM;Rho:TData;Var DM:PManipMatMM):Byte;
Var l,k: Integer;
Begin
 Result:= 0;
 TRY
 DM:= PManipMatMM.Create(M.MatMM.Lig-1,M.MatMM.Col);
 For k:= 1 To DM.MatMM.Col Do
  For l:= 1 To DM.MatMM.Lig Do
    DM.Place(l,k,M.Prendre(l+1,k)-rho*M.Prendre(l,k));
 EXCEPT
 Result:= 1;
 END;
End;

Function EnleveLigne(Var M,MS:PManipMatMM;i:Integer):Byte;
Var l,j,k:Integer;
Begin
 Result:= 0;
 TRY
 k:=0;
 MS:= PManipMatMM.Create(M.MatMM.Lig-1,M.MatMM.Col);
 For l:=1 To M.MatMM.Lig Do
  Begin
   If (l<>i)
    Then
     Begin
      Inc(k);
      For j:= 1 To M.MatMM.Col Do
        MS.Place(k,j,M.Prendre(l,j));
     End;
  End;
 EXCEPT
 Result:= 1;
 END;
End;

Function CopieLigne(Var M,MS:PManipMatMM;i:Integer):Byte;
Var j:Integer;
Begin
 Result:= 0;
 TRY
 MS:= PManipMatMM.Create(1,M.MatMM.Col);
 (*Move(M.MatMM.PtrData^[i],MS.MatMM.PtrData^[1],M.MatMM.Col*SizeData);*)
 For j:= 1 To MS.MatMM.Col Do
  MS.MatMM.PtrData^[1]^[j]:= M.MatMM.PtrData^[i]^[j];
 EXCEPT
 Result:= 1;
 END;
End;

//calculer la corrlation entre 2 colonnes d'une matrice
Function calcCorrelation(MY,MX: PManipMatMM; j: integer): TData;
var sYX,sX,sY,sX2,sY2: TData;
    i: integer;
    n,num,denom: TData;
begin
 //vrifier les conditions d'application
 if (j <= MY.MatMM.Col) and (j <= MX.MatMM.Col) and (MY.MatMM.Lig = MX.MatMM.Lig)
  then
   begin
    n:= 1.0*MY.MatMM.Lig;
    //init.
    sYX:= 0.0;
    sX:= 0.0;
    sY:= 0.0;
    sX2:= 0.0;
    sY2:= 0.0;
    //additions
    for i:= 1 to MY.MatMM.Lig do
     begin
      //Y
      sY:= sY + MY[i,j];
      sY2:= sY2 + MY[i,j] * MY[i,j];
      //X
      sX:= sX + MX[i,j];
      sX2:= sX2 + MX[i,j] * MX[i,j];
      //YX
      sYX:= sYX + MY[i,j] * MX[i,j];
     end;
    //calculs des moyennes
    sY:= sY / n;
    sX:= sX / n;
    //des variances
    num:= sYX - n * sY * sX;
    denom:= (sY2 - n * SY * SY)*(sX2 - n * SX * SX);
    //si ok division
    if (denom > 0.0)
     then result:= num / SQRT(denom)
     else result:= 0.0
   end
  else result:= 0.0;
end;

End.





