(******************************************************************)
(* UCompRegDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************)

{
@abstract(Composant de base - Rgression)
@author(Ricco)
@created(12/01/2004)
Utilisation intensive de la bibliothque de J Debord dans cette partie.
}
unit UCompRegDefinition;

interface

USES
        UCompManageDataset,
        UDatasetDefinition,
        UDatasetImplementation;

TYPE
        {le composant anctre de la rgression - son rle consiste avant tout
         s'assurer de la possibilit d'une rgression en vrifiant le type et le nombre des
        attributs. Deux nouveaux attributs seront galements produits, la
        prediction et l'erreur de prdiction}
        TMLCompRegression = class(TMLCompLocalData)
                            private
                            {attribut de prdiction}
                            FAttPred: TAttContinue;
                            {erreur de prdiction}
                            FAttErr: TAttContinue;
                            protected
                            {gnrer les deux attributs}
                            procedure   InitializeDataset(); override;
                            {lister les attributs gnrs}
                            function    GetLogResultDescription(): string; override;
                            {nom gnrique de l'attribut de gnr -  surcharger absolument}
                            function    getGenericAttName(): string; virtual; abstract;
                            public
                            property AttPred: TAttContinue read FAttPred;
                            property AttErr: TAttContinue read FAttErr;
                            end;

        {oprateur de rgression}
        TOperatorRegression = class(TOpLocalData)
                              private
                              {l'attribut  prdire}
                              FEndogenous: TAttribute;
                              {endogne prdite, pointeur simple sur celui du MLCompReg}
                              FEndoPred: TAttribute;
                              {erreur de prdiction, pointeur simple sur celui de MLCompReg}
                              FErrPred: TAttribute;
                              protected
                              function    CheckAttributes(): boolean; override;
                              public
                              constructor Create(AOwner: TObject); override;
                              property Endogenous: TAttribute read FEndogenous;
                              property EndoPred: TAttribute read FEndoPred;
                              property ErrPred: TAttribute read FErrPred;
                              end;

implementation

uses
        SysUtils;

{ TMLCompRegression }

function TMLCompRegression.GetLogResultDescription: string;
begin
 result:= Format('%d attributes before, %d attributes after >> pred: %s -- err: %s',
         [(self.Predecessor as TMLCompLocalData).OutputData.LstAtts[asAll].Count,self.OutputData.lstAtts[asAll].Count,
         FAttPred.Name,FAttErr.Name]);
end;

procedure TMLCompRegression.InitializeDataset;
begin
 inherited InitializeDataset();
 //gnrer l'ensemble local de donnes
 FAttPred:= TAttContinue.Create(Format('Pred_%s_%d',[self.getGenericAttName(),self.Number]),LocalDataset.Size);
 LocalDataset.Add(FAttPred);
 FAttErr:= TAttContinue.Create(Format('Err_Pred_%s_%d',[self.getGenericAttName(),self.Number]),LocalDataset.Size);
 LocalDataset.Add(FAttErr);
end;

{ TOperatorRegression }

function TOperatorRegression.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= (workdata.LstAtts[asTarget].Count=1) and (workdata.LstAtts[asTarget].isAllCategory(caContinue));
 //rcupration de l'endogne
 if ok then FEndogenous:= workdata.LstAtts[asTarget].Attribute[0];
 //tester l'existence des exognes
 ok:= ok and (workdata.LstAtts[asInput].Count>0);
 //suite...
 result:= ok;
end;

constructor TOperatorRegression.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 //pointeurs
 FEndoPred:= (AOwner as TMLCompRegression).AttPred;
 FErrPred:= (AOwner as TMLCompRegression).AttErr;
end;

end.
