(***************************************************************)
(* UCompSpvScoring.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***************************************************************)

{
@abstract(Classe de calcul des scores)
@author(Ricco)
@created(23/04/2005)

Calcule la valeur du score (proba d'affectation) d'un individu relativement  une valeur de la classe.

(1) Prdcesseur : forcment (!) un composant apprentissage supervis
(2) Construit une variable qui correspond au score d'affectation, calcul sur tous les individus et l'ajoute  l'ensemble des donnes
(3) Successeur : n'importe quel composant

On cre une nouvelle catgorie de composants supplmentaire qui est le SCORING.

}

unit UCompSpvScoring;

interface

USES
        Forms, Contnrs, Classes,
        IniFiles,
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation,
        UCompSpvLDefinition;

TYPE
        {gnrateur de composant}
        TMLGenComputeScore = class(TMLGenComp)
                             protected
                             procedure   GenCompInitializations(); override;
                             public
                             function    GetClassMLComponent: TClassMLComponent; override;
                             end;

        {composant -- gnre un nouveau composant  la vole}
        TMLComputeScore = class(TMLCompLocalData)
                          private
                          {attribut reprsentant le score}
                          FAttScore: TAttContinue;
                          protected
                          function    getClassOperator: TClassOperator; override;
                          {gnrer la variable qui matrialisera le score}
                          procedure   InitializeDataset(); override;
                          public
                          property    ScoreAtt: TAttContinue read FAttScore;
                          end;

        {oprateur}
        TOpComputeScore = class(TOpLocalData)
                          private
                          //attribut  scorer
                          FScoredAtt: TAttContinue;
                          //composant meta supervised prcdent -- qui va fournir le score
                          FCompMetaSpv: TMLCompMetaSpvLearning;
                          protected
                          //classe de paramtres assoicie
                          function    getClassParameter: TClassOperatorParameter; override;
                          {lancer le rafrachissement des valeurs de la variable}
                          function    CoreExecute(): boolean; override;
                          public
                          constructor Create(AOwner: TObject); override;
                          {envoyer le rsultat des calculs}
                          function    getHTMLResultsSummary(): string; override;
                          end;

        {paramtrage de l'oprateur}
        TOpPrmComputeScore = class(TOperatorParameter)
                             private
                             {Nom de modalit de la variable  prdire dsigne comme positive}
                             FClassValueName: string;
                             protected
                             procedure   SetDefaultParameters(); override;
                             function    CreateDlgParameters(): TForm; override;
                             public
                             function    getHTMLParameters(): string; override;
                             procedure   LoadFromStream(prmStream: TStream); override;
                             procedure   SaveToStream(prmStream: TStream); override;
                             procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                             procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                             property    ClassValueName: string read FClassValueName write FClassValueName;
                             end;


implementation

USES
   Sysutils, UStringAddBuffered, UDlgOpPrmSpvScoring;

{ TMLGenComputeScore }

procedure TMLGenComputeScore.GenCompInitializations;
begin
  FMLComp:= mlcSpvScoring; 
end;

function TMLGenComputeScore.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLComputeScore; 
end;

{ TMLComputeScore }

function TMLComputeScore.getClassOperator: TClassOperator;
begin
 result:= TOpComputeScore;
end;

procedure TMLComputeScore.InitializeDataset;
begin
 inherited InitializeDataset();
 //gnrer l'ensemble local de donnes
 FAttScore:= TAttContinue.Create('Score_'+IntToStr(self.Number),LocalDataset.Size);
 LocalDataset.Add(FAttScore);
end;

{ TOpComputeScore }

function TOpComputeScore.CoreExecute: boolean;
var example: integer;
    idPositiveClass: TTypeDiscrete;
    classAttribute: TAttDiscrete;
    opMetaSpv: TOpMetaSpvLearning;
begin
 result:= false;
 if (FCompMetaSpv.OutputData.LstAtts[asTarget].Count = 1)
  then
   begin
    classAttribute:= FCompMetaSpv.OutputData.LstAtts[asTarget].Attribute[0] as TAttDiscrete;
    //rcuprer l'id des positifs
    idPositiveClass:= classAttribute.LstValues.isValueAvailable((self.PrmOp as TOpPrmComputeScore).ClassValueName);
    if (idPositiveClass > 0)
     then
      begin
       //scoring de tous les individus, y compris les non-actifs
       TRY
       opMetaSpv:= FCompMetaSpv.Operator as TOpMetaSpvLearning;
       for example:= 1 to FScoredAtt.Size do
        FScoredAtt.cValue[example]:= opMetaSpv.getScoreClassValue(example,idPositiveClass);
       //si tout est OK
       result:= true;
       EXCEPT
       END;
      end;
   end;
end;

constructor TOpComputeScore.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 //brancher l'attribut de scoring
 FScoredAtt:= (AOwner as TMLComputeScore).ScoreAtt;
 //le composant meta supervis, si le cast est mauvais c'est qu'il y a problme -- le prdesseur doit tre un apprentissage supervis
 FCompMetaSpv:= (MLOwner as TMLComponent).Predecessor as TMLCompMetaSpvLearning;
end;

function TOpComputeScore.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmComputeScore;
end;

function TOpComputeScore.getHTMLResultsSummary: string;
begin
 result:= format('Compute score for <b>%s</b>, on <b>%d</b> examples (%d are selected)',[FScoredAtt.Name,FScoredAtt.Size,self.workdata.Examples.Size]);
end;

{ TOpPrmComputeScore }

function TOpPrmComputeScore.CreateDlgParameters: TForm;
begin
 result:= TdlgOpPrmSpvScoring.CreateFromOpPrm(self);
end;

function TOpPrmComputeScore.getHTMLParameters: string;
begin
 result:= '<B>Positive class value : </B>'+FClassValueName;
end;

procedure TOpPrmComputeScore.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FClassValueName:= prmINI.ReadString(prmSection,'positive',FClassValueName);
end;

procedure TOpPrmComputeScore.LoadFromStream(prmStream: TStream);
begin
 loadStringFromStream(FClassValueName,prmStream);
end;

procedure TOpPrmComputeScore.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 prmINI.WriteString(prmSection,'positive',FClassValueName);
end;

procedure TOpPrmComputeScore.SaveToStream(prmStream: TStream);
begin
 saveStringToStream(FClassValueName,prmStream);
end;

procedure TOpPrmComputeScore.SetDefaultParameters;
begin
 FClassValueName:= '';
end;

initialization
 RegisterClass(TMLGenComputeScore);
end.
