(*******************************************************************)
(* UCompSpvScoringLift.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Classe de calcul d'une courbe ROC)
@author(Ricco)
@created(24/04/2005)

Dans la catgorie des SCORING parce que ce composant a besoin de la probabilit
d'affectation pour fonctionner.

Calcule des courbes ROC  partir de 2 types d'informations :

Dans ** DEFINE STATUS **
TARGET : l'attribut de rfrence
INPUT  : les attributs SCORE qui permettent d'effectuer le classement des individus

** Comme paramtre de la mthode **
POSITIVE CLASS VALUE : la modalit de la classe qu'il faut considrer comme "les positifs"

N.B: Il peut y avoir plus variables dans INPUT, on peut ainsi construire simultanment
plusieurs courbes ROC et effectuer des comparaisons.

Par attribut de ciblage (scoring), on conserve 2 types d'infos
(a) la valeur du seuil du score
(b) la valeur de l'ordonne (Taux de vrais positifs dans la cible)
(c) la valeur de l'abcisse (Taux de faux positifs dans la cible)

En filigrane, la taille de la cible est utilise pour dfinir les diffrents
points de rfrence dans la construction de la courbe ROC.

Beaucoup de "copier/coller" par rapport au calcul du LIFT mais construire un mcanisme
d'hritage complexe aurait t trop onreux compte tenu du fait qu'on n'a qu'un seul hritier !

}
unit UCompSpvScoringRoc;

interface

USES
        UCompDefinition,
        UCompManageDataset,
        UOperatorDefinition,
        UDatasetDefinition,
        UDatasetImplementation,
        UCompSpvLDefinition,
        UCompSpvScoring,
        UCompSpvScoringLift,
        UDatasetExamples;

TYPE
   {gnrateur de composant}
   TMLGenSpvScoringROC = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

   {composant}
   TMLSpvScoringROC = class(TMLCompLocalData)
                       protected
                       function    getClassOperator: TClassOperator; override;
                       end;
   {oprateur}
   TOpSpvScoringROC = class(TOpSpvScoringLIFT)
                      protected
                      //nombre total de ngatifs
                      FNbAllNeg: integer;
                      //tableau des faux positifs
                      FTabTFP: TTabStoreScoringValues;
                      //tableau des AUC
                      FTabAUC: array of double;
                      //classe de paramtrage
                      function    getClassParameter: TClassOperatorParameter; override;
                      //tableaux
                      procedure   prepareTabs(); override;
                      //dtruire les tableaux de calculs
                      procedure   destroyTabs(); override;
                      //calculer la courbe pour l'attribut nj
                      procedure   computeCurve(numAtt: integer; examples: TExamples); override;
                      //calculer les positifs et les ngatifs
                      procedure   computePositiveExamples(examples: TExamples); override;
                      public
                      //envoyer le rsultat des calculs
                      function    getHTMLResultsSummary(): string; override;
                      end;

   {paramtrage}
   TOpPrmSpvScoringROC = class(TOpPrmSpvScoringLIFT)
                         end;  


implementation

USES
   Classes, SysUtils, UConstConfiguration;

{ TMLGenSpvScoringROC }

procedure TMLGenSpvScoringROC.GenCompInitializations;
begin
 FMLComp:= mlcSpvScoring;
end;

function TMLGenSpvScoringROC.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLSpvScoringROC;
end;

{ TMLSpvScoringROC }

function TMLSpvScoringROC.getClassOperator: TClassOperator;
begin
 result:= TOpSpvScoringROC;
end;

{ TOpSpvScoringROC }

procedure TOpSpvScoringROC.computeCurve(numAtt: integer; examples: TExamples);
var srtEx: TExamples;
    attScore: TAttribute;
    i,curPos,curNeg: integer;
    borneAdd,nbAdd: integer;//grer la frquence d'ajout dans le graphique
    curLigTab: integer;
    surface: double;
begin
 attScore:= self.WorkData.LstAtts[asInput].Attribute[numAtt];
 //rcuprer les individus et les trier selon la variable de score
 srtEx:= TExamples.Create(examples.Size);
 srtEx.Copy(examples);
 srtEx.QuickSortBy(attScore);//attention le tri est ascendant, il faut prendre dans l'ordre inverse !!!
 //dterminer la premire borne pour les ajouts dans le tableau
 borneAdd:= TRUNC((1.0*srtEx.Size)/(1.0*SCORING_NB_STEPS_TARGET_SIZE));
 //la premire valeur des tableaux
 FTabScore[0,numAtt]:= attScore.cValue[srtEx.Number[srtEx.Size]];
 FTabTVP[0,numAtt]:= 0.0;
 FTabTFP[0,numAtt]:= 0.0;
 //enquiller le reste
 curPos:= 0; curNeg:= 0;
 curLigTab:= 0;
 nbAdd:= 0;
 for i:= srtEx.Size downto 1 do
  begin
   inc(nbAdd);
   //est-ce un positif ?
   if (FClassAttribute.dValue[srtEx.Number[i]] = FIdPositiveClass)
    //oui, c'est la classe que l'on traite comme "positif"
    then inc(curPos)
    //sinon, c'est forcment un ngatif dans notre schma
    else inc(curNeg);
   //mj du tableau ?
   if (nbAdd >= borneAdd)
    then
     begin
      inc(curLigTab);
      //debug.
      //TraceLog.WriteToLogFile(format('[LIFT] add in row %d with thresold %d',[curLigTab,borneAdd]));
      //ajouter les infos
      if (curLigTab < SCORING_NB_STEPS_TARGET_SIZE)
       then
        begin
         FTabScore[curLigTab,numAtt]:= attScore.cValue[srtEx.Number[i]];
         FTabTVP[curLigTab,numAtt]:= (1.0*curPos)/(1.0*FNbAllPos);
         FTabTFP[curLigTab,numAtt]:= (1.0*curNeg)/(1.0*FNbAllNeg);
         //calculer la surface pour AUC
         surface:= 0.5*(FTabTVP[curLigTab,numAtt]+FTabTVP[pred(curLigTab),numAtt])*(FTabTFP[curLigTab,numAtt]-FTabTFP[pred(curLigTab),numAtt]);
         FTabAUC[numAtt]:= FTabAUC[numAtt]+surface;
        end;
      //nouvelle borne d'ajout
      borneAdd:= TRUNC((1.0*succ(curLigTab)*srtEx.Size)/(1.0*SCORING_NB_STEPS_TARGET_SIZE));
     end;
  end;
 //la dernire valeur des tableaux
 FTabScore[SCORING_NB_STEPS_TARGET_SIZE,numAtt]:= attScore.cValue[srtEx.Number[1]];
 FTabTVP[SCORING_NB_STEPS_TARGET_SIZE,numAtt]:= 1.0;
 FTabTFP[SCORING_NB_STEPS_TARGET_SIZE,numAtt]:= 1.0;
 //last surface
 surface:= 0.5*(FTabTVP[SCORING_NB_STEPS_TARGET_SIZE,numAtt]+FTabTVP[pred(SCORING_NB_STEPS_TARGET_SIZE),numAtt])*(FTabTFP[SCORING_NB_STEPS_TARGET_SIZE,numAtt]-FTabTFP[pred(SCORING_NB_STEPS_TARGET_SIZE),numAtt]);
 FTabAUC[numAtt]:= FTabAUC[numAtt]+surface;
 //vider
 srtEx.Free();
end;

procedure TOpSpvScoringROC.computePositiveExamples(examples: TExamples);
begin
 inherited;
 FNbAllNeg:= examples.Size - FNbAllPos;
end;

procedure TOpSpvScoringROC.destroyTabs;
begin
 inherited;
 if (FTabTFP <> nil) then Finalize(FTabTFP);
 if (FTabAUC <> nil) then Finalize(FTabAUC);
end;

function TOpSpvScoringROC.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSpvScoringROC;
end;

function TOpSpvScoringROC.getHTMLResultsSummary: string;
var s: string;
    i,j: integer;
    targetSize: integer;
begin
 s:= '<H3>ROC Curve</H3>';
 //infos sur les effectifs
 s:= s+format('<b>Sample size : </b> %d<br>',[FUsedExamples.Size]);
 s:= s+format('<b>Positive examples : </b> %d<br>',[FNbAllPos]);
 s:= s+format('<b>Negative examples : </b> %d',[FNbAllNeg]);
 //
 s:= s+'<P>'+HTML_HEADER_TABLE_RESULT;
 //en tte du tableau
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Score Attribute</TH>';
 //nom de variables de score
 for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
  s:= s+format('<TH colspan=3>%s</TH>',[self.WorkData.LstAtts[asInput].Attribute[j].Name]);
 s:= s+'</TR>';
 //AUC
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+'<TH>AUC</TH>';
 for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
  s:= s+format('<TH colspan=3>%.4f</TH>',[FTabAUC[j]]);
 s:= s+'</TR>'; 
 //couple score-TP Rate (True Positive Rate)
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+'<TD>Target size (%)</TD>';
 for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
  s:= s+format('<TD width="50" align="center">Score</TD><TD %s width="50" align="center">FP-Rate</TD><TD %s width="50" align="center">TP-Rate</TD>',[HTML_BGCOLOR_DATA_BLUE,HTML_BGCOLOR_DATA_BLUE]);
 s:= s+'</TR>';
 //afficher les valeurs
 for i:= 0 to SCORING_NB_STEPS_TARGET_SIZE do
  begin
   targetSize:= i*(100 div SCORING_NB_STEPS_TARGET_SIZE); 
   //if (targetSize > 1.0) then targetSize:= 1.0;
   s:= s+HTML_TABLE_COLOR_DATA_GREEN+format('<TD align="center">%d</TD>',[targetSize]);
   for j:= 0 to pred(self.WorkData.LstAtts[asInput].Count) do
    s:= s+format('<TD align="center" %s>%.4f</TD><TD align="center">%.4f</TD><TD align="center">%.4f</TD>',[HTML_BGCOLOR_DATA_GRAY,FTabScore[i,j],FTabTFP[i,j],FTabTVP[i,j]]);
   s:= s+'</TR>';
  end;
 s:= s+'</table>';
 //and then...
 result:= s;
end;

procedure TOpSpvScoringROC.prepareTabs;
begin
 inherited;
 setLength(FTabTFP,succ(SCORING_NB_STEPS_TARGET_SIZE),self.WorkData.LstAtts[asInput].Count);
 setLength(FTabAUC,self.WorkData.LstAtts[asInput].Count);
 FillChar(FTabAUC[0],sizeof(double)*self.WorkData.LstAtts[asInput].Count,0);
end;

initialization
 RegisterClass(TMLGenSpvScoringROC);
end.
