unit UDlgOpPrmSpvScoring;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls;

type
  TdlgOpPrmSpvScoring = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    cmbClassValue: TComboBox;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;        
  end;

var
  dlgOpPrmSpvScoring: TdlgOpPrmSpvScoring;

implementation

uses UDatasetDefinition, UDatasetImplementation, UCompSpvScoring,
  UCompManageDataset;

{$R *.dfm}

{ TdlgOpPrmSpvScoring }

procedure TdlgOpPrmSpvScoring.ApplyModifications;
begin
 if (cmbClassValue.ItemIndex >= 0)
  then (self.OpPrm as TOpPrmComputeScore).ClassValueName := cmbClassValue.Items.Strings[cmbClassValue.ItemIndex]
  else (self.OpPrm as TOpPrmComputeScore).ClassValueName := '';
end;

procedure TdlgOpPrmSpvScoring.SetParameters;
var att: TAttDiscrete;
    i: TTypeDiscrete;
    prm: TOpPrmComputeScore;
begin
 prm:= self.OpPrm as TOpPrmComputeScore;
 //lister les valeurs dispos de la target
 self.cmbClassValue.Items.Clear();
 //y a-t-il un target dj ?
 if ((self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].Count=1) and ((self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].isAllCategory(caDiscrete))
  then
   begin
    att:= (self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].Attribute[0] as TAttDiscrete;
    //charger
    for i:= 1 to att.nbValues do
     cmbClassValue.Items.Add(att.LstValues.getDescription(i));
    //activer le bon
    cmbClassValue.ItemIndex:= pred(att.LstValues.isValueAvailable(prm.ClassValueName));
   end;
end;

end.
