(*******************************************************************)
(* UCompMetaSpvBagging.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Composant Bagging)
@author(Ricco)
@created(12/01/2004)
}
unit UCompMetaSpvBagging;

interface

USES
        UCompDefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UCompMetaSpvCommitte;

TYPE
        {gnrateur de composant meta}
        TMLGCompBagging = class(TMLGenComp)
                          protected
                          procedure   GenCompInitializations(); override;
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

        {le composant meta, singe un single learning}
        TMLCompBagging = class(TMLCompMetaSpvLearning)
                         protected
                         function    ShortMLCompName(): string; override;
                         function    getClassOperator: TClassOperator; override;
                         end;

        {oprateur bagging}
        TOpMetaSpvBagging = class(TOpMetaSpvCommitte)
                            protected
                            {simple tirage avec remise}
                            procedure   prepareSample(); override;    
                            end;    

implementation

uses
        Classes,
        UStringsResources;

{ TMLGCompBagging }

procedure TMLGCompBagging.GenCompInitializations;
begin
 FMLComp:= mlcMetaSpvLearning;
 //FMLNumIcon:= 32;
 //FMLCompName:= str_comp_name_meta_spvl_bagging;
 //FMLBitmapFileName:= 'MLMetaSpvBagging.bmp';
end;

function TMLGCompBagging.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompBagging;
end;

{ TMLCompBagging }

function TMLCompBagging.getClassOperator: TClassOperator;
begin
 result:= TOpMetaSpvBagging;
end;

function TMLCompBagging.ShortMLCompName: string;
begin
 result:= 'Bagging';
end;

{ TOpMetaSpvBagging }

procedure TOpMetaSpvBagging.prepareSample;
begin
 self.WorkData.Examples.SampleReplicate(FInternalExamples);
end;

initialization
 RegisterClass(TMLGCompBagging);
end.
