(********************************************************************)
(* UCompMetaSpvBoosting.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Boosting)
@author(Ricco)
@created(12/01/2004)
}
unit UCompMetaSpvBoosting;

interface

USES
        UCompDefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UCompMetaSpvCommitte,
        UDatasetExamples,
        UCompMetaSpvArcing,
        UCalcDistribution,
        UDatasetDefinition,
        UCalcSpvStructScore;

TYPE
        {gnrateur de composant meta}
        TMLGCompBoosting = class(TMLGenComp)
                           protected
                           procedure   GenCompInitializations(); override;
                           public
                           function    GetClassMLComponent: TClassMLComponent; override;
                           end;

        {le composant meta, singe un single learning}
        TMLCompBoosting = class(TMLCompMetaSpvLearning)
                           protected
                           function    ShortMLCompName(): string; override;
                           function    getClassOperator: TClassOperator; override;
                           end;

        {oprateur boosting - driv de arcing, le mode de calcul des poids des individus est modifi, de mme que le classement}
        TOpMetaSpvBoosting = class(TOpMetaSpvArcing)
                             private
                             {poids d'un classifieur}
                             FBeta : array of double;
                             {erreur sur un individu en classement, cela vitera les allocations systmatiques}
                             FErrExample: array of double;
                             protected
                             procedure   prepareCalcData(); override;
                             procedure   destroyCalcData(); override;
                             procedure   destroyClassifiers(); override;
                             {calcul de l'erreur et mj des poids}
                             function    getErrorRate(prmExamples: TExamples): double; override;
                             {calcul du score}
                             procedure   resetScore(example: integer; var postProba: TTabScore); override;
                             end;

implementation

uses
        Math,
        Sysutils, Classes,
        UStringsResources, ULogFile;

CONST
        {valeur  partir de laquelle on considre qu'epsilon est nul}
        LIMIT_EPSILON = 1.0e-10;

{ TMLGCompBoosting }

procedure TMLGCompBoosting.GenCompInitializations;
begin
 FMLComp:= mlcMetaSpvLearning;
 //FMLNumIcon:= 34;
 //FMLCompName:= str_comp_name_meta_spvl_boosting;
 //FMLBitmapFileName:= 'MLMetaSpvBoosting.bmp';
end;

function TMLGCompBoosting.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompBoosting;
end;


{ TMLCompBoosting }

function TMLCompBoosting.getClassOperator: TClassOperator;
begin
 result:= TOpMetaSpvBoosting;
end;

function TMLCompBoosting.ShortMLCompName: string;
begin
 result:= 'Boosting';
end;

{ TOpMetaSpvBoosting }

procedure TOpMetaSpvBoosting.resetScore(example: integer;
  var postProba: TTabScore);
var i: integer;
    kPred: TTypeDiscrete;
begin
 //vider le tableau d'affectation
 postProba.raz();
 //enquiller les diffrentes rponses
 for i:= 0 to pred(Classifiers.Count) do
  begin
   (Classifiers.Items[i] as TCalcSpvLearning).classification(example,kPred);
   if (FBeta[i]>0)
    then postProba[kPred]:= postProba[kPred]+LOG2(1.0/FBeta[i]);
  end;
end;

procedure TOpMetaSpvBoosting.destroyCalcData;
begin
 inherited destroyCalcData();
 setLength(FErrExample,0);
end;

procedure TOpMetaSpvBoosting.destroyClassifiers;
begin
 inherited destroyClassifiers();
 //destruction ici seulement car on en a besoin en classement pour pondrer les classifieurs
 setLength(FBeta,0);
end;

function TOpMetaSpvBoosting.getErrorRate(prmExamples: TExamples): double;
var i: integer;
    example: integer;
    err,OneErr,epsilon: double;
    kActual,kPred: TTypeDiscrete;
    //pDist: TTabFrequence;
    classifier: TCalcSpvLearning;
    numClassifier: integer;
begin
 numClassifier:= pred(Classifiers.Count);
 //dernier classifieur en date
 classifier:= Classifiers.Items[numClassifier] as TCalcSpvLearning;
 //calculer l'erreur et mettre  jour les poids
 err:= 0.0;
 epsilon:= 0.0;
 for i:= 1 to prmExamples.Size do
  begin
   //individu  tester
   example:= prmExamples.Number[i];
   //sa vraie classe
   kActual:= OpMLSpv.ClassAttribute.dValue[example];
   //les classes prdites
   classifier.classification(example,kPred);
   //erreur de prdiction du dernier classifieur induit
   OneErr:= ord(kActual<>kPred);
   //ajouter l'erreur
   err:= err+OneErr;
   {*** ici la modif par rapport  Arcing ***}
   //recenser l'erreur pour l'individu
   FErrExample[i]:= OneErr;
   //calcul de epsilon en utilisant le poids prcdent
   epsilon:= epsilon+FWeights.Weight[i]*OneErr;
  end;
 //taux d'erreur
 err:= err/(1.0*prmExamples.Size);
 //vrifier l'espilon - le 0.5 est inamovible ou dpendant du nombre de classes ?
 //cf. le boosting multi-classes (verser dans des bidouilles style ECOC me parat hasardeux)
 if (epsilon>=0.5)
  then
   begin
    //rinitialiser les poids des individus
    FWeights.Initialize();
    //poids du classifieur annul
    FBeta[numClassifier]:= 0.0;
   end
  else
   begin
    //poids du classifieur
    if (epsilon<LIMIT_EPSILON)
     then FBeta[numClassifier]:= 1.0e-6
     else FBeta[numClassifier]:= epsilon/(1.0-epsilon);
    //nouveaux poids des individus
    For i:= 1 To prmExamples.Size Do
     If (FErrExample[i]=0)
      Then FWeights.Weight[i]:= FWeights.Weight[i]*FBeta[numClassifier];
   end;
 //poids du classifieur
 TraceLog.WriteToLogFile(format('BOOSTING : weight of %dth classifier -> %.4f',[numClassifier,FBeta[numClassifier]]));
 //renvoyer le taux d'erreur
 result:= err;
end;

procedure TOpMetaSpvBoosting.prepareCalcData;
begin
 inherited prepareCalcData();
 //tableau des erreurs sur les individus
 setLength(FErrExample,succ(self.WorkData.Examples.Size));
 //poids des classifieurs
 setLength(FBeta,(self.PrmOp as TOpPrmMetaSpvCommitte).NbInstances);
end;

initialization
 RegisterClass(TMLGCompBoosting);
end.
