(***********************************************************************)
(* UCompMetaSpvOneInstance.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Un apprentissage simple, une seule instance du classifieur est construit)
@author(Ricco)
@created(12/01/2004)
}
unit UCompMetaSpvOneInstance;

interface

USES
        Forms,
        UCompDefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UDatasetDefinition,
        UCalcDistribution,
        UCalcSpvStructScore;

TYPE
        {gnrateur de composant meta}
        TMLGCompOneInstance = class(TMLGenComp)
                              protected
                              procedure   GenCompInitializations(); override;
                              public
                              function    GetClassMLComponent: TClassMLComponent; override;
                              end;

        {le composant meta, singe un single learning}
        TMLCompOneInstance = class(TMLCompMetaSpvLearning)
                             protected
                             function    ShortMLCompName(): string; override;
                             function    getClassOperator: TClassOperator; override;
                             function    GetLogResultDescription(): string; override;
                             end;

        {l'oprateur meta}
        TOpOneInstance = class(TOpMetaSpvLearning)
                         private
                         {un seul classifieur}
                         FClassifier: TCalcSpvLearning;
                         protected
                         function    getNewForm(): TForm; override;
                         function    getClassParameter: TClassOperatorParameter; override;
                         procedure   RunLearning(); override;
                         {il dtruit carrment l'instance de calcul ici}
                         procedure   ReInitialize(); override;
                         //rcuprer les scores d'affectation
                         procedure   resetScore(example: integer; var postProba: TTabScore); override;
                         //classer un exemple
                         procedure   ClassifyExample(example: integer; var response: TTypeDiscrete); override;
                         {dtruire les classifieurs internalement gnrs}
                         procedure   destroyClassifiers(); override;
                         public
                         {reprendre tel quel le rapport gnr par l'oprateur d'apprentissage}
                         function    getHTMLResultsSummary(): string; override;
                         {le classifieur}
                         property    Classifier: TCalcSpvLearning read FClassifier;
                         end;

        {paramtre d'oprateur meta}
        TOpPrmOneInstance = class(TOpPrmMetaSpvLearning)
                            protected
                            {pas de paramtres  spcifier}
                            function    CreateDlgParameters(): TForm; override;
                            public
                            function    getHTMLParameters(): string; override;
                            end;

implementation

uses
        Classes,
        SysUtils, ULogFile, UStringsResources, UFrmOpSingleSpvLearning;

{ TMLGCompOneInstance }

procedure TMLGCompOneInstance.GenCompInitializations;
begin
 FMLComp:= mlcMetaSpvLearning;
 //FMLNumIcon:= 15;
 //FMLCompName:= str_comp_name_meta_spvl_one_instance;
 //FMLBitmapFileName:= 'MLMetaSpvOneInstance.bmp';
end;

function TMLGCompOneInstance.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompOneInstance;
end;

{ TMLCompOneInstance }

function TMLCompOneInstance.getClassOperator: TClassOperator;
begin
 result:= TOpOneInstance;
end;

function TMLCompOneInstance.GetLogResultDescription: string;
begin
 result:= format('one instance of %s is generated',[MLCompSupervised.Description]); 
end;

function TMLCompOneInstance.ShortMLCompName: string;
begin
 result:= 'SpvInstance';
end;

{ TOpOneInstance }

procedure TOpOneInstance.ClassifyExample(example: integer;
  var response: TTypeDiscrete);
begin
 //il n'y a qu'une seule instance, on reprend sa conclusion telle quelle
 FClassifier.classification(example,response);
end;

procedure TOpOneInstance.destroyClassifiers;
begin
 if assigned(FClassifier)
  then FreeAndNil(FClassifier);
end;

function TOpOneInstance.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmOneInstance;
end;

function TOpOneInstance.getHTMLResultsSummary: string;
var s: string;
begin
 s:= inherited getHTMLResultsSummary();
 result:= s+FClassifier.getHTMLResults();
end;

function TOpOneInstance.getNewForm: TForm;
begin
 result:= TFrmOpViewSingleSpvLearning.CreateFromOperator(self);
end;

procedure TOpOneInstance.ReInitialize;
begin
 inherited ReInitialize();
 if assigned(FClassifier)
  then FreeAndNil(FClassifier);
end;

procedure TOpOneInstance.resetScore(example: integer;
  var postProba: TTabScore);
begin
 FClassifier.getScore(example,postProba);
end;

procedure TOpOneInstance.RunLearning;
begin
 if assigned(FClassifier)
  then FClassifier.Free;
 //cration de l'instance
 FClassifier:= OpMLSpv.getInstanceSpvLearning();
 //apprentissage en envoyant les bons exemples
 if not(FClassifier.learning(workdata.Examples))
  then
   begin
    TraceLog.WriteToLogFile(format('collapse creation during %s learning',[FClassifier.ClassName]));
    raise Exception.Create(format('collapse creation during %s learning',[FClassifier.ClassName]));
   end;
end;

{ TOpPrmOneInstance }

function TOpPrmOneInstance.CreateDlgParameters: TForm;
begin
 result:= NIL;
end;

function TOpPrmOneInstance.getHTMLParameters: string;
begin
 result:= (Operator as TOpOneInstance).Classifier.OpPrmSpv.getHTMLParameters();
end;

initialization
 RegisterClass(TMLGCompOneInstance);
end.
