(***********************************************************)
(* UCompSpvCN2.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************)

{
@abstract(dfinition du composant de calcul d'un arbre de dcision - algo ID3)
@author(Ricco)
@created(21/04/2005)

Algorithme CN2 -- DECISION LIST (Article originel de CLARCK et al., 1989)
}

unit UCompSpvCN2;

interface

USES
       Classes, Forms, IniFiles,
       UCompDefinition,
       UCompSpvLDefinition,
       UOperatorDefinition,
       UDatasetImplementation,
       UCalcSpvCN2;

TYPE
       TMLGCompSpvCN2 = class(TMLGenCompSpvLearning)
                        public
                        function    GetClassMLComponent: TClassMLComponent; override;
                        end;

       TMLCompSpvCN2 = class(TMLCompSpvLearning)
                       protected
                       function    getClassOperator: TClassOperator; override;
                       end;

       TOpSpvCN2 = class(TOpSpvLearningDiscrete)
                   protected
                   function    getClassParameter: TClassOperatorParameter; override;
                   function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                   end;

       TOpPrmCN2 = class(TOpPrmSpvLearning)
                   private
                   //mesure
                   FMeasurement: TEnumMeasureCN2;
                   //Risque critique pour l'arrt -- significance level
                   FSignifLevel: double;
                   //Support (premisse) minimum de la rgle
                   FSupportMin: integer;
                   protected
                   function    CreateDlgParameters(): TForm; override;
                   procedure   SetDefaultParameters(); override;
                   public
                   //affichage
                   function    getHTMLParameters(): string; override;
                   //I-O
                   procedure   LoadFromStream(prmStream: TStream); override;
                   procedure   SaveToStream(prmStream: TStream); override;
                   procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                   procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                   //
                   property SignifLevel: double read FSignifLevel write FSignifLevel;
                   property SupportMin: integer read FSupportMin write FSupportMin;
                   property Measurement: TEnumMeasureCN2 read FMeasurement write FMeasurement;
                   end;


implementation

uses
       UConstConfiguration,
       Sysutils, UDlgOpPrmSpvDLCN2;

{ TMLGCompSpvCN2 }

function TMLGCompSpvCN2.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvCN2;
end;

{ TMLCompSpvCN2 }

function TMLCompSpvCN2.getClassOperator: TClassOperator;
begin
 result:= TOpSpvCN2;
end;

{ TOpSpvCN2 }

function TOpSpvCN2.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmCN2;
end;

function TOpSpvCN2.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TCalcSpvCN2;
end;

{ TOpPrmCN2 }

function TOpPrmCN2.CreateDlgParameters: TForm;
begin
 result:= TdlgOprPrmSpvDLCN2.CreateFromOpPrm(self);
end;

function TOpPrmCN2.getHTMLParameters: string;
var s: string;
begin
 s:= '';
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Parameters</TH></TR>';
 //>>
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Rule evaluation measure</TD><TD align="right">%s</TD></TR>',[STR_MEASURE_CN2[FMeasurement]]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Significance level</TD><TD align="right">%.4f</TD></TR>',[FSignifLevel]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Min support of rule</TD><TD align="right">%d</TD></TR>',[FSupportMin]);
 //<<
 s:= s+'</table>';
 //and then...
 result:= s;
end;

procedure TOpPrmCN2.LoadFromINI(prmSection: string; prmINI: TMemIniFile);
begin
 FSignifLevel:= prmINI.ReadFloat(prmSection,'sig_level',FSignifLevel);
 FSupportMin:= prmINI.ReadInteger(prmSection,'support',FSupportMin);
 FMeasurement:= TEnumMeasureCN2(prmINI.ReadInteger(prmSection,'rule_measure',ord(FMeasurement)));
end;

procedure TOpPrmCN2.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FSignifLevel,sizeof(FSignifLevel));
 prmStream.ReadBuffer(FSupportMin,sizeof(FSupportMin));
 prmStream.ReadBuffer(FMeasurement,sizeof(FMeasurement));
end;

procedure TOpPrmCN2.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteFloat(prmSection,'sig_level',FSignifLevel);
 prmINI.WriteInteger(prmSection,'support',FSupportMin);
 prmINI.WriteInteger(prmSection,'rule_measure',ord(FMeasurement));
end;

procedure TOpPrmCN2.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FSignifLevel,sizeof(FSignifLevel));
 prmStream.WriteBuffer(FSupportMin,sizeof(FSupportMin));
 prmStream.WriteBuffer(FMeasurement,sizeof(FMeasurement));
end;

procedure TOpPrmCN2.SetDefaultParameters;
begin
 FSignifLevel:= 0.10;
 FSupportMin:= 10;
 FMeasurement:= mCN2Shannon;
end;

initialization
 RegisterClass(TMLGCompSpvCN2);
end.
