(****************************************************************)
(* UCalcSpvTreeCART.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************)

{
@abstract(Structure arbre de dcision pour CART (Breiman et al., 1984))
@author(Ricco)
@created(12/11/2004)

L'appellation C&RT est adopte pour viter les problmes de copyright.
}
unit UCalcSpvTreeCART;

interface

USES
        Contnrs,
        UCalcTreeStructureDefinition,
        UCalcSpvTreeDefinition,
        UDatasetExamples;

TYPE
        {type de donnes  valuer pour CART}
        TEnumCartDataSet = (cartGrowingSet,cartPruningSet);

        {enregistrements pour vrifier les squences d'arbres}
        TRecTreeSequence = record
                            {numro de sous-arbre}
                            NumTree: integer;
                            {nombre de feuilles}
                            NbLeaves: integer;
                            {Taux d'erreur en pruning}
                            ErrPrune: double;
                            {Taux d'erreur en training}
                            ErrGrow: double;
                           end;

        {tableau des enregistrements de rsultats}
        TTabRecTreeSequence = array of TRecTreeSequence;

        {feuille pour CART}
        TSplitLeafSpvCART = class(TSplitLeafSpv)
                            end;

        {le split d'un attribut en supervis pour CART}
        TSplitAttributSpvCART = class(TSplitAttributSpv)
                                protected
                                function    getClassSplitLeaf(): TClassSplitLeaf; override;
                                {arbre forcment binaire, il faut fusionner}
                                procedure   OptimizeDiscreteLeaves(); override;
                                {indice de GINI}
                                function    ComputeGoodness(): double; override;
                                {tout split est accept}
                                function    ComputeAcceptSplit(): boolean; override;
                                end;

        {une liste d'attributs candidats pour un sommet}
        TLstSplitAttSpvCART = class(TLstSplitAttSpv)
                              protected
                              function  getClassSplitAttribut(): TClassSplitAttribut; override;
                              end;

        {un noeud de l'arbre CART}
        TMLTreeNodeSpvCART = class(TMLTreeNodeSpv)
                             private
                             {comptage des couverts et erreurs en pruning set}
                             FPruningCount,FPruningErr: integer;
                             {numro d'appartenance dans les sous-arbres}
                             FCurNsa: integer;

                             protected

                             function  isNoSplitNeeded(): boolean; override;
                             function  getClassLstSplitAttributes(): TClassLstSplitAttributes; override;
                             public
                             {test si un frre existe}
                             function  nextBrotherExists(): boolean;
                             {obtenir le frre suivant}
                             function  getNextBrother(): TMLTreeNodeSpvCART;
                             {la liste des sous-arbres corresp.  un numro}
                             procedure getSubTree(prmNsa: integer; lst: TObjectList);
                             {cot de mauvais classement}
                             function  localCost(prmSet: TEnumCartDataSet): double;
                             {laguer  partir du sommet courant}
                             procedure pruneFromHere();
                             end;


        {la structure de l'arbre}
        TMLTreeStructureSpvCART = class(TMLTreeStructureSpv)
                                  private
                                  {l'arbre optimal}
                                  FOptimalSubTree: integer;
                                  {la solution slectionne}
                                  FSelectedSubTree: integer;
                                  {squences d'arbres utiliss}
                                  FTabTreeSequence: TTabRecTreeSequence;
                                  {***** recherche des sous-arbres *****}
                                  {liste des squences d'arbres}
                                  FLstSeqTree : TObjectList;
                                  {r-initialisation des numros de squences d'arbres}
                                  procedure  initialiserCurNsa();
                                  {numroter les squences d'arbres}
                                  procedure  numeroterCurNsa(var curNsa: integer);
                                  {marquer les sommets}
                                  function  mark_nodes(prmNsa: integer; prmAlpha: double): boolean;
                                  {calculer l'alpha suivante}
                                  function  computeNextAlpha(prmNsa: integer): double;
                                  {calculer alpha  partir d'un noeud}
                                  function  computeAlphaNode(prmSommet: TMLTreeNodeSpvCART; prmNsa: Integer): Double;
                                  {tester si l'lagage est possible  partir d'un sommet}
                                  function  isPruningPossible(prmNode: TMLTreeNodeSpvCART; prmNsa: Integer; prmAlpha: Double): Boolean;
                                  {marquer un sous-arbre  partir d'un sommet}
                                  procedure mark_subTree(prmNode: TMLTreeNodeSpvCART; prmNsa: integer);
                                  {additionner les cots d'un sous-arbre}
                                  function  computeSubTreeCost(lst: TObjectList; prmSet: TEnumCartDataSet): double;
                                  {calculer le cot en pruning d'un sous-arbre candidat}
                                  function  computePrunedSubTreeCosts(prmNsa: integer; var nbLeaves: integer; var growCost: double): double;
                                  {rechercher le sous-arbre pour un pruning}
                                  procedure explorePrunedSubTreeCosts(node: TMLTreeNodeSpvCART; prmNsa: integer; var costs: double; var nbLeaves: integer; var growCost: double);
                                  {numrer les sous-arbres et leurs cots -- et renvoyer l'arbre optimal}
                                  function enumerateSubTrees(nbTrees: integer): integer;
                                  {laguer effectivement  partir du n de sous-arbre}
                                  procedure pruneSubTree(prmNsa: integer);
                                  {laguer effectivement  partir d'un sommet et du n de sous-arbre}
                                  procedure pruneSubTreeFromNode(prmNode: TMLTreeNodeSpvCART; prmNsa: integer);
                                  {laguer  partir d'un sommet, quel que soit son numro}
                                  procedure pruningFromNode(prmNode: TMLTreeNodeSpvCART); 
                                  {*************************************}
                                  {insrer les individus en pruning}
                                  procedure applyPruningSet(prmExamples: TExamples);
                                  {isrer 1 individu en test}
                                  procedure applyPruningExample(node: TMLTreeNode; example: integer);
                                  protected
                                  FPruningSet: TExamples;
                                  {split into traing set -- pruning set}
                                  procedure  prepareDataset(prmExamples: TExamples); override;
                                  {type du noeud de l'arbre}
                                  function   getClassMLTreeNode(): TClassMLTreeNode; override;
                                  {ajouter le gestionnaire de liste de squences d'arbres}
                                  procedure  prepareInternalStructures(); override;
                                  {dtruire le gestionnaire de gestionnaire de squences d'arbres}
                                  procedure  destroyInternalStructures(); override;
                                  public
                                  destructor destroy(); override;
                                  {post-lagage  la CART}
                                  procedure   PostPruning(); override;
                                  {taille growing}
                                  function getGrowingSetSize(): integer;
                                  {taille pruning}
                                  function getPruningSetSize(): integer;
                                  {description de la squence d'arbres}
                                  property TabTreeSequence: TTabRecTreeSequence read FTabTreeSequence;
                                  {numro de l'arbre slection}
                                  property SelectedSubTree: integer read FSelectedSubTree;
                                  {numro de l'arbre optimal}
                                  property OptimalSubTree: integer read FOptimalSubTree; 
                                  end;

implementation

uses
        Sysutils,
        ULogFile, UCompSpvTreeCART, UCalcStatDes;

const
        {prcision pour test de pruning}
        CART_PRUNING_EPSILON = 0.0001;


{ TSplitAttributSpvCART }

function TSplitAttributSpvCART.ComputeAcceptSplit: boolean;
var ok: boolean;
    i: integer;
begin
 //2 enfants rellement ?
 ok:= (self.Count = 2);
 //tous non-vide
 if ok
  then
   begin
    for i:= 0 to pred(self.Count) do
     ok:= ok and (self.SplitLeaf[i].NbExamples>0);
   end;
 //
 result:= ok;
end;

function TSplitAttributSpvCART.ComputeGoodness: double;
var localNode: TMLTreeNodeSpv;
    total,partial,v: double;
    i: integer;
    leaf: TSplitLeafSpv;
begin
 localNode:= self.Node as TMLTreeNodeSpv;
 total:= localNode.DistClass.GiniIndex();
 partial:= 0.0;
 for i:= 0 to pred(self.Count) do
  begin
   leaf:= self.SplitLeaf[i] as TSplitLeafSpv;
   v:= 1.0*leaf.Dist.TabFreq.Value[0]/(1.0*localNode.DistClass.TabFreq.Value[0]);
   //GINI
   partial:= partial+v*leaf.Dist.GiniIndex();
  end;
 //le gain d'entropie
 //comme la construction de l'arbre n'est pas ordonn, il est inutile de pondrer par le poids du neoud
 //il en serait tout autrement s'il s'agissait d'un graphe... ou de la mthode Catlett limit en splits...
 result:= total-partial;
end;

function TSplitAttributSpvCART.getClassSplitLeaf: TClassSplitLeaf;
begin
 result:= TSplitLeafSpvCART;
end;

procedure TSplitAttributSpvCART.OptimizeDiscreteLeaves;
var i,iMin,j,jMin,k: integer;
    l_i,l_j: TSplitLeafSpvCART;
    dist,minDist: double;
begin
 //-------------------------------
 //-- arbre binaire au final... --
 //-------------------------------

 //la meilleure solution est un CAH local sur les modalits du split-attribut
 //on calcule donc la "distance" pondre entre chaque sommet

  //tant que l'on a plus de 2 enfants
  while (self.Count>2) do
  begin
   //initialisations
   minDist:= 1.0e308;
   iMin:= -1;
   jMin:= -1;
   //calculer les distances deux  deux des sommets
   //bcp d'lments sont calculs plusieurs fois ici mais les conserver puis les rechercher serait plus long encore
   for i:= 0 to self.Count-2 do
    begin
     l_i:= self.SplitLeaf[i] as TSplitLeafSpvCART;
     for j:= succ(i) to self.Count-1 do
      begin
       l_j:= self.SplitLeaf[j] as TSplitLeafSpvCART;
       //calculer la distance entre les deux sommets
       dist:= 0.0;
       //si l'un des deux est vide, on est ok !!!
       //sinon, on cherche donc...
       if (l_i.NbExamples > 0) and (l_j.NbExamples > 0)
        then
         begin
           for k:= 1 to l_i.Dist.TabFreq.Size do
            dist:= dist+SQR(l_i.Dist.TabFreq.Frequence[k]-l_j.Dist.TabFreq.Frequence[k]);//on prend le carr !!!
           dist:= dist*(1.0*l_i.NbExamples*l_j.NbExamples)/(1.0*(l_i.NbExamples+l_j.NbExamples));//pondration par les poids des feuilles
         end;
       //recherche du min
       if (dist<minDist)
        then
         begin
          minDist:= dist;
          iMin:= i;
          jMin:= j;
         end;
      end;
    end;
   //fusionner les sommets ?
   if (iMin<0) and (jMin<0)
    then
     //c'est la CATA !
     begin
      iMin:= 0;
      jMin:= 1;
      TraceLog.WriteToLogFile('//!\ ERREUR -- PBM FUSION FORCEE DANS CART !');
     end;
    //et on fusionne parce qu'il faut arriver au binaire
    l_i:= self.SplitLeaf[iMin] as TSplitLeafSpvCART;
    l_j:= self.SplitLeaf[jMin] as TSplitLeafSpvCART;
    l_i.Merge(l_j);
    //don't forget supprimer cette rf et librer l'objet corresp.!
    self.DeleteLeaf(jMin);
  end;
end;

{ TLstSplitAttSpvCART }

function TLstSplitAttSpvCART.getClassSplitAttribut: TClassSplitAttribut;
begin
 result:= TSplitAttributSpvCART;
end;

{ TMLTreeNodeSpvCART }

function TMLTreeNodeSpvCART.getClassLstSplitAttributes: TClassLstSplitAttributes;
begin
 result:= TLstSplitAttSpvCART;
end;

function TMLTreeNodeSpvCART.getNextBrother: TMLTreeNodeSpvCART;
var p: Integer;
begin
 RESULT:= NIL;
 {$B-}
 if assigned(self.Predecessor) and (self.Predecessor.getCountSuccessors()>0)
  Then
   Begin
    p:= self.Predecessor.getSuccessor(self);
    //il existe, et il reste de la marge pour passer au suivant --> d'o le (-1) !!!
    if (p>=0) and (p<(self.Predecessor.getCountSuccessors()-1))
     then result:= self.Predecessor.getSuccessor(succ(p)) as TMLTreeNodeSpvCART;
   End;
end;

procedure TMLTreeNodeSpvCART.getSubTree(prmNsa: integer; lst: TObjectList);
var fini: Boolean;
    sommet: TMLTreeNodeSpvCART;
begin
 //vider la liste
 lst.Clear();

 //initialiser
 fini:= FALSE;
 sommet:= self;//point de dpart, soi-mme !!!

 //parcourir
 while not(fini) do
  Begin
   //traiter le sommet courant
   if sommet.isLeaf() OR ((sommet.FCurNsa>0) and (sommet.FCurNsa<prmNsa))
    Then
     Begin
      if (sommet<>self)
       Then lst.Add(sommet);
     End;

   //passer au sommet suivant si possible
   if sommet.isLeaf() OR ((sommet.FCurNsa>0) and (sommet.FCurNsa<prmNsa))
    Then
     //passer au frre
     Begin
      //remonte
      while (sommet<>self) and not(sommet.nextBrotherExists()) do
       sommet:= sommet.Predecessor as TMLTreeNodeSpvCART;

      //passage au frre si ce n'est pas la racine
      if (sommet<>self)
       Then sommet:= sommet.getNextBrother()
       Else FINI:= TRUE;//la recherche en arbre est termine
       
     End
    Else
     Begin
      sommet:= sommet.getSuccessor(0) as TMLTreeNodeSpvCART;
     End;
  End;
end;

function TMLTreeNodeSpvCART.isNoSplitNeeded: boolean;
begin
 result:= (self.DistClass.NbExamples<(self.PrmMethod as TOpPrmSpvTreeCART).SizeBeforeSplit);
end;

function TMLTreeNodeSpvCART.localCost(prmSet: TEnumCartDataSet): double;
begin
 result:= 0.0;
 case (prmSet) of
  cartGrowingSet: result:= 1.0*(Self.DistClass.TabFreq.Value[0]-Self.DistClass.TabFreq.Value[self.NodeConclusion]);
  cartPruningSet: begin
                   //que faire lorsque le sommet est vide ???
                   result:= 1.0*self.FPruningErr
                  end;
 end;
end;

function TMLTreeNodeSpvCART.nextBrotherExists: boolean;
var p: Integer;
begin
 RESULT:= FALSE;
 {$B-}
 if assigned(self.Predecessor) and (self.Predecessor.getCountSuccessors()>0)
  Then
   Begin
    p:= self.Predecessor.getSuccessor(self);
    //il existe, et il reste de la marge pour passer au suivant --> d'o le (-1) !!!
    RESULT:= (p>=0) and (p<(self.Predecessor.getCountSuccessors()-1));
   End;
end;

procedure TMLTreeNodeSpvCART.pruneFromHere;
var curNode: TMLTreeNode;
    i: integer;
begin
 if not(self.isLeaf())
  then
   begin
    for i:= 0 to pred(self.getCountSuccessors()) do
     begin
      curNode:= self.getSuccessor(i);
      //en rcursif, se vider de son sous-arbre
      (curNode as TMLTreeNodeSpvCART).pruneFromHere();
      //si on est l c'est que le boulot a t fait
      //la suppression entrane la destruction de l'objet !!!
      self.TreeStructure.deleteNode(curNode);
     end;
    //vider la liste des successeurs -- rien  librer explicitement
    self.clearSuccessors();
   end;
end;

{ TMLTreeStructureSpvCART }

destructor TMLTreeStructureSpvCART.destroy;
begin
 FreeAndNil(FTrainingSet);
 FreeAndNil(FPruningSet);
 inherited;
end;

function TMLTreeStructureSpvCART.getClassMLTreeNode: TClassMLTreeNode;
begin
 result:= TMLTreeNodeSpvCART;
end;

procedure TMLTreeStructureSpvCART.prepareDataset(prmExamples: TExamples);
var proportion: single;
begin
 FTrainingSet:= TExamples.Create(prmExamples.Size);
 FPruningSet:= TExamples.Create(prmExamples.Size);
 //subdiviser : proportion est la taille relative du train ici et "PruningSetSize" est en pourcentage
 proportion:= 1.0-1.0*(self.PrmMethod as TOpPrmSpvTreeCART).PruningSetSize/100.0;
 //TraceLog.WriteToLogFile(format('[CART] proportion TRAIN asked = %.4f',[proportion]));
 prmExamples.SamplingSplitting(proportion,FTrainingSet,FPruningSet,(self.PrmMethod as TOpPrmSpvTreeCART).ModeRndGenerator);
end;

procedure TMLTreeStructureSpvCART.PostPruning;
var nbSubTrees: integer;
begin
 //-- appliquer le pruning-set
 if (self.FPruningSet.Size>0)
  then
   begin
     self.applyPruningSet(self.FPruningSet);
     //-- numroter les squences de sous-arbres --
     self.numeroterCurNsa(nbSubTrees);
     //dtecter celle correspondant  l'optimum
     FSelectedSubTree:= self.EnumerateSubTrees(nbSubTrees);
     //effectuer le post-lagage physique
     if (FSelectedSubTree>0)
      then self.pruneSubTree(FSelectedSubTree);
   end
  else TraceLog.WriteToLogFile('[CART] mode SANS PRUNING asked ???');

end;

procedure TMLTreeStructureSpvCART.destroyInternalStructures;
begin
 inherited;
 FLstSeqTree.Free();
 SetLength(FTabTreeSequence,0);
end;

procedure TMLTreeStructureSpvCART.prepareInternalStructures;
begin
 inherited;
 //liste non propritaire...
 FLstSeqTree:= TObjectList.Create(FALSE);
end;

procedure TMLTreeStructureSpvCART.applyPruningSet(prmExamples: TExamples);
var i,iNode: integer;
begin
 //initaliser tous les cots sur les noeuds
 for iNode:= 0 to pred(self.CountNodes) do
  begin
   (self.Node[iNode] as TMLTreeNodeSpvCART).FPruningCount:= 0;
   (self.Node[iNode] as TMLTreeNodeSpvCART).FPruningErr:= 0;
  end;
 //puis lancer les exemples pour le comptage des erreurs
 for i:= 1 to prmExamples.Size do
  applyPruningExample(self.RootNode,prmExamples.Number[i]);
end;

procedure TMLTreeStructureSpvCART.applyPruningExample(node: TMLTreeNode; example: integer);
var curNode: TMLTreeNodeSpvCART;
    nextNode: TMLTreeNode; 
    i: integer;
begin
 curNode:= node as TMLTreeNodeSpvCART;
 //ajouter l'exemple dans le comptage
 inc(curNode.FPruningCount);
 //dtecter si c'est une erreur
 curNode.FPruningErr:= curNode.FPruningErr+ORD((self as TMLTreeStructureSpvCART).ClassAttribute.dValue[example]<>curNode.NodeConclusion);
 //passer au suivant en dtectant la feuille concerne
 if not(curNode.isLeaf)
  then
   begin
    //chercher le sommet  appeler
    nextNode:= NIL;
    for i:= 0 to pred(curNode.getCountSuccessors()) do
     begin
      if curNode.getSuccessor(i).Condition.TestExample(example)
       then
        begin
         nextNode:= curNode.getSuccessor(i);
         BREAK;
        end;
     end;
    //alors, alors, s'il n'y a rien, on est mal parce que c'est une valeur non-rfrence !!!
    if assigned(nextNode)
     then self.applyPruningExample(nextNode,example)
     else TraceLog.WriteToLogFile(format('[CART] !!!! ERREUR !!!, valeur non rfrence dans PRUNING, example n %d',[example]));
   end;
end;


procedure TMLTreeStructureSpvCART.numeroterCurNsa(var curNsa: integer);
var curAlpha: double;
begin
 //tout remettre  zro
 self.initialiserCurNsa();
 //dfinir la squence
 curNsa:= 1;
 curAlpha:= 0.0;
 if (self.CountNodes=1)
  //un seul sommet : la racine
  then (self.RootNode as TMLTreeNodeSpvCART).FCurNsa:= curNsa
  else
   //chercher les squences
   begin
    while not(self.mark_nodes(curNsa,curAlpha)) do
     begin
      inc(curNsa);
      curAlpha:= computeNextAlpha(curNsa);
     end;
   end;

end;

procedure TMLTreeStructureSpvCART.initialiserCurNsa;
var i: integer;
begin
 self.FLstSeqTree.Clear();
 for i:= 0 to pred(self.CountNodes) do
  (self.Node[i] as TMLTreeNodeSpvCART).FCurNsa:= 0;
end;

function  TMLTreeStructureSpvCART.mark_nodes(prmNsa: integer; prmAlpha: double): boolean;
var the_end: Boolean;
    node: TMLTreeNodeSpvCART;
    okPruning: Boolean;
begin
 RESULT:= FALSE;

 //initialiser
 the_end:= FALSE;
 node:= self.RootNode as TMLTreeNodeSpvCART;

 //la boucle de recherche
 //elle mule une fonction rcursive
 While NOT(the_end) Do
  Begin
   //doit-on traiter le sommet ?
   //c'est le cas si le sommet n'est pas une feuille et qu'elle est non numrote
   if Not(node.isLeaf) and (node.FCurNsa=0)
    Then
     Begin
      //tester si'l est possible d'laguer  partir du sommet courant
      //le test repose sur la recherche des feuilles du sous-arbre
      okPruning:= isPruningPossible(node,prmNsa,prmAlpha);

      //si ok, alors on insre le numro de squence d'arbre sous le sommet, y compris lui mme
      if okPruning
       Then self.mark_subTree(node,prmNsa);

      //si l'on est  la racine et que l'lagage a t accept
      //il n'y a plus rien  faire
      if (node = self.RootNode) and okPruning
       Then
        Begin
         RESULT:= TRUE;
         BREAK;
        End;
      
     End;

   //on passe au sommet suivant

   //tester si c'est une feuille OU si les sommets en dessous sont inintrssants
   if node.isLeaf OR ((node.FCurNsa>0) and (Node.FCurNsa<prmNsa))
    Then
     //on passe au frre
     Begin
      //remonte
      while (node<>self.RootNode) and not(node.nextBrotherExists()) do
       node:= node.Predecessor as TMLTreeNodeSpvCART;

      //passage au frre si l'on n'est pas sur la racine
      if (node<>self.RootNode)
       Then node:= node.getNextBrother()
       Else the_end:= TRUE;
       
     End
    Else
     //on descend sur l'enfant
     Begin
      node:= node.getSuccessor(0) as TMLTreeNodeSpvCART;
     End;
  End;

end;

function TMLTreeStructureSpvCART.computeNextAlpha(prmNsa: integer): double;
var sommet: TMLTreeNodeSpvCART;
    alpha,minAlpha: double;
    i: Integer;    
begin
 minAlpha:= 1.0e308;
 //pour tous les sommets non-marqus
 For i:= 0 To pred(self.CountNodes) do
  Begin
   sommet:= self.Node[i] as TMLTreeNodeSpvCART;
   //le sommet n'a pas encore t explor ?
   //ce ne doit pas tre non plus une feuille
   If (sommet.FCurNsa=0) and NOT(sommet.isLeaf)
    Then
     Begin
      alpha:= computeAlphaNode(sommet,prmNsa);
      If (alpha<minAlpha)
       Then minAlpha:= alpha;
     End;
  End;
 RESULT:= minAlpha;
end;

function TMLTreeStructureSpvCART.computeAlphaNode(
  prmSommet: TMLTreeNodeSpvCART; prmNsa: Integer): Double;
var cSommet,cFeuilles,tmp: Double;
begin
 cSommet:= prmSommet.localCost(cartGrowingSet);
 //rcuprer les feuilles
 prmSommet.getSubTree(prmNsa,self.FLstSeqTree);
 //le cot des feuilles
 cFeuilles:= self.computeSubTreeCost(self.FLstSeqTree,cartGrowingSet);
 //l'opration cabalistique
 tmp:= (cSommet-cFeuilles)/(1.0*self.FLstSeqTree.Count-1.0);
 //renvoyer le tout
 RESULT:= tmp;
end;

function TMLTreeStructureSpvCART.isPruningPossible(
  prmNode: TMLTreeNodeSpvCART; prmNsa: Integer; prmAlpha: Double): Boolean;
var cSommet,cFeuille: Double;
begin
 cSommet:= prmNode.localCost(cartGrowingSet)+prmAlpha;
 //rcuprer les feuilles
 prmNode.getSubTree(prmNsa,self.FLstSeqTree);
 //le cot des feuilles
 cFeuille:= self.computeSubTreeCost(self.FLstSeqTree,cartGrowingSet);
 //ajouter la complexit
 cFeuille:= cFeuille+prmAlpha*self.FLstSeqTree.Count;
 //alors...
 RESULT:= (cSommet<=cFeuille+CART_PRUNING_EPSILON);
end;

procedure TMLTreeStructureSpvCART.mark_subTree(prmNode: TMLTreeNodeSpvCART;
  prmNsa: integer);
Var i: Integer;
begin
 If (prmNode.FCurNsa=0)
  Then
   //le sommet n'a pas t pralablement numrot
   Begin
    prmNode.FCurNsa:= prmNsa;
    If NOT(prmNode.isLeaf())
     Then
      Begin
       //appel rcursif vers les feuilles
       For i:= 0 To pred(prmNode.getCountSuccessors()) Do
        self.mark_subTree(prmNode.getSuccessor(i) as TMLTreeNodeSpvCART,prmNsa);
      End;
   End;
end;

function TMLTreeStructureSpvCART.computeSubTreeCost(
  lst: TObjectList;  prmSet: TEnumCartDataSet): double;
var i: integer;
    cost: double;
begin
 cost:= 0;
 for i:= 0 to pred(lst.Count) do
  cost:= cost+(lst.Items[i] as TMLTreeNodeSpvCART).localCost(prmSet);
 result:= cost;
end;

function TMLTreeStructureSpvCART.computePrunedSubTreeCosts(
  prmNsa: integer; var nbLeaves: integer; var growCost: double): double;
var cost: double;
begin
 //calculer le cout de l'arbre prun de niveau prmNsa
 cost:= 0;
 growCost:= 0.0;
 nbLeaves:= 0;
 self.explorePrunedSubTreeCosts(self.RootNode as TMLTreeNodeSpvCART,prmNsa,cost,nbLeaves,growCost);
 RESULT:= cost;
end;

procedure TMLTreeStructureSpvCART.explorePrunedSubTreeCosts(
  node: TMLTreeNodeSpvCART; prmNsa: integer; var costs: double; var nbLeaves: integer; var growCost: double);
var i: Integer;
begin
 if (node.FCurNsa > prmNsa) and NOT(node.isLeaf())
  Then
   Begin
    For i:= 0 To pred(node.getCountSuccessors) Do
     self.explorePrunedSubTreeCosts(node.getSuccessor(i) as TMLTreeNodeSpvCART,prmNsa,costs,nbLeaves,growCost);
   End
  //ds le premier trouv, on calcule et on arrte les frais
  Else
   begin
    costs:= costs+node.localCost(cartPruningSet);
    growCost:= growCost+node.localCost(cartGrowingSet);
    inc(nbLeaves);
    (*
    //-- affichage de vrification --
    sTmp:= node.DistClass.TabFreq.getStringResult();
    sTmp:= sTmp+format(' -- growErr = %.2f, pruneErr (on %d examples) = %.2f',[node.localCost(cartGrowingSet),node.FPruningCount,node.localCost(cartPruningSet)]);
    TraceLog.WriteToLogFile(sTmp);
    //--
    *)
   end;
end;

function TMLTreeStructureSpvCART.enumerateSubTrees(nbTrees: integer): integer;
var subTree,nbLeaves,optSubTree: integer;
    pruneCost,growCost,minCost,thresold,seMinCost: double;
begin
 SetLength(FTabTreeSequence,nbTrees);
 //lister les squences avec leurs perfs. respectives
 //en profiter pour dtecter l'arbre optimal
 FOptimalSubTree:= -1;
 minCost:= 1.0e308;
 for subTree:= 1 to nbTrees do
  begin
   pruneCost:= self.computePrunedSubTreeCosts(subTree,nbLeaves,growCost);
   pruneCost:= pruneCost/(1.0*self.FPruningSet.Size);
   growCost:= growCost/(1.0*self.FTrainingSet.Size);
   //TraceLog.WriteToLogFile(format('Tree n%4d, leaves = %4d, pruned cost = %8.4f',[subTree,nbLeaves,pruneCost]));
   //affecter les valeurs
   FTabTreeSequence[pred(subTree)].NumTree:= subTree;
   FTabTreeSequence[pred(subTree)].NbLeaves:= nbLeaves;
   FTabTreeSequence[pred(subTree)].ErrPrune:= pruneCost;
   FTabTreeSequence[pred(subTree)].ErrGrow:= growCost;
   //tester
   if (pruneCost<=minCost)
    then
     begin
      minCost:= pruneCost;
      FOptimalSubTree:= subTree;
     end;
  end;
 //ok, on le bon numro
 //TraceLog.WriteToLogFile(format('[CART] min err pruning = %.4f',[minCost]));
 //cart-type de l'erreur min
 seMinCost:= SQRT(minCost*(1.0-minCost)/(1.0*self.FPruningSet.Size));
 //appliquer la xxx-SE RULE pour trouver le bon seuil
 thresold:= minCost+(self.PrmMethod as TOpPrmSpvTreeCART).SERule*seMinCost;
 //rechercher le "bon"  partir des moins complexes vers les plus complexes
 optSubTree:= -1;
 for subTree:= nbTrees downto 1 do
  begin
   if (FTabTreeSequence[pred(subTree)].ErrPrune<=thresold)
    then
     begin
      optSubTree:= subTree;
      BREAK;
     end;
  end;
 //TraceLog.WriteToLogFile(format('[CART] the selected tree is n%2d, with err = %.4f',[optSubTree,FTabTreeSequence[pred(optSubTree)].ErrPrune]));
 //renvoyer la bonne rponse
 result:= optSubTree;
end;

procedure TMLTreeStructureSpvCART.pruneSubTree(prmNsa: integer);
begin
 self.pruneSubTreeFromNode(self.RootNode as TMLTreeNodeSpvCART,prmNsa);
end;

procedure TMLTreeStructureSpvCART.pruneSubTreeFromNode(
  prmNode: TMLTreeNodeSpvCART; prmNsa: integer);
Var i: Integer;
begin
 if (prmNode.FCurNsa > prmNsa)
  Then
   Begin
    if NOT(prmNode.isLeaf())
     Then
      Begin
       For i:= 0 To pred(prmNode.getCountSuccessors()) do
        self.pruneSubTreeFromNode(prmNode.getSuccessor(i) as TMLTreeNodeSpvCART,prmNsa);
      End;
   End
  //et ses enfants sont limins par la mme occasion
  Else self.pruningFromNode(prmNode);
end;

procedure TMLTreeStructureSpvCART.pruningFromNode(
  prmNode: TMLTreeNodeSpvCART);
begin
 if not(prmNode.isLeaf())
  then
   begin
    prmNode.pruneFromHere;
    //et ne pas oublier de s'ajouter dans la liste des feuilles
    self.addLeaveReference(prmNode);
   end;
end;

function TMLTreeStructureSpvCART.getPruningSetSize: integer;
begin
 result:= self.FPruningSet.Size;
end;

function TMLTreeStructureSpvCART.getGrowingSetSize: integer;
begin
 result:= self.FTrainingSet.Size;
end;

end.
