unit UDlgOpPrmSpvTreeCART;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  lmdstdcA, LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel,
  LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit;

type
  TdlgOpprmSpvTreeCART = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    spinMinSizeToSPlit: TLMDSpinEdit;
    spinPruneSize: TLMDSpinEdit;
    Label2: TLabel;
    Label3: TLabel;
    edSERule: TLMDMaskEdit;
    rgRnd: TRadioGroup;
    chkShowSeq: TCheckBox;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;    
  end;

var
  dlgOpprmSpvTreeCART: TdlgOpprmSpvTreeCART;

implementation

uses UCompSpvTreeCART, UCalcRndGenerator;

{$R *.dfm}

{ TdlgOpprmSpvTreeCART }

procedure TdlgOpprmSpvTreeCART.ApplyModifications;
var prm: TOpPrmSpvTreeCART;
begin
 prm:= OpPrm as TOpPrmSpvTreeCART;
 //zoo...
 prm.SizeBeforeSplit:= self.spinMinSizeToSPlit.Value;
 prm.PruningSetSize:= self.spinPruneSize.Value;
 prm.SERule:= StrToFloat(self.edSERule.Text);
 prm.ModeRndGenerator:= TStartSeed(self.rgRnd.ItemIndex);
 prm.ShowAllTreeSeq:= self.chkShowSeq.Checked;
end;

procedure TdlgOpprmSpvTreeCART.SetParameters;
var prm: TOpPrmSpvTreeCART;
begin
 prm:= OpPrm as TOpPrmSpvTreeCART;
 //zoo...
 self.spinMinSizeToSPlit.Value:= prm.SizeBeforeSplit;
 self.spinPruneSize.Value:= prm.PruningSetSize;
 self.edSERule.Text:= FloatToStr(prm.SERule);
 self.rgRnd.ItemIndex:= ord(prm.ModeRndGenerator);
 self.chkShowSeq.Checked:= prm.ShowAllTreeSeq;
end;

end.
