(********************************************************************)
(* UCompSpvMLPerceptron.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Perceptron multi-couches)
@author(Ricco)
@created(12/01/2004)
}
unit UCompSpvMLPerceptron;

interface

USES
        Forms, IniFiles, Classes,
        UCompdefinition,
        UCompSpvLDefinition,
        UOperatorDefinition,
        UCalcSpvMLPStructure,
        UDatasetDefinition,
        UCalcStatDes,
        UDatasetExamples,
        UCalcDistribution,
        UCalcSpvStructScore;

TYPE
        {le gnrateur de composant Supervised MLP}
        TMLGCompSpvMLP = class(TMLGenCompSpvLearning)
                         protected
                         procedure   GenCompInitializations(); override;
                         public
                         function    GetClassMLComponent: TClassMLComponent; override;
                         end;

        {le composant SpvMLP}
        TMLCompSpvMLP = class(TMLCompSpvLearning)
                        protected
                        function    getClassOperator: TClassOperator; override;
                        end;

        {l'oprateur}
        TOpSpvMLP = class(TOpSpvLearningContinuous)
                    protected
                    function    getClassParameter: TClassOperatorParameter; override;
                    function    getClassSpvLearning(): TClassCalcSpvLearning; override;
                    end;

        {paramtres de l'oprateur}
        TOpPrmSpvMLP = class(TOpPrmSpvLearning)
                       private
                       //paramtres de structure du rseau
                       {utiliser une couche cache}
                       FUseHiddenLayer: boolean;
                       {nombre de neurones dans la couche cache}
                       FNbHiddenNeurons: integer;
                       //caractristiques apprentissage
                       {proportion chantillon pour test}
                       FPropTestSample: double;
                       {taux d'apprentissage}
                       FLearningRate: double;
                       {transformation des variables:
                       0 -> none,
                       1 -> centres,
                       2 -> centres-rduites}
                       FAttTransform: integer;
                       //rgles d'arrt
                       {nombre d'itrations max.}
                       FMaxIteration: integer;
                       {taux d'erreur limite sur l'apprentissage}
                       FThresoldErrorRate: double;
                       {utiliser la stagnation du taux d'erreur en test}
                       FUseTestErrStagnation: boolean;
                       {nombre de stagnation  considrer}
                       FNbTestErrStagnation: integer;
                       protected
                       procedure   SetDefaultParameters(); override;
                       function    CreateDlgParameters(): TForm; override;
                       function    getHTMLArchitectureDescription(): string; virtual;
                       public
                       function    getHTMLParameters(): string; override;
                       procedure   LoadFromStream(prmStream: TStream); override;
                       procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                       procedure   SaveToStream(prmStream: TStream); override;
                       procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                       {proprits}
                       property    UseHiddenLayer: boolean read FUseHiddenLayer write FUseHiddenLayer;
                       property    NbHiddenNeurons: integer read FNbHiddenNeurons write FNbHiddenNeurons;
                       property    PropTestSample: double read FPropTestSample write FPropTestSample;
                       property    LearningRate: double read FLearningRate write FLearningRate;
                       property    AttTransform: integer read FAttTransform write FAttTransform;
                       property    MaxIteration: integer read FMaxIteration write FMaxIteration;
                       property    ThresoldErrorRate: double read FThresoldErrorRate write FThresoldErrorRate;
                       property    UseTestErrStagnation: boolean read FUseTestErrStagnation write FUseTestErrStagnation;
                       property    NbTestErrStagnation: integer read FNbTestErrStagnation write FNbTestErrStagnation;
                       end;

        {classe du calculateur de MLP}
        TCalcSpvMLP = class(TCalcSpvLearning)
                      private
                      {paramtre typ - le nombre d'appel au pramtre sera import, autant typer une fois pour toutes}
                      FPrmMLP: TOpPrmSpvMLP;
                      {structure du MLP}
                      FMLP: TPtrNNStructure;
                      {nombre de couches dans le rseau}
                      FNbLayers: integer;
                      {moyennes de centrage}
                      FAvgDescriptors: array of double;
                      {ecart-type de rduction}
                      FStdDevDescriptors: array of double;
                      {individus en apprentissage}
                      FExTrain: TExamples;
                      {individus en test}
                      FExTest: TExamples;
                      {nombre d'itrations courantes}
                      FCurIter: integer;
                      {tableau des erreurs en apprentissage, en test et le mse}
                      FTabErrTrain,FTabErrTest,FTabMse: array of double;
                      {tableau des erreurs si l'on omet un attribut}
                      FTabErrAttribute: array of double;
                      {erreur de rfrence, mesur sur les individus et avec toutes les variables actives}
                      FErrRef,FStdevErrRef: double;
                      {construire le rseau}
                      procedure   BuildNetwork();
                      {dtruire le rseau}
                      procedure   DestroyNetwork();
                      {construire une couche}
                      procedure   BuildLayer(var prmLayer: TPtrNNLayer; prmNbNeurons, prmNbWeight: integer);
                      {construire un neurone}
                      procedure   BuildNeuron(var prmNeuron: TNeuron; prmNbWeight: integer);
                      {initialiser les poids des neurones, pour chaque couche}
                      procedure   InitWeights();
                      {tester si l'un des rgles d'arrt est dclench}
                      function    ActivateStoppingRule(): boolean;
                      {fonction de transfert}
                      function    Sigmoid(prmValue: double): double;
                      {drive de la fonction de transfert}
                      function    derivSigmoid(prmValue: double): double;
                      {mj du rseau sur la base d'un individu}
                      function    ProcessPattern(example: integer): double;
                      {propager les caractristiques d'un individu jusqu'au neurone de sortie}
                      procedure   Propagation();
                      {erreur de prdiction sur un individu, au format MSE}
                      function    MSE(example: integer): double;
                      {rtropropagation du gradient}
                      procedure   BackPropagation();
                      {rcuprer l'erreur de prdiction sur un ensemble d'individus}
                      function    errRateEvaluation(prmExamples: TExamples; prmAttEval : integer): double;
                      {classement d'un individu}
                      function    classificationEvaluation(example: integer; prmAttEval: integer): TTypeDiscrete;
                      protected
                      {statistiques sur les variables}
                      FStatsDescriptors: TLstCalcStatDesContinuous;
                      {nombre de neurones par couche}
                      FNbNeuronsPerLayer: array of integer;
                      {taille de l'entre, cd de la premire couche - ici le nombre de descripteurs}
                      FInputLayerSize: integer;
                      {prsenter un individu au neurone d'entre}
                      procedure   InputPattern(example: integer); virtual;
                      {qqs tests aprs le passage de tous les individus}
                      procedure   afterProcessPatterns(); virtual;
                      {prparation au passage des individu}
                      procedure   beforeProcessPatterns(); virtual;
                      {rendre inoprant un attribut dans l'input pattern - aux fins d'valuation}
                      procedure   SetAttToBlank(example: integer; prmAttEval: integer); virtual;
                      procedure   createStructures(); override;
                      procedure   destroyStructures(); override;
                      function    beforeLearning(examples: TExamples): boolean; override;
                      function    coreLearning(examples: TExamples): boolean; override;
                      function    afterLearning(examples: TExamples): boolean; override;
                      public
                      constructor create(prmOpSpv: TOpPrmSpvLearning; prmClass: TAttribute; prmDescriptors: TLstAttributes; prmAllAttributes: TLstAttributes); override;
                      procedure   getScore(example: integer; var postProba: TTabScore); override;
                      function    getHTMLResults(): string; override;
                      property    PrmMLP: TOpPrmSpvMLP read FPrmMLP;
                      property    MLP: TPtrNNStructure read FMLP;
                      end;

implementation

uses
        Sysutils,
        UStringsResources, ULogFile, UConstConfiguration, UDlgOpPrmSpvMLP,
  UCalcRndGenerator;

CONST
        {la valeur est tellement petite que l'on l'assimiler  zro}
        EPSILON_TO_ZERO = 1.0e-10;

{ TMLGCompSpvMLP }

procedure TMLGCompSpvMLP.GenCompInitializations;
begin
 FMLComp:= mlcSpvLearning;
 //FMLNumIcon:= 29;
 //FMLCompName:= str_comp_name_spvl_mlp;
 //FMLBitmapFileName:= 'MLSpvMLP.bmp';
end;

function TMLGCompSpvMLP.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSpvMLP;
end;

{ TMLCompSpvMLP }

function TMLCompSpvMLP.getClassOperator: TClassOperator;
begin
 result:= TOpSpvMLP;
end;

{ TOpSpvMLP }

function TOpSpvMLP.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSpvMLP;
end;

function TOpSpvMLP.getClassSpvLearning: TClassCalcSpvLearning;
begin
 result:= TCalcSpvMLP;
end;

{ TOpPrmSpvMLP }

function TOpPrmSpvMLP.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmSpvMLP.CreateFromOpPrm(self);
end;

function TOpPrmSpvMLP.getHTMLArchitectureDescription: string;
var s,sTemp: string;
begin
 //architecture du rseau
 s:= HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>MLP architecture</TH></TR>';
 if FUseHiddenLayer
  then sTemp:= 'yes'
  else sTemp:= 'no';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Use hidden layer</TD><TD align=right>%s</TD></TR>',[sTemp]);
 if FUseHiddenLayer
  then s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Neurons in the hidden layer</TD><TD align=right>%d</TD></TR>',[FNbHiddenNeurons]);
 result:= s;
end;

function TOpPrmSpvMLP.getHTMLParameters: string;
var s,sTemp: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+self.getHTMLArchitectureDescription();
 //paramtres d'apprentissage
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Learning parameters</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Test sample proportion</TD><TD align=right>%.2f</TD></TR>',[FPropTestSample]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Learning rate</TD><TD align=right>%.2f</TD></TR>',[FLearningRate]);
 case FAttTransform of
  0: sTemp:= 'none';
  1: sTemp:= 'centered'
  else sTemp:= 'standardized';
 end;
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Attribute transformation</TD><TD align=right>%s</TD></TR>',[sTemp]);
 //rgles d'arrt
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Stopping rule</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Max iteration</TD><TD align=right>%d</TD></TR>',[FMaxIteration]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Error rate thresold</TD><TD align=right>%.4f</TD></TR>',[FThresoldErrorRate]);
 if FUseTestErrStagnation
  then sTemp:= 'yes'
  else sTemp:= 'no';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Verifiy error stagnation</TD><TD align=right>%s</TD></TR>',[sTemp]);
 if FUseTestErrStagnation
  then s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Gap test error</TD><TD align=right>%d</TD></TR>',[FNbTestErrStagnation]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmSpvMLP.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 FUseHiddenLayer:= prmINI.ReadBool(prmSection,'use_hidden_layer',FUseHiddenLayer);
 FNbHiddenNeurons:= prmINI.ReadInteger(prmSection,'nb_hidden_neurons',FNbHiddenNeurons);
 FPropTestSample:= prmINI.ReadFloat(prmSection,'proportion_test_sample',FPropTestSample);
 FLearningRate:= prmINI.ReadFloat(prmSection,'learning_rate',FLearningRate);
 FAttTransform:= prmINI.ReadInteger(prmSection,'att_transformation',FAttTransform);
 FMaxIteration:= prmINI.ReadInteger(prmSection,'max_iteration',FMaxIteration);
 FThresoldErrorRate:= prmINI.ReadFloat(prmSection,'thresold_error_rate',FThresoldErrorRate);
 FUseTestErrStagnation:= prmINI.ReadBool(prmSection,'use_test_err_stagnation',FUseTestErrStagnation);
 FNbTestErrStagnation:= prmINI.ReadInteger(prmSection,'nb_test_err_stagnation',FNbTestErrStagnation);
end;

procedure TOpPrmSpvMLP.LoadFromStream(prmStream: TStream);
begin
 prmStream.ReadBuffer(FUseHiddenLayer,sizeof(FUseHiddenLayer));
 prmStream.ReadBuffer(FNbHiddenNeurons,sizeof(FNbHiddenNeurons));
 prmStream.ReadBuffer(FPropTestSample,sizeof(FPropTestSample));
 prmStream.ReadBuffer(FLearningRate,sizeof(FLearningRate));
 prmStream.ReadBuffer(FAttTransform,sizeof(FAttTransform));
 prmStream.ReadBuffer(FMaxIteration,sizeof(FMaxIteration));
 prmStream.ReadBuffer(FThresoldErrorRate,sizeof(FThresoldErrorRate));
 prmStream.ReadBuffer(FUseTestErrStagnation,sizeof(FUseTestErrStagnation));
 prmStream.ReadBuffer(FNbTestErrStagnation,sizeof(FNbTestErrStagnation));
end;

procedure TOpPrmSpvMLP.SaveToINI(prmSection: string; prmINI: TMemIniFile);
begin
 prmINI.WriteBool(prmSection,'use_hidden_layer',FUseHiddenLayer);
 prmINI.WriteInteger(prmSection,'nb_hidden_neurons',FNbHiddenNeurons);
 prmINI.WriteFloat(prmSection,'proportion_test_sample',FPropTestSample);
 prmINI.WriteFloat(prmSection,'learning_rate',FLearningRate);
 prmINI.WriteInteger(prmSection,'att_transformation',FAttTransform);
 prmINI.WriteInteger(prmSection,'max_iteration',FMaxIteration);
 prmINI.WriteFloat(prmSection,'thresold_error_rate',FThresoldErrorRate);
 prmINI.WriteBool(prmSection,'use_test_err_stagnation',FUseTestErrStagnation);
 prmINI.WriteInteger(prmSection,'nb_test_err_stagnation',FNbTestErrStagnation);
end;

procedure TOpPrmSpvMLP.SaveToStream(prmStream: TStream);
begin
 prmStream.WriteBuffer(FUseHiddenLayer,sizeof(FUseHiddenLayer));
 prmStream.WriteBuffer(FNbHiddenNeurons,sizeof(FNbHiddenNeurons));
 prmStream.WriteBuffer(FPropTestSample,sizeof(FPropTestSample));
 prmStream.WriteBuffer(FLearningRate,sizeof(FLearningRate));
 prmStream.WriteBuffer(FAttTransform,sizeof(FAttTransform));
 prmStream.WriteBuffer(FMaxIteration,sizeof(FMaxIteration));
 prmStream.WriteBuffer(FThresoldErrorRate,sizeof(FThresoldErrorRate));
 prmStream.WriteBuffer(FUseTestErrStagnation,sizeof(FUseTestErrStagnation));
 prmStream.WriteBuffer(FNbTestErrStagnation,sizeof(FNbTestErrStagnation));
end;

procedure TOpPrmSpvMLP.SetDefaultParameters;
begin
 //paramtres de structure du rseau
 {utiliser une couche cache}
 FUseHiddenLayer:= TRUE;
 {nombre de neurones dans la couche cache}
 FNbHiddenNeurons:= 10;
 //caractristiques apprentissage
 {proportion chantillon pour test}
 FPropTestSample:= 0.2;
 {taux d'apprentissage}
 FLearningRate:= 0.15;
 {transformation des variables:
 0 -> none,
 1 -> centres,
 2 -> centres-rduites}
 FAttTransform:= 2;
 //rgles d'arrt
 {nombre d'itrations max.}
 FMaxIteration:= 50;
 {taux d'erreur limite sur l'apprentissage}
 FThresoldErrorRate:= 0.01;
 {utiliser la stagnation du taux d'erreur en test}
 FUseTestErrStagnation:= false;
 {gap nombre de stagnation  considrer}
 FNbTestErrStagnation:= 20;
end;

{ TCalcSpvMLP }

function TCalcSpvMLP.beforeLearning(examples: TExamples): boolean;
var ok: boolean;
    i: integer;
begin
 ok:= inherited BeforeLearning(examples);
 if ok
  then
   begin
    TRY
    //calculer les stats
    FStatsDescriptors.RefreshStat(examples);
    //initialiser les paramtres de centrage rduction
    for i:= 0 to pred(descriptors.Count) do
     begin
      FAvgDescriptors[i]:= 0.0;
      FStdDevDescriptors[i]:= 1.0;
     end;
    //selon les paramtres de l'analyse
    case FPrmMLP.AttTransform of
    //centrage sans rduction
    1 : begin
         for i:= 0 to pred(descriptors.Count) do
          FAvgDescriptors[i]:= TCalcStatDesContinuous(FStatsDescriptors.Stat(i)).Average;
        end;
    //centrage - rduction
    else
        begin
         for i:= 0 to pred(descriptors.Count) do
          begin
           FAvgDescriptors[i]:= TCalcStatDesContinuous(FStatsDescriptors.Stat(i)).Average;
           FStdDevDescriptors[i]:= TCalcStatDesContinuous(FStatsDescriptors.Stat(i)).StdDev;
          end;
        end;
    end;
    //partitionner les individus
    FExTrain:= TExamples.Create(examples.Size);
    FExTest:= TExamples.Create(examples.Size);
    examples.SamplingSplitting(1.0-FPrmMLP.PropTestSample,FExTrain,FExTest);
    //perturber l'ordre d'arrive des individus
    FExTrain.procRandomizeExamples(seedRandom);
    EXCEPT
    ok:= FALSE;
    END;
   end;
 result:= ok;
end;

procedure TCalcSpvMLP.BuildLayer(var prmLayer: TPtrNNLayer; prmNbNeurons, prmNbWeight: integer);
var i: integer;
begin
 prmLayer:= AllocMem(prmNbNeurons*sizeof(TNeuron));
 for i:= 1 to prmNbNeurons do
  self.BuildNeuron(prmLayer^[i],prmNbWeight);
end;

procedure TCalcSpvMLP.BuildNetwork();
var i: integer;
begin
 FMLP:= AllocMem(FNbLayers*sizeof(TPtrNNLayer));
 //la premire couche ne prend rien en entre, d'o le -1 (succ est utilis plus loin)
 BuildLayer(FMLP^[1],FNbNeuronsPerLayer[1],-1);
 //les autres couches
 for i:= 2 to FNbLayers do
  BuildLayer(FMLP^[i],FNbNeuronsPerLayer[i],FNbNeuronsPerLayer[pred(i)]);
end;

procedure TCalcSpvMLP.BuildNeuron(var prmNeuron: TNeuron; prmNbWeight: integer);
begin
 prmNeuron.Weight:= allocMem(succ(prmNbWeight)*SIZE_NEURON_WEIGHT);
 prmNeuron.OutputValue:= 0.0;
 prmNeuron.ErrorValue:= 0.0;
end;

constructor TCalcSpvMLP.create(prmOpSpv: TOpPrmSpvLearning;
  prmClass: TAttribute; prmDescriptors: TLstAttributes; prmAllAttributes: TLstAttributes);
begin
 //paramtre typ
 FPrmMLP:= prmOpSpv as TOpPrmSpvMLP;
 //spcifier la taille de l'input layer
 FInputLayerSize:= prmDescriptors.Count;
 //cration de la structure et autres champs utiles 
 inherited Create(prmOpSpv,prmClass,prmDescriptors,prmAllAttributes);
end;

procedure TCalcSpvMLP.createStructures;
begin
 FNbLayers:= 2;
 if FPrmMLP.UseHiddenLayer then inc(FNbLayers);
 //nombre de neurones par couche
 SetLength(FNbNeuronsPerLayer,succ(FNbLayers));
 FNbNeuronsPerLayer[1]:= FInputLayerSize;
 FNbNeuronsPerLayer[FNbLayers]:= classAttribute.nbValues;
 if FPrmMLP.UseHiddenLayer then FNbNeuronsPerLayer[2]:= FPrmMLP.NbHiddenNeurons;
 //construire le rseau
 self.BuildNetwork();
 //les statistiques descriptives sur l'ensemble des descripteurs
 FStatsDescriptors:= TLstCalcStatDesContinuous.Create(descriptors,NIL);
 //tableaux pour centrage rduction des entres
 setLength(FAvgDescriptors,descriptors.Count);
 setLength(FStdDevDescriptors,descriptors.Count);
 //tableau pour l'volution des erreurs
 setLength(FTabErrTrain,succ(FPrmMLP.MaxIteration));
 setLength(FTabErrTest,succ(FPrmMLP.MaxIteration));
 setLength(FTabMse,succ(FPrmMLP.MaxIteration));
end;

procedure TCalcSpvMLP.destroyStructures;
begin
 if assigned(FMLP)
  then self.DestroyNetwork();
 if assigned(FStatsDescriptors)
  then FStatsDescriptors.Free;
 if assigned(FExTrain)
  then FExTrain.Free;
 if assigned(FExTest)
  then FExTest.Free;
 SetLength(FNbNeuronsPerLayer,0);
 SetLength(FAvgDescriptors,0);
 SetLength(FStdDevDescriptors,0);
 setLength(FTabErrTrain,0);
 setLength(FTabErrTest,0);
 setLength(FTabErrAttribute,0);
 setLength(FTabMse,0);
end;

procedure TCalcSpvMLP.DestroyNetwork;
var i,j: integer;
begin
 //pour chaque couche
 for i:= 1 to FNbLayers do
  begin
   //pour chaque neurone
   for j:= 1 to FNbNeuronsPerLayer[i] do
    begin
     ReAllocMem(FMLP^[i]^[j].Weight,0);//les poids
     //ReAllocMem(FMLP^[i]^[j],0);//le neurone
    end;
   ReAllocMem(FMLP^[i],0);//la couche
  end;
 ReAllocMem(FMLP,0);//la structure complte
end;

function TCalcSpvMLP.coreLearning(examples: TExamples): boolean;
var i: integer;
    ok: boolean;
    errTrain,errTest: double;
    mse: double;
begin
 ok:= TRUE;
 //initialiser les poids
 self.InitWeights();
 //lancer le processus, iterer
 FCurIter:= 0;
 TRY
   //repeter le processus d'apprentissage
   REPEAT
    inc(FCurIter);
    //perturber l'ordre d'arrive des individus
    //FExTrain.procRandomizeExamples();
    //Tracelog.WriteToLogFile(format('TRAIN examples -> %d',[FExTrain.Size]));
    //prparer le passage des individus
    self.BeforeProcessPatterns();
    //faire passer les exemples
    mse:= 0.0;
    for i:= 1 to FExTrain.Size do
     mse:= mse+self.ProcessPattern(FExTrain.Number[i]);
    //qqs tests aprs le passage des individus
    self.afterProcessPatterns();
    //rcuprer les erreurs
    errTrain:= self.errRateEvaluation(FExTrain,-1);
    errTest:= self.errRateEvaluation(FExTest,-1);
    FTabErrTrain[FCurIter]:= errTrain;
    FTabErrTest[FCurIter]:= errTest;
    FTabMse[FCurIter]:= mse;
    //envoi dans fichier log
    //TraceLog.WriteToLogFile(format('iteration n%d :: train err (%.4f) -- test err (%.4f) -- mse (%.6f)',[FCurIter,errTrain,errTest,mse]));
   UNTIL (ActivateStoppingRule());
 EXCEPT
 ok:= FALSE;
 END;
 result:= ok;
end;

procedure TCalcSpvMLP.InitWeights;
var i,j,k: integer;
begin
 for i:= 2 to FNbLayers do
  for j:= 1 to FNbNeuronsPerLayer[i] do
   for k:= 0 to FNbNeuronsPerLayer[pred(i)] do
    FMLP^[i]^[j].Weight^[k]:= 0.001*Self.RndGenSpv.RanMar();
end;

function TCalcSpvMLP.ActivateStoppingRule: boolean;
var stop: boolean;
    predIter: integer;
begin
 //nb d'itartions ?
 stop:= (FCurIter>=FPrmMLP.MaxIteration);
 //erreur limite sur l'apprentissage ?
 //si stop est dj  true, la deuxime condition n'est mme pas teste
 {$B-}
 stop:= stop OR (FTabErrTrain[FCurIter]<=FPrmMLP.ThresoldErrorRate);
 //stagnation de l'erreur en test ?
 if not(stop) and (FPrmMLP.UseTestErrStagnation) and (FCurIter>FPrmMLP.NbTestErrStagnation)
  then
   begin
    //chercher le numro de l'itartion xx pas en arrire
    predIter:= FCurIter-FPrmMLP.NbTestErrStagnation;
    stop:= (FTabErrTest[FCurIter]>=FTabErrTest[predIter]);
   end;
 result:= stop;
end;

function TCalcSpvMLP.derivSigmoid(prmValue: double): double;
begin
 result:= prmValue*(1.0-prmValue);
end;

function TCalcSpvMLP.Sigmoid(prmValue: double): double;
begin
 if (abs(prmValue)<EPSILON_TO_ZERO)
  Then Result:= 0.5
  Else Result:= 1.0/(1.0+exp(-prmValue));
end;

function TCalcSpvMLP.ProcessPattern(example: integer): double;
var err: double;
begin
 InputPattern(example);
 Propagation();
 err:= MSE(example);
 BackPropagation();
 result:= err;
end;

procedure TCalcSpvMLP.InputPattern(example: integer);
var j: integer;
    v: double;
begin
 for j:= 0 to pred(descriptors.Count) do
  begin
   v:= descriptors.Attribute[j].cValue[example];
   FMLP^[1]^[succ(j)].OutputValue:= (v-FAvgDescriptors[j])/FStdDevDescriptors[j];
  end;
end;

procedure TCalcSpvMLP.Propagation;
var i,j,k: integer;
    inputL,curL: TPtrNNLayer;
    value: double;
begin
 //layer ni
 for i:= 2 to FNbLayers do
  begin
   inputL:= FMLP^[pred(i)];
   curL:= FMLP^[i];
   //for each neuron of the current layer
   for j:= 1 to FNbNeuronsPerLayer[i] do
    begin
     value:= curL^[j].Weight^[0];//bias
     //combinaison linaire
     for k:= 1 to FNbNeuronsPerLayer[pred(i)] do
      value:= value+curL^[j].Weight^[k]*inputL^[k].OutputValue;
     //transfom with the sigmod function
     curL^[j].OutputValue:= self.Sigmoid(value);
    end;
  end;
end;

function TCalcSpvMLP.MSE(example: integer): double;
var layer: TPtrNNLayer;
    errOut,err: double;
    k,classValue: TTypeDiscrete;
begin
 //couche de sortie
 layer:= FMLP^[FNbLayers];
 //tester la sortie
 errOut:= 0.0;
 classValue:= ClassAttribute.dValue[example];
 for k:= 1 to classAttribute.NbValues do
  begin
   if (k = classValue)
    then err:= 1.0-layer^[k].OutputValue
    else err:= 0.0-layer^[k].OutputValue;
   layer^[k].ErrorValue:= err*self.derivSigmoid(layer^[k].OutputValue);
   errOut:= errOut+err*err;
  end;
 result:= 0.5*errOut;
end;

procedure TCalcSpvMLP.BackPropagation;
var curL,predL: TPtrNNLayer;
    i,j,k: integer;
    err: double;
begin
 //on part de la fin vers le dbut, sauf la premire couche qui ne contient pas de poids
 for i:= FNbLayers downto 2 do
  begin
   curL:= FMLP^[i];
   predL:= FMLP^[pred(i)];
   //weight correction
   for j:= 1 to FNbNeuronsPerLayer[i] do
    begin
     for k:= 1 to FNbNeuronsPerLayer[pred(i)] do
      curL^[j].Weight^[k]:= curL^[j].Weight^[k]+FPrmMLP.LearningRate*curL^[j].ErrorValue*predL^[k].OutputValue;
     //bias
     curL^[j].Weight^[0]:= curL^[j].Weight^[0]+FPrmMLP.LearningRate*curL^[j].ErrorValue*1.0;
    end;
   //err correction
   for j:= 1 to FNbNeuronsPerLayer[pred(i)] do
    begin
     err:= 0.0;
     for k:= 1 to FNbNeuronsPerLayer[i] do
      err:= err+curL^[k].ErrorValue*curL^[k].Weight^[j];
     predL^[j].ErrorValue:= err*self.derivSigmoid(predL^[j].OutputValue);
    end;
  end;
end;

procedure TCalcSpvMLP.getScore(example: integer; var postProba: TTabScore);
var Value: double;
    i: TTypeDiscrete;
begin
 self.InputPattern(example);
 self.Propagation();
 //rcuprer la distribution
 for i:= 1 to ClassAttribute.nbValues do
  begin
   value:= FMLP^[FNbLayers]^[i].OutputValue;
   postProba[i]:= value;
  end;
end;

function TCalcSpvMLP.getHTMLResults: string;
var s: string;
    i,item: integer;
begin
 //caractristiques de l'apprentissage
 s:= '<H3>Learning characteristics</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Iterations</TD><TD align=right colspan=2>%d</TD></TR>',[FCurIter]);
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Last train error rate</TD><TD align=right colspan=2>%.4f</TD></TR>',[FTabErrTrain[FCurIter]]);
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Last test error rate</TD><TD align=right colspan=2>%.4f</TD></TR>',[FTabErrTest[FCurIter]]);
 s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>Last train mse</TD><TD align=right colspan=2>%.4f</TD></TR>',[FTabMse[FCurIter]]);
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=4>Learning evolution</TH></TR>';
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TD>N iteration</TD><TD>Train err</TD><TD>Test err</TD><TD>MSE</TD></TR>';
 for i:= 1 to 20 do
  begin
   item:= (FCurIter div 20)*pred(i)+1;
   s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>%d</TD><TD>%.4f</TD><TD>%.4f</TD><TD>%.4f</TD></TR>',[item,FTabErrTrain[item],FTabErrTest[item],FTabMse[item]]);
  end;
 s:= s+'</table>';
 //contribution des variables dans la prcision
 s:= s+'<H3>Attribute contribution</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Exluded attribute</TH><TH>Error rate</TH><TH>Difference</TH><TH>Statistics</TH></TR>';
 s:= s+HTML_TABLE_COLOR_DATA_GREEN+format('<TD>none</TD><TD align=right>%.4f</TD><TD align=center>-</TD><TD>-</TD></TR>',[FErrRef]);
 for i:= 0 to pred(descriptors.Count) do
  s:= s+HTML_TABLE_COLOR_DATA_BLUE+format('<TD>%s</TD><TD align=right>%.4f</TD><TD align=right>%.4f</TD><TD align=right>%.4f</TD></TR>',
                                          [descriptors.Attribute[i].Name,FTabErrAttribute[i],FTabErrAttribute[i]-FErrRef,(FTabErrAttribute[i]-FErrRef)/FStdevErrRef]);
 s:= s+'</table>';
 //poids sur les noeuds, on doit envoyer aussi les paramtres de transformation, mieux vaut un fichier  gnrer ?
 result:= s;
end;

function TCalcSpvMLP.classificationEvaluation(example,
  prmAttEval: integer): TTypeDiscrete;
var maxValue,Value: double;
    iMax,i: TTypeDiscrete;
begin
 self.InputPattern(example);
 //modifier la variable  tester
 if (prmAttEval>-1)
  then self.SetAttToBlank(example,prmAttEval);
 //suite logique
 self.Propagation();
 //which is the output neuron most activated ?
 iMax:= 0;
 maxValue:= -1.0e308;
 for i:= 1 to ClassAttribute.nbValues do
  begin
   value:= FMLP^[FNbLayers]^[i].OutputValue;
   if (value>maxValue)
    then
     begin
      maxValue:= value;
      iMax:= i;
     end;
  end;
 result:= iMax;
end;

function TCalcSpvMLP.errRateEvaluation(prmExamples: TExamples;
  prmAttEval: integer): double;
var i: integer;
    err: double;
    response: TTypeDiscrete;
begin
 err:= 0.0;
 for i:= 1 to prmExamples.Size do
  begin
   response:= self.classificationEvaluation(prmExamples.Number[i],prmAttEval);
   if (response <> ClassAttribute.dValue[prmExamples.Number[i]])
    then err:= err + 1.0;
  end;
 result:= err/(1.0*prmExamples.Size);
end;

function TCalcSpvMLP.afterLearning(examples: TExamples): boolean;
var curErr: double;
    j: integer;
begin
 result:= true;
 TRY
 //erreur lorsque toutes les variables sont actives
 FErrRef:= self.errRateEvaluation(examples,-1);
 FStdevErrRef:= FErrRef*(1.0-FErrRef)/(1.0*examples.Size);
 if (FStdevErrRef>0)
  then FStdevErrRef:= sqrt(FStdevErrRef)
  else FStdevErrRef:= 1.0;
 //initialiser le tableau
 setLength(FTabErrAttribute,descriptors.Count);
 //remplir
 for j:= 0 to pred(descriptors.Count) do
  begin
   curErr:= self.errRateEvaluation(examples,j);
   FTabErrAttribute[j]:= curErr;
  end;
 EXCEPT
 result:= false;
 END;
end;

procedure TCalcSpvMLP.SetAttToBlank(example: integer; prmAttEval: integer);
begin
 if (prmAttEval>-1)
  then FMLP^[1]^[succ(prmAttEval)].OutputValue:= (TCalcStatDesContinuous(FStatsDescriptors.Stat(prmAttEval)).Average-FAvgDescriptors[prmAttEval])/FStdDevDescriptors[prmAttEval];
end;

procedure TCalcSpvMLP.afterProcessPatterns;
begin
 //nothing ici
end;

procedure TCalcSpvMLP.beforeProcessPatterns;
begin
 //nothing
end;

initialization
 RegisterClass(TMLGCompSpvMLP);
end.

