(***********************************************************************)
(* UCalcSpvMLROptimization.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Rgression logistique multinomiale -- Classe d'optimisation)
@author(Ricco)
@created(18/04/2005)

/!\\ 18/04/2005 -- Trop compliqu et pas trs stable pour l'instant --> on passe par la procdure d'optimisation de Marquardt (cf. ATHANOR)


Traduction directe de Optimization.java de WEKA (3-4-4)

>> Xin Xu -- Revision : 1.6

}

unit UCalcSpvMLROptimization;

interface

USES
       d6_matrices, d6_fmath;

TYPE

 //type de function pour l'valuation de la fonction et du gradient
 TTypeFuncObjective = function (x: TVector): float;
 TTypeFuncGradient  = function (x: TVector): TVector;

 //tableau d'entiers
 TDynamicIntArray = class
 private
 //** The int array. -- private int[] m_Objects;
 m_Objects: array of integer;
 //** The current size; -- private int m_Size = 0;
 m_Size: integer;
 //** The capacity increment -- private int m_CapacityIncrement = 1;
 m_CapacityIncrement: integer;
 //** The capacity multiplier. -- private int m_CapacityMultiplier = 2;
 m_CapacityMultiplier: integer;
 //private boolean equal(DynamicIntArray b)
 function   equal(b: TDynamicIntArray): boolean;
 public
 //public DynamicIntArray(int capacity)
 constructor create(capacity: integer);
 destructor  destroy(); override;
 //public final void addElement(int element)
 procedure   addElement(element: integer);
 //public final Object copy()
 function    copy(): TDynamicIntArray;
 //public final int elementAt(int index)
 function    elementAt(index: integer): integer;
 //public final void removeAllElements()
 procedure   removeAllElements();
 //public final void removeElementAt(int index)
 procedure   removeElementAt(index: integer);
 //public final int size()
 function    size(): integer;
 end;

 //classe de calcul -- optimisation BFGS
 TOptimization = class
 private
 //fonction objectif
 FFuncObjective: TTypeFuncObjective;
 //fonction gradient
 FFuncGradient: TTypeFuncGradient;
 // G'*p -- private double m_Slope;
 m_Slope: double;
 // Test if zero step in lnsrch -- private boolean m_IsZeroStep = false;
 m_IsZeroStep: boolean;
 // Used when iteration overflow occurs -- private double[] m_X;
 m_X: TVector;
 //m_Espilon et m_Zero calculs une fois pour toutes
 m_Epsilon, m_Zero: double;
 //calculer la prcision
 procedure  computePrecision();
 //fixer les valeurs d'initialisation
 procedure  initValues();
 protected
 //protected double m_ALF = 1.0e-4;
 m_ALF: double;
 //protected double m_BETA = 0.9;
 m_BETA: double;
 //protected double m_TOLX = 1.0e-6;
 m_TOLX: double;
 //protected double m_STPMX = 100.0;
 m_STPMX: double;
 //protected int m_MAXITS = 200;
 m_MAXITS: integer;
 //protected static boolean m_Debug = false;
 m_Debug: boolean;
 // function value -- protected double m_f;
 m_f: double;
 //protected abstract double[] evaluateGradient(double[] x)
 function evaluateGradient(x: TVector): TVector;
 // protected double[] evaluateHessian(double[] x, int index)
 function evaluateHessian(x: TVector; index: integer): TVector;
 //protected abstract double objectiveFunction(double[] x) throws Exception;
 function objectiveFunction(x: TVector): float;
 //protected void updateCholeskyFactor(Matrix L, double[] D, double[] v, double coeff, boolean[] isFixed)
 procedure updateCholeskyFactor(L: TMatrix; D: TVector; v: TVector; coeff: double; isFixed: array of boolean);
 public
 constructor create(prmObjective: TTypeFuncObjective; prmGradient: TTypeFuncGradient);
 //public double[] lnsrch(double[] xold, double[] gradient, double[] direct, double stpmax, boolean[] isFixed, double[][] nwsBounds, DynamicIntArray wsBdsIndx)
 function lnsrch(xold,gradient,direct: TVector; stpmax: double; isFixed: array of boolean; nwsBounds: TMatrix; wsBdsIndx: TDynamicIntArray): TVector;
 //public double[] findArgmin(double[] initX, double[][] constraints)
 function findArgMin(initX: TVector; constraints: TMatrix): TVector;
 //public static double[] solveTriangle(Matrix t, double[] b, boolean isLower, boolean[] isZero)
 function solveTriangle(t: TMatrix; b: TVector; isLower: boolean; isZero: array of Boolean): TVector;
 end;

implementation

USES
   MATH, Classes, Sysutils;


//quick-sort tab.
procedure  quickSort(var T: array of integer; inf,sup: integer);
TYPE ATrier = integer;

  PROCEDURE Swap(VAR S1,S2:ATrier);
  VAR Tmp:ATrier;
  BEGIN
  Tmp:=S1;
  S1:=S2;
  S2:=Tmp
  END;

var i,j: integer;
begin
IF Inf>=Sup THEN
ELSE BEGIN
     i:=Inf+1;
     j:=Sup;
     WHILE NOT (i>=j) DO //i=j pour le cas o Sup=Inf+1
       BEGIN
       WHILE NOT ((T[i]>T[Inf]) OR (i=j)) DO INC(i);//on cherche le 1er lment > T[Inf]  partir de la gauche
       WHILE NOT ((T[j]<T[Inf]) OR (j=i-1)) DO DEC(j);//on cherche le 1er lment < T[Inf]  partir de la droite
       IF i<j THEN Swap(T[i],T[j]);//on les intervertit. Cette instruction pourrait tre place sans test juste aprs le WHILE
       END;
     IF T[j]<T[Inf] THEN Swap(T[Inf],T[j]);//on a donc ts les T<T[Inf]  gauche et les autres  droite
     quickSort(T,Inf,j-1);//reste  trier la partie gauche
     quickSort(T,j+1,Sup)//et la partie droite
     END;

end;


{ TDynamicIntArray }

procedure TDynamicIntArray.addElement(element: integer);
begin

 if (m_Size = Length(m_Objects))
 then
      begin
       //le redimensionnement ne provoque pas la perte des donnes en DELPHI
       setLength(m_Objects,m_CapacityMultiplier * (length(m_Objects) + m_CapacityIncrement));
      end;

 m_Objects[m_Size] := element;
 inc(m_Size);


end;

function TDynamicIntArray.copy: TDynamicIntArray;
var copy: TDynamicIntArray;
begin
 copy:= TDynamicIntArray.create(length(self.m_Objects));
 copy.m_Size:= self.m_Size;
 copy.m_CapacityIncrement:= self.m_CapacityIncrement;
 copy.m_CapacityMultiplier:= self.m_CapacityMultiplier;
 SYSTEM.Move(self.m_Objects[0],copy.m_Objects[0],sizeof(integer)*length(self.m_Objects));

 result:= copy;

end;

constructor TDynamicIntArray.create(capacity: integer);
begin
 inherited Create();
 setLength(m_Objects,capacity);
 //qqs initialisations
 m_Size:= 0;
 m_CapacityIncrement:= 1;
 m_CapacityMultiplier:= 2;
end;

destructor TDynamicIntArray.destroy;
begin
 m_Objects:= NIL;
 inherited;
end;



function TDynamicIntArray.elementAt(index: integer): integer;
begin
 result:= self.m_Objects[index];
end;


function TDynamicIntArray.equal(b: TDynamicIntArray): boolean;
var j: integer;
    sorta,sortb: array of integer;
begin
 if ((b = nil) OR (b.size() <> self.size()))
  then
   begin
    result:= FALSE;
    EXIT;
   end;

 // Only values matter, order does not matter
 setLength(sorta,Length(self.m_Objects));
 SYSTEM.MOVE(self.m_Objects[0],sorta[0],sizeof(integer)*length(self.m_Objects));
 quickSort(sorta,low(sorta),high(sorta));

 setLength(sortb,Length(b.m_Objects));
 SYSTEM.MOVE(b.m_Objects[0],sortb[0],sizeof(integer)*length(b.m_Objects));
 quickSort(sortb,low(sortb),high(sortb));

 for j:= 0 to pred(size) do
  begin
   if (self.m_Objects[sorta[j]] <> b.m_Objects[sortb[j]])
    then
     begin
      result:= FALSE;
      //ouah... c'est brutal...
      EXIT;
     end;
  end;

 result:= TRUE;

end;

procedure TDynamicIntArray.removeAllElements;
begin
 FillChar(self.m_Objects[0],sizeof(integer)*length(self.m_Objects),0);
 m_Size:= 0;
end;

procedure TDynamicIntArray.removeElementAt(index: integer);
begin
 SYSTEM.Move(self.m_Objects[index],self.m_Objects[succ(index)],sizeof(integer)*(m_Size-index-1));
 dec(m_Size);

     {

      System.arraycopy(m_Objects, index + 1, m_Objects, index,
		       m_Size - index - 1);
      m_Size--;
    }

end;

function TDynamicIntArray.size: integer;
begin
 result:= m_Size;
end;

{ TOptimization }

procedure TOptimization.computePrecision;
begin
 m_Epsilon:= 1.0;
 while (1.0+m_Epsilon > 1.0) do
  m_Epsilon:= m_Epsilon/2.0;

 m_Epsilon:= m_Epsilon*2.0;
 m_Zero:= SQRT(m_Epsilon);

end;

constructor TOptimization.create(prmObjective: TTypeFuncObjective;
  prmGradient: TTypeFuncGradient);
begin
 inherited Create();
 FFuncObjective:= prmObjective;
 FFuncGradient:= prmGradient;
 self.InitValues();
 self.computePrecision();
end;

function TOptimization.evaluateGradient(x: TVector): TVector;
begin
 if assigned(FFuncGradient)
  then result:= FFuncGradient(x)
  else result:= NIL;
end;

function TOptimization.evaluateHessian(x: TVector;  index: integer): TVector;
begin
 result:= NIL;
end;

{*** proc prives pour findArgMin ***}

procedure setMatColToZero(mat: TMatrix; idx,size: integer);
var k: integer;
begin
 for k:= 0 to pred(size) do
  mat[k,idx]:= 0.0;
end;

procedure setMatRowToZero(mat: TMatrix; idx,size: integer);
var k: integer;
begin
 for k:= 0 to pred(size) do
  mat[idx,k]:= 0.0;
end;

{************************************}

function TOptimization.findArgMin(initX: TVector;
  constraints: TMatrix): TVector;

//mon dieu, mon dieu, le GOTO existe aussi en Java, on aura tout vu !!!
label
   iterates;

var
   l: integer;
   isFixed: Array of Boolean;
   nwsBounds: TMatrix;

   wsBdsIndx: TDynamicIntArray;
   toFree,oldToFree: TDynamicIntArray;

   sum: double;
   grad,oldGrad, oldX, deltaGrad, deltaX, direct, x: TVector;

   gL: TMatrix;
   D: TVector;

   i: integer;

   stpmax: double;

   step: integer;

   f,idx: integer;
   finish: boolean;
   test: double;
   h: integer;
   tmp: double;

	denom,dxSq,dgSq,newlyBounded: double;
   g: integer;

   size: integer;
   isUpdate: boolean;

   m: integer;
   index: integer;

   hessian: TVector;
   deltaL: double;

   mm: integer;
   L1,L2: double;

   isConverge: boolean;

   mmm,freeIndx: integer;

   coeff: double;
   
   LD: TMatrix;
   b: TVector;

   k,j: integer;

   LDIR: TVector;


begin
	l := length(initX);

	// Initially all variables are free, all bounds are constraints of
	// non-working-set constraints
	setLength(isFixed,l);
   setLength(nwsBounds,2,l);

	// Record indice of fixed variables, simply for efficiency
	//DynamicIntArray wsBdsIndx = new DynamicIntArray(constraints.length);
   //>> gros doute quand mme sur le length !!! le tableau est  2 dimensions
   wsBdsIndx:= TDynamicIntArray.create(length(constraints));

	// Vectors used to record the variable indices to be freed
	//DynamicIntArray toFree=null, oldToFree=null;
   toFree:= nil; oldToFree:= nil;	

	// Initial value of obj. function, gradient and inverse of the Hessian
	//m_f = objectiveFunction(initX);
   m_f:= self.objectiveFunction(initX);

   if Math.IsNan(m_f)
    then Exception.Create('Objective function value is NaN!');


	sum :=0;
   grad:= self.evaluateGradient(initX);
   setLength(deltaGrad,l);
   setLength(deltaX,l);
   setlength(direct,l);
   setLength(x,l);



	//Matrix L = new Matrix(l, l);  // Lower triangle of Cholesky factor
   //double[] D = new double[l];   // Diagonal of Cholesky factor
   setLength(gL,l,l);
   setLength(D,l);


	//for(int i=0; i<l; i++)
   for i:= 0 to pred(l) do
	begin
	    //L.setRow(i, new double[l]);
	    //L.setElement(i,i,1.0);
       gL[i,i]:= 1.0;

	    D[i] := 1.0;
	    direct[i] := -grad[i];
	    //sum += grad[i]*grad[i];
       sum:= sum+grad[i]*grad[i];
	    x[i] := initX[i];

	    nwsBounds[0][i] := constraints[0][i];
	    nwsBounds[1][i] := constraints[1][i];
	    isFixed[i] := false;
	end;
	
	stpmax := m_STPMX*Math.max(sqrt(sum), l);
	
	iterates:
	//for(int step=0; step < m_MAXITS; step++)
   //for step:= 0 to pred(m_MAXITS) do
   step:= 0;
   while (step<m_MAXITS) do
	begin
	    //if (m_Debug)
		//System.err.println("\nIteration # " + step + ":");	    
	    
	    // Try at most one feasible newton step, i.e. 0<lamda<=alpha
	    oldX := x;
	    oldGrad := grad;

	    // Also update grad
	    //if (m_Debug)
		//System.err.println("Line search ... ");

	    m_IsZeroStep := false;
	    x:= lnsrch(x, grad, direct, stpmax, isFixed, nwsBounds, wsBdsIndx);

	    //if (m_Debug)
		//System.err.println("Line search finished.");

	    if(m_IsZeroStep)
	    then
        begin // Zero step, simply delete rows/cols of D and L
		  //for(int f=0; f<wsBdsIndx.size(); f++)
         for f:= 0 to pred(wsBdsIndx.size) do
		  begin
		    idx :=wsBdsIndx.elementAt(f);
           //L.setRow(idx, new double[l]);
		    //L.setColumn(idx, new double[l]);

           setMatRowToZero(gL,idx,l);
           setMatColToZero(gL,idx,l);
		    D[idx] := 0.0;
		  end;

		 grad := evaluateGradient(x);

		 //step--;
        dec(step);
	     end
	    else
	     begin
		  // Check converge on x
		  finish := false;
		  test:= 0.0;
		  //for(int h=0; h<l; h++)
         for h:= 0 to pred(l) do
		  begin
		    deltaX[h] := x[h]-oldX[h];
		    tmp:= abs(deltaX[h])/Math.max(abs(x[h]), 1.0);
		    if (tmp > test) then test := tmp;
         end;

		  if(test < m_Zero)
		  then
         begin
		    //if (m_Debug)
			//System.err.println("\nDeltaX converge: "+test);
		    finish := true;
		  end;

		  // Check zero gradient
		  grad := evaluateGradient(x);
		  test := 0.0;

		  denom:= 0.0;
         dxSq := 0.0;
         dgSq := 0.0;
         newlyBounded:= 0.0;

		  //for(int g=0; g<l; g++)
         for g:= 0 to pred(l) do
		  begin
		    if not(isFixed[g])
		    then
           begin
			 deltaGrad[g] := grad[g] - oldGrad[g];
			 // Calculate the denominators
			 denom:= denom + deltaX[g]*deltaGrad[g];
			 dxSq := dxSq  + deltaX[g]*deltaX[g];
			 dgSq := dgSq  + deltaGrad[g]*deltaGrad[g];
		    end
		    else // Only newly bounded variables will be non-zero
			newlyBounded := newlyBounded + deltaX[g]*(grad[g]-oldGrad[g]);

		    // Note: CANNOT use projected gradient for testing
		    // convergence because of newly bounded variables
		    tmp := abs(grad[g])*Math.max(abs(direct[g]),1.0)/Math.max(abs(m_f),1.0);
		    if(tmp > test) then test := tmp;
		  end;

		  if(test < m_Zero)
		  then
         begin
		    //if (m_Debug)
			//System.err.println("Gradient converge: "+test);
		    finish := true;
		  end;

         // dg'*dx could be < 0 using inexact lnsrch
         //if(m_Debug)
             //System.err.println("dg'*dx="+(denom+newlyBounded));

         // dg'*dx = 0
         if(abs(denom+newlyBounded) < m_Zero)
             then finish := true;

         size := wsBdsIndx.size();
         isUpdate := true;  // Whether to update BFGS formula

         // Converge: check whether release any current constraints
         if (finish)
         then
         begin
             //if (m_Debug)
             //System.err.println("Test any release possible ...");

             if (toFree <> nil)
             then oldToFree := toFree.copy();

             if assigned(toFree) then toFree.Free();
             toFree := TDynamicIntArray.create(wsBdsIndx.size());

             //for(int m=size-1; m>=0; m--)
             for m:= pred(size) downto 0 do
             begin
              index:= wsBdsIndx.elementAt(m);

              hessian := evaluateHessian(x, index);

              deltaL:= 0.0;
              if(hessian <> nil)
              then
              begin
                 //for(int mm=0; mm<hessian.length; mm++)
                 for mm:= 0 to pred(length(hessian)) do
                  if not(isFixed[mm]) // Free variable
                     then deltaL:= deltaL  + hessian[mm]*direct[mm];
              end;

               // First and second order Lagrangian multiplier estimate
               // If user didn't provide Hessian, use first-order only
               //double L1, L2;

               if(x[index] >= constraints[1][index]) // Upper bound
               then L1 := -grad[index]
               else
                if(x[index] <= constraints[0][index])// Lower bound
                 then L1 := grad[index]
                 else Exception.Create('x["+index+"] not fixed on the bounds where it should have been!');
                 //  throw new Exception("x["+index+"] not fixed on the"+
                 //          " bounds where it should have been!");

               // L2 = L1 + deltaL
               L2 := L1 + deltaL;

               //if (m_Debug)
               //    System.err.println("Variable "+index+
               //               ": Lagrangian="+L1+"|"+L2);

               //Check validity of Lagrangian multiplier estimate
               isConverge := (2.0*abs(deltaL)) < Math.min(abs(L1),abs(L2));

               if((L1*L2>0.0) and isConverge)
               then
               //Same sign and converge: valid
               begin
                   if(L2 < 0.0)
                   // Negative Lagrangian: feasible
                   then
                   begin
                   toFree.addElement(index);
                   wsBdsIndx.removeElementAt(m);
                   finish:= false; // Not optimal, cannot finish
                   end;
               end;

               // Although hardly happen, better check it
               // If the first-order Lagrangian multiplier estimate is wrong,
               // avoid zigzagging
               if((hessian = nil) and (toFree <> nil) and toFree.equal(oldToFree))
                then finish := true;

             end;//du for m...
		    
             if(finish)
             // Min. found
             then
             begin
              //if (m_Debug)
              //   System.err.println("Minimum found.");
              m_f := objectiveFunction(x);

              if(Math.isNaN(m_f)) then Exception.Create('Objective function value is NaN!');
              //   throw new Exception("Objective function value is NaN!");

              //return x;
              result:= x;
              EXIT;
             end;
		    
             // Free some variables
             //for(int mmm=0; mmm<toFree.size(); mmm++)
             for mmm:= 0 to pred(toFree.size()) do
             begin
                 freeIndx:= toFree.elementAt(mmm);

                 isFixed[freeIndx] := false; // Free this variable
                 if(x[freeIndx] <= constraints[0][freeIndx])
                 // Lower bound
                 then
                 begin
                  nwsBounds[0][freeIndx] := constraints[0][freeIndx];
                  //if (m_Debug)
                  //System.err.println("Free variable "+freeIndx+" from bound "+nwsBounds[0][freeIndx]);
                 end
                 else
                 // Upper bound
                 begin
                  nwsBounds[1][freeIndx] := constraints[1][freeIndx];
                  //if (m_Debug)
                  //System.err.println("Free variable "+freeIndx+" from bound "+nwsBounds[1][freeIndx]);
                 end;			
             //L.setElement(freeIndx, freeIndx, 1.0);
             gL[freeIndx,freeIndx]:= 1.0;

             D[freeIndx] := 1.0;
             isUpdate := false;			
             end;
         end;//if (finish)...
		
         if(denom<Math.max(m_Zero*sqrt(dxSq)*sqrt(dgSq), m_Zero))
         then
         begin
             //if (m_Debug)
             //System.err.println("dg'*dx negative!");
             isUpdate := false; // Do not update
         end;

         // If Hessian will be positive definite, update it
         if(isUpdate)
             then
             begin

             // modify once: dg*dg'/(dg'*dx)
             coeff := 1.0/denom; // 1/(dg'*dx)
             updateCholeskyFactor(gL,D,deltaGrad,coeff,isFixed);

             // modify twice: g*g'/(g'*p)
             coeff := 1.0/m_Slope; // 1/(g'*p)
             updateCholeskyFactor(gL,D,oldGrad,coeff,isFixed);
             end;
        end;//cf. else et converge on x

         // Find new direction 
         //Matrix LD = new Matrix(l,l); // L*D
         setLength(LD,l,l);
         //double[] b = new double[l];
         setLength(b,l);

         //for(int k=0; k<l; k++)
         for k:= 0 to pred(l) do
         begin
             if not(isFixed[k])
             then b[k] := -grad[k]
             else b[k] := 0.0;

             //for(int j=k; j<l; j++)
             for j:= k to pred(l) do
             // Lower triangle
             begin
                 if (not(isFixed[j]) and not(isFixed[k]))
                  then LD[j, k]:=  gL[j,k]*D[k];
             end;
         end;
	    
         // Solve (LD)*y = -g, where y=L'*direct
         LDIR := solveTriangle(LD, b, true, isFixed);
         LD := nil;


	    
         //for(int m=0; m<LDIR.length; m++)
         for m:= 0 to pred(length(LDIR)) do
         begin
         if (Math.isNaN(LDIR[m]))
             then Exception.Create('L*direct["+m+"] is NaN!"+"|-g="+b[m]+"|"+isFixed[m]+"|diag="+D[m]');
         end;
	    
         // Solve L'*direct = y
         direct := solveTriangle(gL, LDIR, false, isFixed);
         //for(int m=0; m<direct.length; m++)
         for m:= 0 to pred(length(direct)) do
         begin
          if(Math.isNaN(direct[m]))
           then Exception.Create('direct is NaN!');
         end;

         //System.gc();
     //}//du for step...
     
     //passage  la prochaine valeur de step (puisqu'on est pass sur un while et non plus un for...)
     inc(step);
     end;
	
     //if(m_Debug)
     //    System.err.println("Cannot find minimum"+
     //               " -- too many interations!");

     m_X := x;
     result:= nil;
end;

procedure TOptimization.initValues;
begin
 m_IsZeroStep:= false;
 //protected double m_ALF = 1.0e-4;
 m_ALF:= 1.0e-4;
 //protected double m_BETA = 0.9;
 m_BETA:= 0.9;
 //protected double m_TOLX = 1.0e-6;
 m_TOLX:= 1.0e-6;
 //protected double m_STPMX = 100.0;
 m_STPMX:= 100.0;
 //protected int m_MAXITS = 200;
 m_MAXITS:= 200;
 //protected static boolean m_Debug = false;
 m_Debug:= false;;
end;

function TOptimization.lnsrch(xold, gradient, direct: TVector;
  stpmax: double; isFixed: array of boolean; nwsBounds: TMatrix;
  wsBdsIndx: TDynamicIntArray): TVector;

label
    kloop;

var i,j,k,len,fixedOne: integer;
    alam,alamin: double;
    temp,test,alpha,fold,sum: double;
    a,alam2,b,disc,maxalam,rhs1,rhs2,tmplam: double;
    x: TVector;

    alpi: double;

	 initF,hi, lo, newSlope, fhi, flo: double;// Variables used for beta condition
    newGrad: TVector;

    upper: double;

    numerator: double;

    ldiff, lincr: double;

begin

	len:= length(xold);
	fixedOne:= -1; // idx of variable to be fixed

	//double alam, alamin; // lambda to be found, and its lower bound

	// For convergence and bound test
	//double temp,test,alpha=Double.POSITIVE_INFINITY,fold=m_f,sum;
   alpha:= Math.Infinity;
   fold:= m_f;

	// For cubic interpolation
	//double a,alam2=0,b,disc=0,maxalam=1.0,rhs1,rhs2,tmplam;
   alam2:= 0;
   disc:= 0;
   maxalam:= 1.0;

	//double[] x = new double[len]; // New variable values
   setLength(x,len);
	
	// Scale the step
   sum:= 0.0;
	//for (sum=0.0,i=0;i<len;i++)
   for i:= 0 to pred(len) do
	begin
	    if not(isFixed[i]) // For fixed variables, direction = 0
		 then sum:= sum + direct[i]*direct[i];
	end;
	sum := sqrt(sum);
	
	//if (m_Debug)
	//    System.err.println("fold:  "+Utils.doubleToString(fold,10,7)+"\n"+
	//		       "sum:  "+Utils.doubleToString(sum,10,7)+"\n"+
	//  	       "stpmax:  "+Utils.doubleToString(stpmax,10,7));
   
	if (sum > stpmax)
	then
   begin
	    for i:=0 to pred(len) do
			if not(isFixed[i])
		    	then direct[i]:= direct[i] * stpmax/sum;
	end
	else
	 maxalam := stpmax/sum;
	
	// Compute initial rate of decrease, g'*d 
	m_Slope:=0.0;

	for i:=0 to pred(len) do
	begin
	    x[i] := xold[i];
	    if not(isFixed[i])
		then m_Slope:= m_slope + gradient[i]*direct[i];
	end;
	
	//if (m_Debug)
	//    System.err.print("slope:  " + Utils.doubleToString(m_Slope,10,7)+ "\n");
	
	// Slope too small
	if(abs(m_Slope)<=m_Zero)
	then
   begin
	    //if (m_Debug)
		//System.err.println("Gradient and direction orthogonal -- "+
		//		   "Min. found with current fixed variables"+
		//		   " (or all variables fixed). Try to release"+
		//		   " some variables now.");

	    //return x;
       result:= x;
       exit;
	end;
	
	// Err: slope > 0
	if(m_Slope > m_Zero)
	then
   begin
       (*
	    if(m_Debug)
		for(int h=0; h<x.length; h++)
		    System.err.println(h+": isFixed="+isFixed[h]+", x="+
				       x[h]+", grad="+gradient[h]+", direct="+
				       direct[h]);
       *)
	    Exception.Create('g*p positive! -- Try to debug from here: line 327. --> 869');
	end;
	
	// Compute LAMBDAmin and upper bound of lambda--alpha
	test:= 0.0;
	for i:=0  to pred(len) do
	begin
	    if not(isFixed[i])
	    // No need for fixed variables
       then
       begin
			temp:= abs(direct[i])/Math.max(abs(x[i]),1.0);
			if (temp > test) then test:=temp;
	    end;
	end;

	if(test>m_Zero) // Not converge
	    then alamin := m_TOLX/test
	else
	begin
       (*
	    if (m_Debug)
		System.err.println("Zero directions for all free variables -- "+
				   "Min. found with current fixed variables"+
				   " (or all variables fixed). Try to release"+
				   " some variables now.");
       *)

	    //return x;
       result:= x;
       exit;
	end;
		
	// Check whether any non-working-set bounds are "binding"
	for i:=0 to pred(len) do
	begin
	    if not(isFixed[i])
	    // No need for fixed variables
       then
       begin
			//double alpi;

			if (direct[i]<-m_Epsilon) and not(Math.isNaN(nwsBounds[0][i]))
			//Not feasible
           then
           begin
		    	alpi := (nwsBounds[0][i]-xold[i])/direct[i];
		    	if(alpi <= m_Zero)
		    	// Zero
               then
               begin
               (*
				if (m_Debug)
			    	System.err.println("Fix variable "+i+
					       " to lower bound "+ nwsBounds[0][i]+
					       " from value "+ xold[i]);
               *)
				x[i] := nwsBounds[0][i];
				isFixed[i] :=true; // Fix this variable
				alpha := 0.0;
				nwsBounds[0][i]:= Math.NaN; //Add cons. to working set
				wsBdsIndx.addElement(i);
		    	end
		    	else
		    		if(alpha > alpi)
		    		// Fix one variable in one iteration
                   then
                   begin
						alpha := alpi;
						fixedOne := i;
		    		end;
			end
			else
				if((direct[i]>m_Epsilon) and not(Math.isNaN(nwsBounds[1][i])))
				//Not feasible
               then
               begin
		    		alpi := (nwsBounds[1][i]-xold[i])/direct[i];
		    		if(alpi <= m_Zero)
		    		// Zero
                   then
                   begin
                       (*
						if (m_Debug)
			    		System.err.println("Fix variable "+i+
					       " to upper bound "+ nwsBounds[1][i]+
					       " from value "+ xold[i]);
                       *)
						x[i] := nwsBounds[1][i];
						isFixed[i]:= true; // Fix this variable
						alpha := 0.0;
						nwsBounds[1][i]:= Math.NaN; //Add cons. to working set

						wsBdsIndx.addElement(i);
		    		end
		    		else
		    			if(alpha > alpi)
		    			then
                       begin
						 alpha := alpi;
						 fixedOne := i;
		    			end;
				end;
	    end;
	end;//du for i

   (*
	if (m_Debug)
	{
	    System.err.println("alamin: " + Utils.doubleToString(alamin,10,7));
	    System.err.println("alpha: " + Utils.doubleToString(alpha,10,7));
	}
   *)

	if(alpha <= m_Zero)
	 // Zero
   then
   begin
	    m_IsZeroStep := true;
	    //if (m_Debug)
		//System.err.println("Alpha too small, try again");

	    //return x;
       result:= x;
       exit;
	end;
	
	alam := alpha; // Always try full feasible newton step 
	if(alam > 1.0)
	   then alam := 1.0;
	
	// Iteration of one newton step, if necessary, backtracking is done
	//double initF=fold, // Initial function value
	//    hi=alam, lo=alam, newSlope=0, fhi=m_f, flo=m_f;// Variables used for beta condition
   initF:= fold;
   hi:= alam;
   lo:= alam;
   newSlope:= 0;
   fhi:= m_f;
   flo:= m_f;


	//double[] newGrad;  // Gradient on the new variable values
	
	kloop:
	//for (k=0;;k++)
   k:= 0;
   while TRUE do
	begin
           //if(m_Debug)
           //System.err.println("\nLine search iteration: " + k);

           for i:=0 to pred(len) do
           begin
               if not(isFixed[i])
               then
               begin
                   x[i] := xold[i]+alam*direct[i];  // Compute xnew

                   if not(Math.isNaN(nwsBounds[0][i])) and (x[i]<nwsBounds[0][i])
                   then
                   begin
                       x[i] := nwsBounds[0][i]; //Rounding error
                   end
                   else
                   begin
                       if not(Math.isNaN(nwsBounds[1][i])) and (x[i]>nwsBounds[1][i])
                       then
                       begin
                           x[i] := nwsBounds[1][i]; //Rounding error
                       end;
                   end;
               end;
           end;

	    	m_f := objectiveFunction(x);    // Compute fnew
	    	if (Math.isNaN(m_f))
			 then Exception.create('Objective function value is NaN!');

	    	while(Math.isInfinite(m_f)) do
	    	begin
               // Avoid infinity
				//if(m_Debug)
		    	//System.err.println("Too large m_f.  Shrink step by half.");

				alam:= alam * 0.5; // Shrink by half
				if(alam <= m_Epsilon)
				then
               begin
		    		//if(m_Debug)
					//System.err.println("Wrong starting points, change them!");

		    		//return x;
                   result:= x;
                   exit;
				end;

				for i:=0 to pred(len) do
		    		if not(isFixed[i])
						then x[i] := xold[i]+alam*direct[i];

				m_f := objectiveFunction(x);

				if (Math.isNaN(m_f))
		    		then Exception.create('Objective function value is NaN!');

				initF := Math.Infinity;
	    	end;//du while

           (*
	    	if(m_Debug)
	    	{
				System.err.println("obj. function: " + Utils.doubleToString(m_f, 10, 7));
				System.err.println("threshold: " +  Utils.doubleToString(fold+m_ALF*alam*m_Slope,10,7));
	    	}
           *)

	    	if (m_f<=fold+m_ALF*alam*m_Slope)
	    	// Alpha condition: sufficient function decrease
           then
           begin
				//if(m_Debug)
		    	//	System.err.println("Sufficient function decrease (alpha condition): ");

				newGrad := evaluateGradient(x);

               newSlope:= 0.0;
				for i:=0 to pred(len) do
		    		if not(isFixed[i])
						then newSlope:= newSlope + newGrad[i]*direct[i];

				if(newSlope >= m_BETA*m_Slope)
               // Beta condition: ensure pos. defnty.
               then
               begin
		    		//if(m_Debug)
					//	System.err.println("Increasing derivatives (beta condition): ");

		    		if ((fixedOne <>-1) and (alam>=alpha))
		    		then
                   begin // Has bounds and over
						if(direct[fixedOne] > 0)
						then
                       begin
			    			x[fixedOne] := nwsBounds[1][fixedOne]; // Avoid rounding error
			    			nwsBounds[1][fixedOne]:= Math.NaN; //Add cons. to working set
						end
						else
						begin
			    			x[fixedOne] := nwsBounds[0][fixedOne]; // Avoid rounding error
			    			nwsBounds[0][fixedOne]:=Math.NaN; //Add cons. to working set
						end;

						//if(m_Debug)
			    		//System.err.println("Fix variable "+fixedOne+" to bound "+ x[fixedOne]+" from value "+ xold[fixedOne]);

						isFixed[fixedOne]:=true; // Fix the variable
						wsBdsIndx.addElement(fixedOne);
		    		end;

		    		//return x;
                   result:= x;
                   exit;
				end
				else
				if(k=0)
               then
               begin
				 	// First time: increase alam
		    		// Search for the smallest value not complying with alpha condition
		    		upper := Math.min(alpha,maxalam);

		    		//if(m_Debug)
					//System.err.println("Alpha condition holds, increase alpha... ");

		    		while (not((alam>=upper) OR (m_f>fold+m_ALF*alam*m_Slope))) do
		    		begin
						lo := alam;
						flo := m_f;
						alam := alam * 2.0;

						if (alam>=upper)  // Avoid rounding errors
			    		   then	alam:=upper;

						for i:=0 to pred(len) do
			    			if not(isFixed[i])
								then x[i] := xold[i]+alam*direct[i];

						m_f := objectiveFunction(x);
						if(Math.isNaN(m_f))
			    			then Exception.Create('Objective function value is NaN!');

						newGrad := evaluateGradient(x);

                       newSlope:= 0.0;
						for i:=0 to pred(len) do
			    			if not(isFixed[i])
								then newSlope:= newSlope + newGrad[i]*direct[i];

						if(newSlope >= m_BETA*m_Slope)
						then
                       begin
			    			//if (m_Debug)
							//System.err.println("Increasing derivatives (beta condition): \n"+
						    //"newSlope = "+Utils.doubleToString(newSlope,10,7));

			    			if ((fixedOne <>-1) and (alam>=alpha))
			    			// Has bounds and over
                           then
                           begin
								if(direct[fixedOne] > 0)
								then
                               begin
				    				x[fixedOne] := nwsBounds[1][fixedOne]; // Avoid rounding error
				    				nwsBounds[1][fixedOne]:=Math.NaN; //Add cons. to working set
								end
								else
								begin
				    				x[fixedOne] := nwsBounds[0][fixedOne]; // Avoid rounding error
				    				nwsBounds[0][fixedOne]:= Math.NaN; //Add cons. to working set
								end;

                               (*
								if(m_Debug)
				    			System.err.println("Fix variable "
						       	+fixedOne+" to bound "+ x[fixedOne]+
						       	" from value "+ xold[fixedOne]);
                               *)

								isFixed[fixedOne]:= true; // Fix the variable
								wsBdsIndx.addElement(fixedOne);
			    			end;

			    			//return x;
                           result:= x;
                           EXIT;
						end;

		    		end;//du while

		    		hi := alam;
		    		fhi := m_f;

		    		//break kloop;
                   GOTO kloop;
				end//de if (k == 0)
			else
			begin
		    	//if(m_Debug)
				//	System.err.println("Alpha condition holds.");

		    	hi := alam2; lo := alam; flo := m_f;

		    	//break kloop;
               GOTO kloop;
			end;
	    end//de alpha condition
	    else
	    if (alam < alamin)
       then
       begin
	    // No feasible lambda found
			if(initF<fold)
			then
           begin
		    	alam := Math.min(1.0,alpha);
		    	for i:=0 to pred(len) do
					if not(isFixed[i])
			    		then x[i] := xold[i]+alam*direct[i]; //Still take Alpha

		    	//if (m_Debug)
				//System.err.println("No feasible lambda: still take"+" alpha="+alam);

		    	if((fixedOne <>-1) and (alam>=alpha))
		    	// Has bounds and over
               then
               begin
					if(direct[fixedOne] > 0)
					then
                   begin
			    		x[fixedOne] := nwsBounds[1][fixedOne]; // Avoid rounding error
			    		nwsBounds[1][fixedOne] := Math.NaN; //Add cons. to working set
					end
					else
					begin
			    		x[fixedOne] := nwsBounds[0][fixedOne]; // Avoid rounding error
			    		nwsBounds[0][fixedOne] := Math.NaN; //Add cons. to working set
					end;

					//if(m_Debug)
			    	//System.err.println("Fix variable "+fixedOne+" to bound "+ x[fixedOne]+" from value "+ xold[fixedOne]);

					isFixed[fixedOne]:= true; // Fix the variable
					wsBdsIndx.addElement(fixedOne);
		    	end;
			end
			else
			begin   // Convergence on delta(x)
		    	for i:=0 to pred(len) do
				 x[i]:= xold[i];

		    	m_f:= fold;

		    	//if (m_Debug)
				//System.err.println("Cannot find feasible lambda");
			end;

		//return x;
       result:= x;
       EXIT;
	    end
	    else
	    begin
       // Backtracking by polynomial interpolation
			if(k = 0)
			then
           begin // First time backtrack: quadratic interpolation
		    	if not(Math.isInfinite(initF))
					then initF := m_f;

		    	// lambda = -g'(0)/(2*g''(0))
		    	tmplam := -0.5*alam*m_Slope/((m_f-fold)/alam-m_Slope);
			end
			else
			begin    // Subsequent backtrack: cubic interpolation
		    	rhs1 := m_f-fold-alam*m_Slope;
		    	rhs2 := fhi-fold-alam2*m_Slope;
		    	a := (rhs1/(alam*alam)-rhs2/(alam2*alam2))/(alam-alam2);
		   	 	b := (-alam2*rhs1/(alam*alam)+alam*rhs2/(alam2*alam2))/(alam-alam2);

		    	if (a = 0.0) then tmplam := -m_Slope/(2.0*b)
		    	else
		    	begin
					disc :=b*b-3.0*a*m_Slope;
					if (disc < 0.0) then disc := 0.0;

					numerator := -b + sqrt(disc);

					if(numerator >= Math.MaxDouble)
					then
                   begin
			    		numerator := Math.MaxDouble;
			    		//if (m_Debug)
						//System.err.print("-b+sqrt(disc) too large! Set it to MAX_VALUE.");
					end;

					tmplam := numerator/(3.0*a);
		    	end;

               (*
		    	if (m_Debug)
				System.err.print("Cubic interpolation: \n" +
					 "a:   " + Utils.doubleToString(a,10,7)+ "\n" +
					 "b:   " + Utils.doubleToString(b,10,7)+ "\n" +
					 "disc:   " + Utils.doubleToString(disc,10,7)+ "\n" +
					 "tmplam:   " + tmplam + "\n" +
					 "alam:   " + Utils.doubleToString(alam,10,7)+ "\n");
               *)
               
		    	if (tmplam>0.5*alam)
					then tmplam :=0.5*alam;             // lambda <= 0.5*lambda_old
			end;
	    end;

	    alam2 := alam;
	    fhi := m_f;
	    alam := Math.max(tmplam,0.1*alam);          // lambda >= 0.1*lambda_old

	    if(alam>alpha)
	    then
       begin
           (*
			throw new Exception("Sth. wrong in lnsrch:"+
				    "Lambda infeasible!(lambda="+alam+
				    ", alpha="+alpha+", upper="+tmplam+
				    "|"+(-alpha*m_Slope/(2.0*((m_f-fold)/alpha-m_Slope)))+
				    ", m_f="+m_f+", fold="+fold+
				    ", slope="+m_Slope);
           *)
           Exception.Create('Sth. wrong in lnsrch');
	    end;


   inc(k);
	end; // Endfor(k=0;;k++)

	// Quadratic interpolation between lamda values between lo and hi.
	// If cannot find a value satisfying beta condition, use lo.
	ldiff := hi-lo;

   (*
	if(m_Debug)
	    System.err.println("Last stage of searching for beta condition (alam between "
			       +Utils.doubleToString(lo,10,7)+" and "
			       +Utils.doubleToString(hi,10,7)+")...\n"+
			       "Quadratic Interpolation(QI):\n"+
			       "Last newSlope = "+Utils.doubleToString(newSlope, 10, 7));
   *)

	while ((newSlope<m_BETA*m_Slope) and (ldiff>=alamin)) do
	begin
	    lincr := -0.5*newSlope*ldiff*ldiff/(fhi-flo-newSlope*ldiff);

       (*
	    if(m_Debug)
		System.err.println("fhi = "+fhi+"\n"+
				   "flo = "+flo+"\n"+
				   "ldiff = "+ldiff+"\n"+
				   "lincr (using QI) = "+lincr+"\n");
       *)

	    if(lincr<0.2*ldiff) then lincr:=0.2*ldiff;
	    alam := lo+lincr;

	    if(alam >= hi)
       then
       begin
	     // We cannot go beyond the bounds, so the best we can try is hi
	    	alam := hi;
			lincr := ldiff;
	    end;

	    for i:=0 to pred(len) do
			if not(isFixed[i])
		    	then x[i] := xold[i]+alam*direct[i];

	    m_f := objectiveFunction(x);

	    if (Math.isNaN(m_f))
			then Exception.create('Objective function value is NaN!');

	    if (m_f > fold+m_ALF*alam*m_Slope)
	    then
       begin
			// Alpha condition fails, shrink lambda_upper
			ldiff := lincr;
			fhi := m_f;
	    end
	    else
	    begin // Alpha condition holds
			newGrad := evaluateGradient(x);

           newSlope:= 0.0;
			for i:=0 to pred(len) do
		    	if not(isFixed[i])
					then newSlope:= newSlope + newGrad[i]*direct[i];

			if(newSlope < m_BETA*m_Slope)
			then
           begin
		    	// Beta condition fails, shrink lambda_lower
		    	lo := alam;
		    	ldiff:= ldiff - lincr;
		    	flo := m_f;
			end;
	    end;
	end;

	if(newSlope < m_BETA*m_Slope)
	then
   begin // Cannot satisfy beta condition, take lo
       (*
	    if(m_Debug)
		System.err.println("Beta condition cannot be satisfied, take alpha condition");
       *)

	    alam :=lo;
	    for i:=0 to pred(len) do
			if not(isFixed[i])
		    	then x[i] := xold[i]+alam*direct[i];

	    m_f := flo;
	end
	else;
	 //if(m_Debug)
	 //   System.err.println("Both alpha and beta conditions are satisfied. alam="
	 //		       +Utils.doubleToString(alam,10,7));
	
	if ((fixedOne <>-1) and (alam>=alpha))
		then
       begin // Has bounds and over
	    	if(direct[fixedOne] > 0)
	    	then
           begin
				x[fixedOne] := nwsBounds[1][fixedOne]; // Avoid rounding error
				nwsBounds[1][fixedOne] := Math.NaN; //Add cons. to working set
	    	end
	    	else
	    	begin
				x[fixedOne] := nwsBounds[0][fixedOne]; // Avoid rounding error
				nwsBounds[0][fixedOne] := Math.NaN; //Add cons. to working set
	    	end;

           (*
	    	if(m_Debug)
			System.err.println("Fix variable "
				   +fixedOne+" to bound "+ x[fixedOne]+
				   " from value "+ xold[fixedOne]);
           *)

	    	isFixed[fixedOne]:= true; // Fix the variable
	    	wsBdsIndx.addElement(fixedOne);
		end;

	//return x;
   result:= x;

end;

function TOptimization.objectiveFunction(x: TVector): float;
begin
 if assigned(FFuncObjective)
  then result:= FFuncObjective(x)
  else result:= MATH.NaN;
end;

function TOptimization.solveTriangle(t: TMatrix; b: TVector;
  isLower: boolean; isZero: array of Boolean): TVector;
begin

end;

procedure TOptimization.updateCholeskyFactor(L: TMatrix; D, v: TVector;
  coeff: double; isFixed: array of boolean);
begin

end;

end.

