unit UDlgOpPrmSpvMLogReg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls, Spin;

type
  TdlgOpPrmSpvMLogReg = class(TDlgBaseOperatorParameter)
    rgOptMethod: TRadioGroup;
    Label1: TLabel;
    spinIter: TSpinEdit;
    Label2: TLabel;
    edRidge: TEdit;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  procedure   ApplyModifications(); override;
  procedure   SetParameters(); override;
  end;

var
  dlgOpPrmSpvMLogReg: TdlgOpPrmSpvMLogReg;

implementation

uses UCompSpvMultinomialLogReg, UCalcSpvMutlinomialLogReg;

{$R *.dfm}

{ TdlgOpPrmSpvMLogReg }

procedure TdlgOpPrmSpvMLogReg.ApplyModifications;
var prm: TOpPrmSpvMLR;
begin
 prm:= OpPrm as TOpPrmSpvMLR;
 prm.OptMethod:= TEnumOptLogistic(self.rgOptMethod.ItemIndex);
 prm.MaxIteration:= self.spinIter.Value;
 TRY
 prm.Ridge:= StrToFloat(self.edRidge.Text);
 EXCEPT
 END;
end;

procedure TdlgOpPrmSpvMLogReg.SetParameters;
var prm: TOpPrmSpvMLR;
begin
 prm:= OpPrm as TOpPrmSpvMLR;
 self.rgOptMethod.ItemIndex:= ord(prm.OptMethod);
 self.spinIter.Value:= prm.MaxIteration;
 self.edRidge.Text:= FloatToStr(prm.Ridge);
end;

end.
