(****************************************************************************)
(* UCalcSpvSMOAttTransformation.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(****************************************************************************)

{
@abstract(Support vector machine)
@author(Ricco)
@created(13/04/2005)

Reproduction des classes de transformation/normalisation des donnes pour les SVM
}
unit UCalcSpvSMOAttTransformation;

interface

USES
   UDatasetExamples,
   UDatasetDefinition;

TYPE
  //type de normalisation des donnes -- uniquement donnes continues
  //0 - none ; 1 - normalisation (min-max) ; 2 - centrage-rduction
  TEnumAttTransformSVM = (atSVM_NONE,atSVM_NORMALIZE,atSVM_STANDARDIZE);

CONST
  STR_ATT_TRANSFORM_SVM : array[TEnumAttTransformSVM] of string = ('NONE','NORMALIZE','STANDARDIZE');

TYPE
  //classe de base -- NONE
  TAttTrans = class
              private
              FDescriptors: TLstAttributes;
              protected
              procedure   buildStructures(); virtual;
              procedure   destroyStructures(); virtual;
              procedure   computeStats(prmExamples: TExamples); virtual;
              function    getValue(j: integer; instance: integer): double; virtual;
              public
              constructor create(prmDescriptors: TLstAttributes; prmExamples: TExamples);
              destructor  destroy(); override;
              //attention, n attribut d'abord (indice 1), puis n d'individu par la suite (indice 2)
              property    cValue[j:integer;instance: integer]: double read getValue;
              end;

  //classe NORMALIZE
  TAttTransNormalize = class(TAttTrans)
                       private
                       //min
                       FMin: array of double;
                       //max
                       FRange: array of double;
                       protected
                       procedure   buildStructures(); override;
                       procedure   destroyStructures(); override;
                       //attention, petite entorse, les min et max sont calculs sur la base complte 
                       procedure   computeStats(prmExamples: TExamples); override;
                       function    getValue(j: integer; instance: integer): double; override;
                       end;

  //classe STANDARDIZE
  TAttTransStandardize = class(TAttTrans)
                         private
                         FAvg: array of double;
                         FStd: array of double;
                         protected
                         procedure   buildStructures(); override;
                         procedure   destroyStructures(); override;
                         procedure   computeStats(prmExamples: TExamples); override;
                         function    getValue(j: integer; instance: integer): double; override;
                         end;


implementation

USES
   Math, UCalcStatDes;

{ TAttTrans }

procedure TAttTrans.buildStructures;
begin
 //
end;

procedure TAttTrans.computeStats(prmExamples: TExamples);
begin
 //
end;

constructor TAttTrans.create(prmDescriptors: TLstAttributes;
  prmExamples: TExamples);
begin
 inherited Create();
 FDescriptors:= prmDescriptors;
 self.buildStructures();
 TRY
 self.computeStats(prmExamples);
 EXCEPT
 END;
end;

destructor TAttTrans.destroy;
begin
 self.destroyStructures();
 inherited;
end;

procedure TAttTrans.destroyStructures;
begin
 //
end;

function TAttTrans.getValue(j, instance: integer): double;
begin
 result:= FDescriptors.Attribute[j].cValue[instance];
end;

{ TAttTransNormalize }

procedure TAttTransNormalize.buildStructures;
begin
 setLength(FMin,FDescriptors.Count);
 setLength(FRange,FDescriptors.Count);
end;

procedure TAttTransNormalize.computeStats(prmExamples: TExamples);
var i,j: integer;
    att: TAttribute;
    min,max,value: double;
begin
 for j:= 0 to pred(FDescriptors.Count) do
  begin
   att:= FDescriptors.Attribute[j];
   min:= +Math.MaxSingle;
   max:= -Math.MaxSingle;
   for i:= 1 to att.Size do
    begin
     value:= att.cValue[i];
     if (value<min) then min:= value;
     if (value>max) then max:= value;
    end;
   //and then...
   FMin[j]:= min;
   FRange[j]:= max-min;
  end;
end;

procedure TAttTransNormalize.destroyStructures;
begin
 Finalize(FMin);
 Finalize(FRange);
end;

function TAttTransNormalize.getValue(j, instance: integer): double;
begin
 if (FRange[j]>0.0)
  then result:= (FDescriptors.Attribute[j].cValue[instance]-FMin[j])/FRange[j]
  else result:= FDescriptors.Attribute[j].cValue[instance];
end;

{ TAttTransStandardize }

procedure TAttTransStandardize.buildStructures;
begin
 setLength(FAvg,FDescriptors.Count);
 setLength(FStd,FDescriptors.Count);
end;

procedure TAttTransStandardize.computeStats(prmExamples: TExamples);
var lstStats: TLstCalcStatDesContinuous;
    j: integer;
begin
 lstStats:= TLstCalcStatDesContinuous.Create(Fdescriptors,prmExamples);
 for j:= 0 to pred(FDescriptors.Count) do
  begin
   FAvg[j]:= (lstStats.LstStat.Items[j] as TCalcStatDesContinuous).Average;
   if ((lstStats.LstStat.Items[j] as TCalcStatDesContinuous).StdDev > 0.0)
    then FStd[j]:= (lstStats.LstStat.Items[j] as TCalcStatDesContinuous).StdDev
    else FStd[j]:= 1.0;
  end;

end;

procedure TAttTransStandardize.destroyStructures;
begin
 Finalize(FAvg);
 Finalize(FStd);
end;

function TAttTransStandardize.getValue(j,
  instance: integer): double;
begin
 result:= (FDescriptors.Attribute[j].cValue[instance]-FAvg[j])/FStd[j];
end;

end.
